/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.liberacaomanualcnpjmei;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.LiberacaoManualCnpjMei;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.intelidata.regranegocio.LiberacaoManualCnpjMeiRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/liberacao-manual-cnpj-mei"})
@SubMenuMapping(MENU="SubMenuPortalCanalGeral", ICONE="icon-html", NOME="Libera\u00e7\u00e3o Manual de CNPJs MEI", ROTA="/intelidata/liberacao-manual-cnpj-mei", PROGRAMA=9000031)
public class LiberacaoManualCnpjMeiCrudController
extends CrudController<LiberacaoManualCnpjMei, LiberacaoManualCnpjMeiRN> {
    public LiberacaoManualCnpjMeiCrudController() {
        super((AbstractRegraNegocio)LiberacaoManualCnpjMeiRN.getInstance(), LiberacaoManualCnpjMei::new, TipoArquivoArmazenado.PrintLiberacaoCNPJMei);
    }

    protected GridBuilder<LiberacaoManualCnpjMeiRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("dataHora", "Data e hora", 300, true));
        colunas.add(new ColunaSQL("cnpj", "CNPJ", 200, true));
        colunas.add(new ColunaSQL("motivo", "Motivo", 0, true));
        GridBuilder grid = new GridBuilder(LiberacaoManualCnpjMeiRN.getInstance().getTabela(), colunas);
        grid.addOrdemDefault(new Ordem("dataHora"));
        return grid;
    }

    protected void beforeSave(LiberacaoManualCnpjMei liberacaoManualCnpjMei, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        liberacaoManualCnpjMei.setIdUsuario(SessaoUtil.getSessao().getIdUsuario());
        liberacaoManualCnpjMei.setCnpj(Util.apenasNumeros((String)liberacaoManualCnpjMei.getCnpj()));
        if (StringUtil.stringNullOrEmpty((String)liberacaoManualCnpjMei.getArquivoPrintLiberacao())) {
            throw new UnicoMensagemUsuarioException("ITL49", "Informe o print da consulta do CNPJ MEI");
        }
    }

    protected void beforeRead(LiberacaoManualCnpjMei liberacaoManualCnpjMei, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        liberacaoManualCnpjMei.setCnpj(Util.formataCpfCnpj((String)Util.apenasNumeros((String)liberacaoManualCnpjMei.getCnpj())));
    }

    public boolean isGravarArquivoTabela() {
        return true;
    }

    protected String getCacheId() {
        return "liberacao-manual-cnpj-mei";
    }
}

