/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.recoverypassword;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.domain.pojo.UsuarioReseteSenha;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.web.rest.app.recoverypassword.ResetPasswordEmailService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Service
public class ResetPasswordEmailService {
    private final Logger log = LoggerFactory.getLogger(ResetPasswordEmailService.class);
    private final TemplateEngine templateEngine;
    private final ConnectionOAuth2Service connectionOAuth2Service;

    @Autowired
    public ResetPasswordEmailService(TemplateEngine templateEngine, ConnectionOAuth2Service connectionOAuth2Service) {
        this.templateEngine = templateEngine;
        this.connectionOAuth2Service = connectionOAuth2Service;
    }

    public void sendMail(UsuarioReseteSenha usuarioSenha, String nomeUsuario, String version, String ambiente, String url) throws UnicoMensagemUsuarioException {
        Context context = new Context();
        context.setVariable("nome", (Object)nomeUsuario);
        context.setVariable("token", (Object)usuarioSenha.getToken());
        String tenant = ContextoHolder.getTenant();
        JsonEmail json = new JsonEmail(null);
        json.setVersao(version);
        json.setAmbiente(ambiente);
        json.setTenant(tenant);
        String params = Base64.getEncoder().encodeToString(JsonUtil.toJson((Object)json).getBytes(StandardCharsets.UTF_8));
        context.setVariable("link", (Object)(url + "/redefinir/" + usuarioSenha.getToken() + "/" + params + "?tenant=" + tenant));
        String msg = this.templateEngine.process("resetSenha", (IContext)context);
        this.log.info("Agendando o envio de email para '{}'", (Object)usuarioSenha.getEmail());
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("email", usuarioSenha.getEmail());
        parametros.put("assunto", "Redefinir senha");
        parametros.put("msg", msg);
        JSONObject elem = JSONUtil.getJSONObject(parametros);
        ResponseEntity response = this.connectionOAuth2Service.execute("/email-aws/", "enviar", elem, String.class, HttpMethod.POST, new Object[0]);
        if (response != null && response.getStatusCode() == HttpStatus.OK) {
            this.log.info("E-mail enviado para '{}'", (Object)usuarioSenha.getEmail());
        }
    }
}

