/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.estoque.movimentacaoestoque;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.CondicaoPagamento;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.FamiliaProduto;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.contabil.MesFiscal;
import br.intelidata.commons.domain.regranegocio.PautaPreco;
import br.intelidata.commons.modulo.cadastros.regranegocio.LicencaRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioMensalRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.estoque.relatorio.MovimentacaoEstoqueRelatorio;
import br.intelidata.commons.modulo.produto.regranegocio.FamiliaProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.GradeValorRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.estoque.movimentacaoestoque.MovimentacaoEstoque;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import unico.pojo.Licenca;

public class MovimentacaoEstoqueReportExecute
extends AbstractReporteExecute<MovimentacaoEstoque> {
    public MovimentacaoEstoqueReportExecute(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        MovimentacaoEstoque parametros = (MovimentacaoEstoque)this.fromJson(parametrosObj, MovimentacaoEstoque.class);
        return this.executa(sessao, parametros);
    }

    public Remessa executa(Sessao sessao, MovimentacaoEstoque movimentacaoEstoqueWrapper) throws UnicoMensagemUsuarioException {
        Entidade entidade = null;
        Entidade fornecedor = null;
        Produto produto = null;
        String familia = null;
        List linhas = null;
        List colunas = null;
        if (movimentacaoEstoqueWrapper.getTipoModelo() == 2) {
            this.validarCustoMedio(movimentacaoEstoqueWrapper);
        }
        if (!NumberUtil.longNullOuZero((Long)movimentacaoEstoqueWrapper.getIdFornecedor())) {
            fornecedor = (Entidade)EntidadeRN.getInstance().buscarPorId(movimentacaoEstoqueWrapper.getIdFornecedor());
        }
        if (!NumberUtil.longNullOuZero((Long)movimentacaoEstoqueWrapper.getIdEntidade())) {
            entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(movimentacaoEstoqueWrapper.getIdEntidade());
        }
        if (!NumberUtil.longNullOuZero((Long)movimentacaoEstoqueWrapper.getIdProduto())) {
            produto = (Produto)ProdutoRN.getInstance().buscarPorId(movimentacaoEstoqueWrapper.getIdProduto());
        }
        if (!NumberUtil.longNullOuZero((Long)movimentacaoEstoqueWrapper.getIdFamilia())) {
            familia = ((FamiliaProduto)FamiliaProdutoRN.getInstance().buscarPorId(movimentacaoEstoqueWrapper.getIdFamilia())).getNome();
        }
        if (!ListMapUtil.listNullOrEmpty((List)movimentacaoEstoqueWrapper.getLinhas())) {
            linhas = GradeValorRN.getInstance().buscaPorIds(movimentacaoEstoqueWrapper.getLinhas());
        }
        if (!ListMapUtil.listNullOrEmpty((List)movimentacaoEstoqueWrapper.getColunas())) {
            colunas = GradeValorRN.getInstance().buscaPorIds(movimentacaoEstoqueWrapper.getColunas());
        }
        return new MovimentacaoEstoqueRelatorio().getRelatorio(movimentacaoEstoqueWrapper.getSaida(), movimentacaoEstoqueWrapper.getFiliais(), movimentacaoEstoqueWrapper.getIdsLocalEstoque(), movimentacaoEstoqueWrapper.getPeriodoInicial(), movimentacaoEstoqueWrapper.getPeriodoFinal(), movimentacaoEstoqueWrapper.getIdGrupoProduto(), produto, entidade, fornecedor, movimentacaoEstoqueWrapper.getTipoMovimento().intValue(), movimentacaoEstoqueWrapper.isExibirMovimentosVariacao(), movimentacaoEstoqueWrapper.getDescricaoTipoMovimento(), movimentacaoEstoqueWrapper.getTipoModelo().intValue(), movimentacaoEstoqueWrapper.isImprimirProdutos(), movimentacaoEstoqueWrapper.getTipoDocumento(), movimentacaoEstoqueWrapper.getDescricaoTipoDocumento(), movimentacaoEstoqueWrapper.getTipoOrdenacao().intValue(), movimentacaoEstoqueWrapper.getDescricaoOrdenacao(), linhas, colunas, movimentacaoEstoqueWrapper.getIdFamilia(), familia, movimentacaoEstoqueWrapper.isImprimirSaldo(), movimentacaoEstoqueWrapper.getIdFabricante(), movimentacaoEstoqueWrapper.getIdMarca(), movimentacaoEstoqueWrapper.getValorizacao(), movimentacaoEstoqueWrapper.getIdListaProdutos());
    }

    private Map<String, Object> montarParametros(PautaPreco pautaPreco, CondicaoPagamento condicaoPagamento) {
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("pautaPreco", pautaPreco);
        if (condicaoPagamento != null) {
            parametros.put("condicaoPagamento", condicaoPagamento);
        }
        return parametros;
    }

    private void validarCustoMedio(MovimentacaoEstoque movimentacaoEstoqueWrapper) throws UnicoMensagemUsuarioException {
        LocalDate dataBaseFinal;
        if (NumberUtil.longNullOuZero((Long)movimentacaoEstoqueWrapper.getIdEmpresa())) {
            Licenca licencaPrincipal = LicencaRN.getInstance().buscarLicencaPrincipal();
            for (Filial filial : movimentacaoEstoqueWrapper.getFiliais()) {
                if (StringUtil.isCnpjFilhoDe((String)filial.getCnpj(), (String)licencaPrincipal.getCnpj())) continue;
                throw new UnicoMensagemUsuarioException("WEST14", "Por favor selecione apenas as filiais de uma mesma empresa");
            }
        }
        if (movimentacaoEstoqueWrapper.getPeriodoInicial() == null) {
            throw new UnicoMensagemUsuarioException("WEST57", "Por favor informe o per\u00edodo inicial.");
        }
        LocalDate dataBaseInicial = movimentacaoEstoqueWrapper.getPeriodoInicial().withDayOfMonth(1);
        LocalDate localDate = dataBaseFinal = movimentacaoEstoqueWrapper.getPeriodoFinal() == null ? DataHoraFactory.getData().withDayOfMonth(1) : movimentacaoEstoqueWrapper.getPeriodoFinal().withDayOfMonth(1);
        while (dataBaseInicial.compareTo(dataBaseFinal) < 1) {
            String ano = String.valueOf(dataBaseInicial.getYear());
            MesFiscal mes = (MesFiscal)EnumUtils.getPorId(MesFiscal.class, (Object)dataBaseInicial.getMonthValue());
            for (Filial filial : movimentacaoEstoqueWrapper.getFiliais()) {
                if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CUSTO_MEDIO_MENSAL)) {
                    if (!CustoMedioMensalRN.getInstance().isExisteRegistrosPendentesDeCalculo(filial.getIdEmpresa(), ano, mes)) continue;
                    throw new UnicoMensagemUsuarioException("WEST58", "Existe c\u00e1lculo de custo m\u00e9dio pendente no per\u00edodo especificado. Por favor verifique.");
                }
                if (!CustoMedioDiarioRN.getInstance().isExisteRegistrosPendentesDeCalculo(filial.getId(), ano, mes)) continue;
                throw new UnicoMensagemUsuarioException("WEST59", "Existe c\u00e1lculo de custo m\u00e9dio pendente no per\u00edodo especificado. Por favor verifique.");
            }
            dataBaseInicial = dataBaseInicial.plusMonths(1L);
        }
    }
}

