/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.uniplusshop;

import br.intelidata.api.b2c.service.placeholder.PlaceHolderCDNService;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.SaidaRelatorio;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.web.rest.app.report.uniplusshop.ProdutoSemImagem;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ProdutoSemImagemRelatorio {
    private final PlaceHolderCDNService placeHolderCDNService;
    private List<String> imagens;

    public ProdutoSemImagemRelatorio(PlaceHolderCDNService placeHolderCDNService) {
        this.placeHolderCDNService = placeHolderCDNService;
    }

    public Remessa getRelatorio(SaidaRelatorio saida) throws UnicoMensagemUsuarioException {
        this.buscarImagens();
        USelect uSelect = new USelect(ProdutoRN.getInstance().getTabela());
        uSelect.add(new ColunaSQL("codigo"));
        uSelect.add(new ColunaSQL("nome"));
        uSelect.add(new ColunaSQL("ean"));
        uSelect.add((ColunaSQL)new Referencia("enviaecommerce"));
        uSelect.add((ColunaSQL)new Referencia("caminhoimagem"));
        uSelect.add(new Condicao("enviaecommerce", Operador.IGUAL, EnumSimNao.SIM.getId().intValue()));
        uSelect.add(new Condicao(OperadorLogico.E));
        uSelect.add(new Condicao(Separador.ABRE_PARENTESIS));
        uSelect.add(new Condicao("caminhoimagem", Operador.IS_NULL));
        uSelect.add(new Condicao(OperadorLogico.OU));
        uSelect.add(new Condicao("caminhoimagem", Operador.IGUAL, ""));
        uSelect.add(new Condicao(Separador.FECHA_PARENTESIS));
        ArrayList<ProdutoSemImagem> criticas = new ArrayList<ProdutoSemImagem>();
        Sql sql = new Sql(uSelect);
        sql.executaQuery();
        while (sql.next()) {
            ProdutoSemImagem critica2 = new ProdutoSemImagem(sql.getString("codigo"), sql.getString("ean"), sql.getString("nome"));
            if (Util.stringNullOrEmpty((String)critica2.getEan())) {
                critica2.setSemImagem(true);
            }
            criticas.add(critica2);
        }
        sql.close();
        criticas.stream().filter(critica -> !Util.stringNullOrEmpty((String)critica.getEan())).forEach(arg_0 -> this.validarImagem(arg_0));
        UViewer uViewer = new UViewer(saida, "Produtos sem imagens", new int[]{10, 30, 10});
        uViewer.inicioRelatorio();
        uViewer.inicioTitulo();
        uViewer.escreveTitulo("Produto", false);
        uViewer.escreveTitulo("Nome", false);
        uViewer.escreveTitulo("EAN", false);
        uViewer.escreveTitulo("Cr\u00edtica", false);
        uViewer.fimTitulo();
        criticas.stream().filter(ProdutoSemImagem::isSemImagem).forEach(critica -> {
            uViewer.inicioLinha();
            uViewer.escreveColuna(critica.getCodigo());
            uViewer.escreveColuna(critica.getNome());
            uViewer.escreveColuna(critica.getEan());
            uViewer.fimLinha();
        });
        uViewer.fimRelatorio();
        return uViewer.getRemessa();
    }

    private void validarImagem(ProdutoSemImagem criticaProduto) {
        String eanRadix;
        try {
            eanRadix = String.valueOf(Long.parseLong(criticaProduto.getEan().trim(), 13));
        }
        catch (NumberFormatException e) {
            eanRadix = criticaProduto.getEan().trim();
        }
        criticaProduto.setSemImagem(!this.imagens.contains(eanRadix));
    }

    private void buscarImagens() {
        ListObjectsV2Result result;
        this.imagens = new ArrayList();
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(this.placeHolderCDNService.getBucket()).withMaxKeys(Integer.valueOf(1000));
        do {
            result = this.placeHolderCDNService.getAmazonS3().listObjectsV2(request);
            for (S3ObjectSummary objectSummary : result.getObjectSummaries()) {
                this.imagens.add(objectSummary.getKey().split("_")[0]);
            }
            request.setContinuationToken(result.getNextContinuationToken());
        } while (result.isTruncated());
    }
}

