/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.versao;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.uniplusweb.core.sgbd.ConnectionHandler;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.SystemUtil;
import br.intelidata.uniplusweb.service.DownloadService;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.wrapper.VersaoWrapper;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDownloadVersao
extends AbstractPrepareJob {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DIRETORIO = SystemUtil.getDiretorioAplicacao() + File.separator + "builds_web" + File.separator;
    private VersaoWrapper versao;

    public JobDownloadVersao(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao("Download da vers\u00e3o " + this.versao.getDescricao() + " finalizado com sucesso.");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao("N\u00e3o foi poss\u00edvel realizar o download da vers\u00e3o " + this.versao.getDescricao());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        ConnectionHandler connectionHandler = (ConnectionHandler)BeanUtil.getBean((String)"connectionHandler");
        connectionHandler.commit();
        connectionHandler.releaseConnection();
        this.versao = (VersaoWrapper)this.getObjetoDeserializado(VersaoWrapper.class);
        String nomeArquivo = this.versao.getLink().substring(this.versao.getLink().lastIndexOf("/") + 1);
        String destino = DIRETORIO + nomeArquivo;
        try {
            DownloadService downloadService = (DownloadService)BeanUtil.getBean((String)"downloadService");
            downloadService.saveFileInDirectory(this.versao.getLink(), destino);
            File arquivo = new File(destino);
            boolean arquivoExiste = arquivo.exists();
            if (!arquivoExiste || !this.isMd5ArquivoValido(this.versao, arquivo)) {
                if (!arquivo.delete()) {
                    FileUtils.forceDelete((File)arquivo);
                }
                throw new UnicoMensagemUsuarioException("WWW383", "N\u00e3o foi poss\u00edvel realizar o download do arquivo.");
            }
        }
        finally {
            connectionHandler.createConnection(false);
        }
    }

    private boolean isMd5ArquivoValido(VersaoWrapper versao, File arquivo) {
        try {
            String md5Arquivo = FileUtil.getMd5String((File)arquivo);
            if (md5Arquivo.equalsIgnoreCase(versao.getMd5())) {
                String nomeArquivo = versao.getLink().substring(versao.getLink().lastIndexOf("/") + 1).replace(".zip", ".md5");
                FileUtil.salvarStringEmArquivo((String)md5Arquivo, (String)(DIRETORIO + nomeArquivo));
                return true;
            }
            this.log.info("Md5 ({}) da vers\u00e3o {} \u00e9 diferente do md5 do arquivo {}", new Object[]{versao.getMd5(), versao.getDescricao(), md5Arquivo});
            return false;
        }
        catch (UnicoMensagemUsuarioException ex) {
            this.log.error("N\u00e3o foi poss\u00edvel validar o MD5", (Throwable)ex);
            return false;
        }
    }
}

