/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.adm;

import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.adm.SystemStatus;
import br.intelidata.uniplusweb.adm.SystemStatusService;
import br.intelidata.uniplusweb.adm.TenantWrapper;
import br.intelidata.uniplusweb.adm.job.JobBackup;
import br.intelidata.uniplusweb.adm.job.JobRestoreAWS;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.service.BackupService;
import br.intelidata.uniplusweb.core.service.RestoreBackupService;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.service.MDCConfigService;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.map.ExecucaoScheduler;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobExecutorService;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobTask;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs-admin"})
public class AdminController {
    private UnipluswebProperties unipluswebProperties;
    private JdbcTemplate jdbcTemplate;
    private JobExecutorService jobExecutorService;
    private MDCConfigService mdcConfigService;
    private IConnectionHandler connectionHandler;
    private TenantService tenantService;
    private ConnectionOAuth2Service connectionOAuth2Service;
    private BackupService backupService;
    private RestoreBackupService restoreBackupService;
    private final SystemStatusService systemStatusService;

    @Autowired
    public AdminController(DataSource dataSource, UnipluswebProperties unipluswebProperties, JobExecutorService jobExecutorService, MDCConfigService mdcConfigService, IConnectionHandler connectionHandler, TenantService tenantService, ConnectionOAuth2Service connectionOAuth2Service, BackupService backupService, RestoreBackupService restoreBackupService, SystemStatusService systemStatusService) {
        this.unipluswebProperties = unipluswebProperties;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.jobExecutorService = jobExecutorService;
        this.mdcConfigService = mdcConfigService;
        this.connectionHandler = connectionHandler;
        this.tenantService = tenantService;
        this.connectionOAuth2Service = connectionOAuth2Service;
        this.backupService = backupService;
        this.restoreBackupService = restoreBackupService;
        this.systemStatusService = systemStatusService;
    }

    @RequestMapping(value={"/estou-vivo"})
    public void iamLive() {
    }

    @RequestMapping(value={"/system-status"}, method={RequestMethod.GET})
    public SystemStatus getSystemStatus() {
        SystemStatus systemStatus = this.systemStatusService.getSystemStatus();
        if (systemStatus.getUniplusSchedulers() != null) {
            TreeMap<String, List> novoMap = new TreeMap<String, List>();
            for (Map.Entry stringListEntry : systemStatus.getUniplusSchedulers().entrySet()) {
                for (ExecucaoScheduler execucaoSchedulerOrig : (List)stringListEntry.getValue()) {
                    ExecucaoScheduler execucaoSchedulerNovo = (ExecucaoScheduler)SerializationUtils.clone((Serializable)execucaoSchedulerOrig);
                    String descJob = execucaoSchedulerNovo.getDescricao();
                    execucaoSchedulerNovo.setDescricao((String)stringListEntry.getKey());
                    novoMap.computeIfAbsent(descJob, s -> new ArrayList()).add(execucaoSchedulerNovo);
                }
            }
            systemStatus.setUniplusSchedulers(novoMap);
        }
        return systemStatus;
    }

    @RequestMapping(value={"/criar-database"}, method={RequestMethod.POST})
    public void criarDatabase(@RequestBody TenantWrapper tenantWrapper) throws UnicoMensagemUsuarioException {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(Object.class);
        Tenant tenant = tenantWrapper.getTenant();
        List ids = this.jdbcTemplate.query("SELECT id FROM tenant WHERE codigo = ?", (RowMapper)rowMapper, new Object[]{tenant.getCodigo()});
        if (!ListMapUtil.listNullOrEmpty((List)ids)) {
            throw new UnicoMensagemUsuarioException("WWW352", "O tenant " + tenant.getCodigo() + " j\u00e1 existe.");
        }
        String database = "uniplusweb_" + tenant.getCodigo().toLowerCase();
        tenant.setUrlDatabase(this.unipluswebProperties.getDatasource().getUrl().replace("uniplusweb", database));
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.execute("CREATE DATABASE " + database);
        this.jdbcTemplate.update("INSERT INTO tenant(codigo, descricao, inativo, inicializado, urldatabase, secret) values (?, ?, ?, ?, ?, ?)", new Object[]{tenant.getCodigo(), tenant.getDescricao(), tenant.getInativo(), 0, tenant.getUrlDatabase(), tenant.getSecret()});
        if (tenant.isDemonstracao() && !StringUtil.stringNullOrEmpty((String)tenantWrapper.getAmbiente()) && !StringUtil.stringNullOrEmpty((String)tenantWrapper.getArquivo())) {
            this.agendarRestauracao(tenantWrapper);
        }
    }

    @RequestMapping(value={"/alterar-database"}, method={RequestMethod.POST})
    public void alterarDatabase(@RequestBody TenantWrapper tenantWrapper) {
        Tenant tenant = tenantWrapper.getTenant();
        this.jdbcTemplate.update("UPDATE tenant SET codigo = ?, descricao = ?, inativo = ? WHERE codigo = ?", new Object[]{tenant.getCodigo(), tenant.getDescricao(), tenant.getInativo(), tenant.getCodigo()});
        if (!tenant.isAtivo()) {
            this.encerrarConexoes("uniplusweb_" + tenant.getCodigo().toLowerCase());
        }
    }

    @RequestMapping(value={"/drop-database"}, method={RequestMethod.POST})
    public void dropDatabase(@RequestBody TenantWrapper tenantWrapper) {
        Tenant tenant = tenantWrapper.getTenant();
        String database = this.tenantService.getDatabase(tenant.getCodigo());
        if (!StringUtil.stringNullOrEmpty((String)database)) {
            database = database.toLowerCase();
            this.encerrarConexoes(database);
            this.jdbcTemplate.update("DELETE FROM tenant WHERE codigo = ?", new Object[]{tenant.getCodigo()});
            this.jdbcTemplate.execute("DROP DATABASE IF EXISTS " + database);
        }
    }

    @RequestMapping(value={"/agendar-backup"}, method={RequestMethod.POST})
    public void agendarBackup(@RequestBody TenantWrapper tenantWrapper) {
        JobBackup job = new JobBackup(this.mdcConfigService, tenantWrapper.getTenant(), this.unipluswebProperties, this.connectionOAuth2Service, this.backupService, this.connectionHandler, this.tenantService, tenantWrapper.getAmbiente());
        this.jobExecutorService.executeJobTask((JobTask)job, TipoJob.BACKUP);
    }

    @RequestMapping(value={"/agendar-restauracao"}, method={RequestMethod.POST})
    public void agendarRestauracao(@RequestBody TenantWrapper tenantWrapper) {
        JobRestoreAWS job = new JobRestoreAWS(this.restoreBackupService, tenantWrapper.getTenant(), tenantWrapper.getAmbiente(), tenantWrapper.getArquivo());
        this.jobExecutorService.executeJobTask((JobTask)job, TipoJob.RESTORE_BACKUP);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PreparedStatement getStatement(Connection connection, Tenant tenant) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement("INSERT INTO tenant(codigo, descricao, inativo, inicializado, urldatabase, secret) values (?, ?, ?, ?, ?, ?)");){
            ps.setString(1, tenant.getCodigo());
            ps.setString(2, tenant.getDescricao());
            ps.setInt(3, tenant.getInativo());
            ps.setInt(4, 0);
            ps.setString(5, tenant.getUrlDatabase());
            ps.setString(6, tenant.getSecret());
            PreparedStatement preparedStatement = ps;
            return preparedStatement;
        }
        catch (SQLException e) {
            throw new UnicoException("WWW527", (Throwable)e);
        }
    }

    private void encerrarConexoes(String database) {
        this.jdbcTemplate.execute("SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE pid <> pg_backend_pid() AND datname = '" + database + "';");
    }
}

