/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.adm.job;

import br.intelidata.commons.bridge.Bridge;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.service.BackupService;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.service.MDCConfigService;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobTask;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class JobBackup
extends JobTask {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MDCConfigService mdcConfigService;
    private Tenant tenant;
    private BackupService backupService;
    private UnipluswebProperties unipluswebProperties;
    private ConnectionOAuth2Service connectionOAuth2Service;
    private IConnectionHandler connectionHandler;
    private TenantService tenantService;
    private String ambiente;

    public JobBackup(MDCConfigService mdcConfigService, Tenant tenant, UnipluswebProperties unipluswebProperties, ConnectionOAuth2Service connectionOAuth2Service, BackupService backupService, IConnectionHandler connectionHandler, TenantService tenantService, String ambiente) {
        this.mdcConfigService = mdcConfigService;
        this.tenant = tenant;
        this.backupService = backupService;
        this.unipluswebProperties = unipluswebProperties;
        this.connectionOAuth2Service = connectionOAuth2Service;
        this.connectionHandler = connectionHandler;
        this.tenantService = tenantService;
        this.ambiente = ambiente;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ContextoHolder.setTenant((String)this.tenant.getCodigo(), (String)this.tenantService.getDatabase(this.tenant.getCodigo()));
            this.connectionHandler.createConnection(false);
            this.connectionHandler.beginTransaction();
            Bridge.getBridge().initCache();
            this.mdcConfigService.confiMDC(this.tenant.getCodigo());
            String url = this.unipluswebProperties.getDatasource().getRawUrl();
            String username = this.unipluswebProperties.getDatasource().getUsername();
            String password = this.unipluswebProperties.getDatasource().getPassword();
            this.log.info("Iniciando processo de backup.");
            boolean sucesso = this.backupService.backupAmazon(this.tenant.getCodigo(), ContextoHolder.getDatabase(), this.ambiente, url, username, password);
            this.atualizarDadosRestauracao(this.tenant.getCodigo(), sucesso ? "Backup realizado com sucesso" : "O backup foi realizado com erros. Verifique!");
        }
        catch (Exception ex) {
            this.connectionHandler.rollback();
            this.atualizarDadosRestauracao(this.tenant.getCodigo(), "O backup n\u00e3o pode ser realizado.");
            this.log.error("N\u00e3o foi poss\u00edvel realizar o backup.", (Throwable)ex);
        }
        finally {
            Bridge.getBridge().remove();
            if (this.connectionHandler.isConnected()) {
                this.connectionHandler.releaseConnection();
            }
        }
    }

    private void atualizarDadosRestauracao(String tenant, String log) {
        try {
            JSONObject object = new JSONObject().put("tenant", (Object)tenant).put("log", (Object)log);
            ResponseEntity response = this.connectionOAuth2Service.post("/tenant/backup", object, Void.class);
            if (response.getStatusCode() != HttpStatus.OK) {
                this.log.error("N\u00e3o foi poss\u00edvel atualizar os dados de backup do tenant no Logtracker");
            }
        }
        catch (Exception ex) {
            this.log.error("N\u00e3o foi poss\u00edvel atualizar os dados de backup do tenant no Logtracker", (Throwable)ex);
        }
    }
}

