/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.config;

import br.intelidata.commons.bridge.TipoCache;
import br.intelidata.commons.core.util.CacheSistema;
import br.intelidata.uniplusweb.config.CacheConfiguration;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.spring.Cache.CacheDevice;
import br.intelidata.uniplusweb.core.spring.Cache.MapDbCacheManager;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CacheConfiguration {
    private final Logger log = LoggerFactory.getLogger(CacheConfiguration.class);
    @Autowired
    UnipluswebProperties unipluswebProperties;

    @Bean
    public CacheManager cacheManager() throws IOException {
        MapDbCacheManager cacheManager;
        CacheDevice cacheDevice = this.unipluswebProperties.getCache().getCacheDevice();
        int duracaoEmSegundos = this.unipluswebProperties.getCache().getTempoDuracaoEmSegundos();
        this.log.info("Cache permanente em {}", (Object)cacheDevice);
        if (this.unipluswebProperties.getCache().isCacheObjetosAtivo()) {
            this.log.info("Cache de objetos ativado!");
            CacheSistema.getInstance().setUsaCacheSistema(true);
            switch (1.$SwitchMap$br$intelidata$uniplusweb$core$spring$Cache$CacheDevice[cacheDevice.ordinal()]) {
                case 1: {
                    cacheManager = new MapDbCacheManager(duracaoEmSegundos);
                    break;
                }
                default: {
                    cacheManager = new CaffeineCacheManager(new String[]{"cacheService", TipoCache.POJO.toString(), TipoCache.UNIDADE_MEDIDA.toString(), TipoCache.CASAS_DEC_PRODUTO.toString(), TipoCache.CASAS_DEC_CUSTO_PRODUTO.toString(), TipoCache.CFOP.toString()});
                    ((CaffeineCacheManager)cacheManager).setCaffeine(this.caffeineCacheBuilder(duracaoEmSegundos, 100, 1000));
                    break;
                }
            }
        } else {
            this.log.info("Cache de objetos desativado!");
            switch (1.$SwitchMap$br$intelidata$uniplusweb$core$spring$Cache$CacheDevice[cacheDevice.ordinal()]) {
                case 1: {
                    cacheManager = new MapDbCacheManager(duracaoEmSegundos);
                    break;
                }
                default: {
                    cacheManager = new CaffeineCacheManager(new String[]{"cacheService"});
                    ((CaffeineCacheManager)cacheManager).setCaffeine(this.caffeineCacheBuilder(duracaoEmSegundos, 100, 1000));
                }
            }
        }
        return cacheManager;
    }

    private Caffeine<Object, Object> caffeineCacheBuilder(int duracao, int iniCap, int maxSize) {
        return Caffeine.newBuilder().initialCapacity(iniCap).maximumSize((long)maxSize).softValues();
    }
}

