/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.config;

import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.web.enums.TipoBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.broker.BrokerAvailabilityEvent;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.DefaultManagedTaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration
@EnableWebSocketMessageBroker
@EnableWebSocket
public class WebSocketConfiguration
implements WebSocketMessageBrokerConfigurer,
ApplicationListener<BrokerAvailabilityEvent> {
    private static Logger logger = LoggerFactory.getLogger(WebSocketConfiguration.class);
    @Autowired
    private UnipluswebProperties unipluswebProperties;

    public void configureMessageBroker(MessageBrokerRegistry config) {
        if (this.unipluswebProperties.getBroker().getTipoBroker() == TipoBroker.interno) {
            logger.info("Iniciando broker interno");
            config.setApplicationDestinationPrefixes(new String[]{"/app"});
            config.enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler((TaskScheduler)new DefaultManagedTaskScheduler()).setHeartbeatValue(new long[]{20000L, 20000L});
        } else {
            logger.info("Iniciando broker externo em {}", (Object)this.unipluswebProperties.getBroker().getUrl());
            config.enableStompBrokerRelay(new String[]{"/topic"}).setRelayHost(this.unipluswebProperties.getBroker().getUrl()).setRelayPort(this.unipluswebProperties.getBroker().getPort().intValue()).setSystemLogin(this.unipluswebProperties.getBroker().getUsername()).setSystemPasscode(this.unipluswebProperties.getBroker().getPassword()).setAutoStartup(true);
        }
    }

    public void onApplicationEvent(BrokerAvailabilityEvent e) {
        logger.info(e.toString());
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/ws"}).setAllowedOrigins(new String[]{"*"});
    }
}

