/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.grid;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.sql.EnumJoin;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.FieldDefinition;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.Grid;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.grid.Operator;
import br.intelidata.uniplusweb.core.grid.ParentField;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.print.SaidaImpressaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import com.lowagie.text.Font;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class Grid<RN extends AbstractRegraNegocio<?, ?>>
implements Serializable {
    public static final String TIPO_STRING = "String";
    public static final String TIPO_DATE = "Date";
    public static final String TIPO_NUMBER = "Number";
    public static final String TIPO_INTEGER = "Integer";
    public static final String TIPO_ORDEM = "Ordem";
    protected Class<?>[] classe;
    private GridBuilder<?> gridBuilder;
    private int[] colsWidth;
    private int[] indiceResultSet;

    public Grid() {
    }

    public Grid(GridBuilder<RN> gridBuilder) {
        this.gridBuilder = gridBuilder;
        this.preparaGrid(this.getColunasSql());
    }

    public void setGridBuilder(GridBuilder<?> gridBuilder) {
        this.gridBuilder = gridBuilder;
        this.preparaGrid(this.getColunasSql());
    }

    private void preparaGrid(List<ColunaSQL> colunas) {
        int numcolsvisivel = colunas.stream().filter(ColunaSQL::isVisivel).collect(Collectors.toList()).size();
        this.colsWidth = new int[numcolsvisivel];
        this.classe = new Class[numcolsvisivel];
        this.indiceResultSet = new int[numcolsvisivel];
        this.determinaTipoColunas(colunas);
        int col = 0;
        for (ColunaSQL colunaSQL : colunas) {
            int width;
            if (!colunaSQL.isVisivel()) continue;
            this.colsWidth[col] = width = colunaSQL.getTamanho();
            ++col;
        }
    }

    private void determinaTipoColunas(List<ColunaSQL> colunas) {
        int numcolvisivel = 0;
        int numcolrs = 0;
        for (ColunaSQL colunaSQL : colunas) {
            Coluna coluna = this.gridBuilder.getDefinicaoColuna(this.gridBuilder.getTabela(), colunaSQL);
            if (colunaSQL.isVisivel()) {
                this.classe[numcolvisivel] = coluna.getClasseEnum() == null ? (colunaSQL.getClasseValor() != null ? colunaSQL.getClasseValor() : coluna.getTipoDado().getClasseJava()) : Enum.class;
                this.indiceResultSet[numcolvisivel] = numcolrs;
                ++numcolvisivel;
            }
            ++numcolrs;
        }
    }

    public String getDataJSON(int paginaInicial, int tamanhoPagina) {
        return this.getDataJSON(paginaInicial, tamanhoPagina, null, null, null);
    }

    protected void configuraGridControler(int paginaInicial, int tamanhoPagina, String query, List<FilterField> filters, String parent, List<CustomFilterGrid> customFilters) {
        int itemInicial = 0;
        if (paginaInicial == 2) {
            itemInicial = this.gridBuilder.getPaginaInicial();
        } else if (paginaInicial > 2) {
            itemInicial = this.gridBuilder.getPaginaInicial() + (paginaInicial - 2) * tamanhoPagina;
        }
        this.gridBuilder.setPaginaAtual(itemInicial);
        this.gridBuilder.setQuantidadeRegistroPorPagina(tamanhoPagina);
        if (this.gridBuilder.isLimparCondicoes()) {
            this.gridBuilder.limparCondicoes();
        }
        this.parent(parent);
        if (query == null || query.isEmpty()) {
            this.gridBuilder.limparCondicoesPesquisaRapida();
        } else {
            this.trataPesquisaRapida(query);
        }
        if (!ListMapUtil.listNullOrEmpty(customFilters)) {
            customFilters.forEach(f -> f.addFilter(this, filters));
        }
        this.filtro(filters);
    }

    public List<Object[]> getDadosWeb(int paginaInicial, int tamanhoPagina, String query, String parent, List<FilterField> filters, List<CustomFilterGrid> customFilters) {
        this.configuraGridControler(paginaInicial, tamanhoPagina, query, filters, parent, customFilters);
        return this.gridBuilder.getDadosWeb();
    }

    public int getTotalRegistros() {
        return this.gridBuilder.getTotalRegistros("id");
    }

    public int getTotalRegistros(String colunaTotalizador) {
        return this.gridBuilder.getTotalRegistros(colunaTotalizador);
    }

    public List<ColunaSQL> getColunasSql() {
        return this.gridBuilder.getColunasSql();
    }

    public String getDataJSON(int paginaInicial, int tamanhoPagina, String query, String parent, List<FilterField> filters) {
        return JsonUtil.toJson((List)this.getDadosWeb(paginaInicial, tamanhoPagina, query, parent, filters, null), (List)this.getColunasSql());
    }

    public List<FieldDefinition> getFieldsDefinition() {
        ArrayList<FieldDefinition> lista = new ArrayList<FieldDefinition>();
        List colunasSQL = this.getColunasSql();
        for (ColunaSQL colunaSQL : colunasSQL) {
            FieldDefinition fieldDefinition;
            Coluna coluna = this.gridBuilder.getDefinicaoColuna(this.gridBuilder.getTabela(), colunaSQL);
            if (coluna.getTipoDado().getClasseJava() != String.class && coluna.getTipoDado().getClasseJava() != Integer.class && coluna.getTipoDado().getClasseJava() != Long.class && coluna.getTipoDado().getClasseJava() != BigDecimal.class && coluna.getTipoDado().getClasseJava() != java.util.Date.class) {
                throw new RuntimeException("Filtro avan\u00e7ado n\u00e3o suporta a classe " + coluna.getTipoDado().getClasseJava());
            }
            if (colunaSQL.getTipoDadoBase() == null) {
                colunaSQL.setTipoDadoBase(coluna.getTipoDado());
            }
            if (coluna.getClasseEnum() != null || colunaSQL.getClasseEnum() != null) {
                fieldDefinition = new FieldDefinition(colunaSQL.getAlias(), colunaSQL.getDescricao(), coluna.getTipoDado(), colunaSQL.getTamanho(), colunaSQL.isVisivel(), JsonUtil.enumConstantsToJson((Class)(coluna.getClasseEnum() != null ? coluna.getClasseEnum() : colunaSQL.getClasseEnum()), (boolean)true));
            } else {
                TipoDadoBase tipodado = coluna.getTipoDado();
                if (colunaSQL.getNome().equalsIgnoreCase("codigo") && colunaSQL.getAlias().equalsIgnoreCase("codigo") && Funcao.TO_NUMBER.equals((Object)colunaSQL.getFuncao()) || colunaSQL.isTipoDadoBaseCustomizado()) {
                    tipodado = colunaSQL.getTipoDadoBase();
                }
                fieldDefinition = new FieldDefinition(colunaSQL.getAlias(), colunaSQL.getDescricao(), tipodado, colunaSQL.getTamanho(), colunaSQL.isVisivel());
            }
            fieldDefinition.setAllowFilter(!colunaSQL.isVirtual() || colunaSQL.isPermitiFiltrarColunaCustomizavel());
            fieldDefinition.setColumnHeader(colunaSQL.getNomeCabecalho());
            lista.add(fieldDefinition);
        }
        return lista;
    }

    public Map<String, BigDecimal> getMapValoresTotalizados() {
        List colunasTotalizaveis = this.getColunasSql().stream().filter(col -> col.isTotalizar() && !col.isVirtual()).collect(Collectors.toList());
        if (!ListMapUtil.listNullOrEmpty(colunasTotalizaveis)) {
            return this.gridBuilder.getMapValoresTotalizados(colunasTotalizaveis);
        }
        return null;
    }

    public byte[] exportar(SaidaImpressaoWrapper saidaImpressaoWrapper, List<Object[]> dados) throws UnicoMensagemUsuarioException {
        int[] tamanhoColunas = new int[this.colsWidth.length];
        int totalWidth = 0;
        for (int j : this.colsWidth) {
            if (j == 0) {
                j = 300;
            }
            totalWidth += j;
        }
        for (int i = 0; i < this.colsWidth.length; ++i) {
            int tamanho = this.colsWidth[i];
            if (tamanho == 0) {
                tamanho = 300;
            }
            tamanhoColunas[i] = (int)((float)tamanho / (float)totalWidth * 100.0f);
        }
        tamanhoColunas[0] = tamanhoColunas[0] + 4;
        UViewer uViewer = new UViewer(true, saidaImpressaoWrapper.getTitulo(), saidaImpressaoWrapper.getSaidaRelatorio().getSaida(), saidaImpressaoWrapper.getDelimitador(), saidaImpressaoWrapper.isPaisagem(), saidaImpressaoWrapper.getExtensao(), tamanhoColunas);
        uViewer.setFonte(new Font(1, 6.0f, 0));
        uViewer.inicioRelatorio();
        uViewer.setZebrado(true);
        uViewer.inicioTitulo();
        for (int i = 0; i < this.getColunasSql().size(); ++i) {
            ColunaSQL colunaSQL = (ColunaSQL)this.getColunasSql().get(i);
            if (!colunaSQL.isVisivel()) continue;
            boolean direita = false;
            if (colunaSQL.getTipoDadoBase() != null) {
                direita = TipoDadoBase.isNumero((TipoDadoBase)colunaSQL.getTipoDadoBase()) && colunaSQL.getClasseEnum() == null;
            }
            uViewer.escreveTitulo(colunaSQL.getDescricao(), direita);
        }
        uViewer.fimTitulo();
        this.exportarDados(saidaImpressaoWrapper, dados, uViewer);
        uViewer.fimRelatorio();
        Malote malote = uViewer.getRemessa().getMalote();
        return malote.extrai(RelatorioUtil.getFormato((SaidaRelatorio)saidaImpressaoWrapper.getSaidaRelatorio()));
    }

    protected void exportarDados(SaidaImpressaoWrapper saidaImpressaoWrapper, List<Object[]> dados, UViewer uViewer) {
        HashMap<Integer, BigDecimal> totais = new HashMap<Integer, BigDecimal>();
        for (Object[] objectArray : dados) {
            uViewer.inicioLinha();
            int numColVisivel = 0;
            for (int i = 0; i < this.getColunasSql().size(); ++i) {
                ColunaSQL colunaSQL = (ColunaSQL)this.getColunasSql().get(i);
                if (!colunaSQL.isVisivel()) continue;
                Object valor = objectArray[i];
                if (valor == null) {
                    uViewer.escreveColuna("");
                } else if (colunaSQL.getClasseEnum() != null) {
                    String valorEnum = "";
                    for (Object enumConstant : colunaSQL.getClasseEnum().getEnumConstants()) {
                        if (!((Enum)enumConstant).name().equalsIgnoreCase(valor.toString())) continue;
                        valorEnum = enumConstant.toString();
                        break;
                    }
                    uViewer.escreveColuna(valorEnum);
                } else if (valor instanceof Number) {
                    BigDecimal valorBigDecimal;
                    if (valor instanceof BigDecimal) {
                        valorBigDecimal = (BigDecimal)valor;
                        if (colunaSQL.getDecimais() > 0) {
                            valorBigDecimal = valorBigDecimal.setScale(colunaSQL.getDecimais(), RoundingMode.HALF_EVEN);
                        }
                    } else {
                        valorBigDecimal = NumberUtil.toBigDecimal((Object)valor);
                    }
                    if (valorBigDecimal != null && valorBigDecimal.scale() > 6) {
                        valorBigDecimal = valorBigDecimal.setScale(6, RoundingMode.HALF_EVEN);
                    }
                    uViewer.escreveColuna(valorBigDecimal);
                    if (colunaSQL.isTotalizar() && !colunaSQL.isVirtual()) {
                        BigDecimal total = (BigDecimal)totais.get(numColVisivel);
                        if (total == null) {
                            total = BigDecimal.ZERO;
                        }
                        total = total.add(valorBigDecimal);
                        totais.put(numColVisivel, total);
                    }
                } else if (valor instanceof String) {
                    uViewer.escreveColuna((String)valor);
                } else if (valor instanceof Date) {
                    uViewer.escreveColuna(DateUtil.date2String((java.util.Date)((java.util.Date)valor)));
                } else if (valor instanceof Timestamp) {
                    uViewer.escreveColuna(DateUtil.formataDataHora((Temporal)((Timestamp)valor).toLocalDateTime(), (String)"dd/MM/yyyy HH:mm"));
                } else {
                    uViewer.escreveColuna(String.valueOf(valor));
                }
                ++numColVisivel;
            }
            uViewer.fimLinha();
        }
        if (!totais.isEmpty()) {
            uViewer.inicioRodape();
            uViewer.escreveRodape(1, "Total");
            for (Map.Entry entry : totais.entrySet()) {
                uViewer.escreveRodape((Integer)entry.getKey() + 1, (BigDecimal)totais.get(entry.getKey()));
            }
            uViewer.fimRodape();
        }
    }

    public int getIndexColuna(String coluna, List<ColunaSQL> colunas) {
        return colunas.stream().filter(c -> c.getAlias().equals(coluna)).findFirst().map(colunas::indexOf).orElse(-1);
    }

    public GridBuilder<?> getGridBuilder() {
        return this.gridBuilder;
    }

    private void addCondicaoPesquisaRapida(TipoPesquisaRapida tipoPesquisaRapida, String alias, String texto, int numcondicoes, boolean adicionouCondicoesEspecificas) {
        this.addCondicaoPesquisaRapida(tipoPesquisaRapida, alias, texto, null, numcondicoes, adicionouCondicoesEspecificas);
    }

    private void addCondicaoPesquisaRapida(TipoPesquisaRapida tipoPesquisaRapida, String alias, String texto, List<AbstractEnum> listaEnum, int numcondicoes, boolean adicionouCondicoesEspecificas) {
        if (numcondicoes == 0) {
            if (!this.gridBuilder.getCondicoesDefault().isEmpty() && !adicionouCondicoesEspecificas) {
                this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(OperadorLogico.E));
            }
            this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(Separador.ABRE_PARENTESIS));
        } else {
            this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(OperadorLogico.OU));
        }
        if (tipoPesquisaRapida == TipoPesquisaRapida.STRING) {
            if (texto.contains("=and=") || texto.contains("*")) {
                boolean isAnd = texto.contains("=and=");
                String operacao = isAnd ? "=and=" : "\\*";
                this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(Separador.ABRE_PARENTESIS));
                String[] partesFiltro = texto.split(operacao);
                for (int i = 0; i < partesFiltro.length; ++i) {
                    this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(alias, Operador.CONTEM, StringUtil.removerAcentosPesquisa((String)partesFiltro[i])));
                    if (i >= partesFiltro.length - 1) continue;
                    this.gridBuilder.addCondicaoPesquisaRapida(isAnd ? new Condicao(OperadorLogico.E) : new Condicao(OperadorLogico.OU));
                }
                this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(Separador.FECHA_PARENTESIS));
            } else {
                this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(alias, Operador.CONTEM, StringUtil.removerAcentosPesquisa((String)texto)));
            }
        } else if (tipoPesquisaRapida == TipoPesquisaRapida.DATA) {
            this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(alias, Operador.IGUAL, DateUtil.string2LocalDate((String)texto)));
        } else if (tipoPesquisaRapida == TipoPesquisaRapida.VALOR) {
            this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(alias, Operador.IGUAL, NumberUtil.string2BigDecimal((String)texto)));
        } else if (tipoPesquisaRapida == TipoPesquisaRapida.CONTIDO_EM && !ListMapUtil.listNullOrEmpty(listaEnum)) {
            this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(alias, Operador.CONTIDO_EM, listaEnum));
        } else {
            throw new RuntimeException("Tipo de pesquisa r\u00e1pida inv\u00e1lida: " + tipoPesquisaRapida);
        }
    }

    private LocalDate isData(String valor) {
        String[] masks;
        for (String mask : masks = new String[]{"dd/MM/yyyy", "dd-MM-yyyy", "ddMMyyyy", "dd/MM/yy", "dd-MM-yy", "ddMMyy"}) {
            LocalDate data = DataHoraFactory.string2LocalDate((String)valor, (String)mask);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    void trataPesquisaRapida(String texto) {
        TipoPesquisaRapida tipoPesquisaRapida = DateUtil.string2LocalDate((String)(texto = texto.trim())) != null ? TipoPesquisaRapida.DATA : (Util.isApenasNumeros((String)texto.replace(".", "").replace(",", "")) ? TipoPesquisaRapida.VALOR : TipoPesquisaRapida.STRING);
        this.gridBuilder.limparCondicoesPesquisaRapida();
        this.gridBuilder.limparReferenciasPesquisa();
        boolean adicionouCondicoesEspecificas = false;
        if (this.gridBuilder.getTratarPesquisaRapida() != null) {
            this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(OperadorLogico.E));
            this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(Separador.ABRE_PARENTESIS));
            adicionouCondicoesEspecificas = this.gridBuilder.getTratarPesquisaRapida().tratarPesquisaRapida(this.gridBuilder, texto);
            if (!adicionouCondicoesEspecificas) {
                this.gridBuilder.limparCondicoesPesquisaRapida();
            }
        }
        int numcondicoes = 0;
        int numcolvisivel = 0;
        boolean adicionouOperadorExtra = false;
        for (int i = 0; i < this.getColunasSql().size(); ++i) {
            boolean permiteColunaVirtual;
            ColunaSQL colunaSQL = (ColunaSQL)this.getColunasSql().get(i);
            Referencia colAlias = new Referencia(colunaSQL.getNome());
            colAlias.setAlias(colunaSQL.getAlias().concat("_where"));
            colAlias.setChavesEstrangeiras(colunaSQL.getChavesEstrangeiras());
            colAlias.setDescricao(colunaSQL.getDescricao());
            colAlias.setTabela(colunaSQL.getTabela());
            colAlias.setAliasTabela(colunaSQL.getAliasTabela());
            colAlias.setTipoDadoBase(colunaSQL.getTipoDadoBase());
            colAlias.setSubquery(colunaSQL.getSubquery());
            if (colunaSQL.isVirtual() && colunaSQL.isFuncao()) {
                colAlias.setFuncao(colunaSQL.getFuncao());
                colAlias.setParametrosFuncao(colunaSQL.getParametrosFuncao());
            } else if (UnicoSistema.isPossuiExtensaoUnaccent()) {
                colAlias.setFuncao(Funcao.REMOVER_ACENTO);
            }
            if (!colunaSQL.isVisivel()) continue;
            boolean bl = permiteColunaVirtual = !colunaSQL.isEstatico() && colunaSQL.isVirtual() && !colunaSQL.isNaoUtilizarPesquisaRapida() && (colunaSQL.getFuncao() != null || colunaSQL.getSubquery() != null);
            if (!colunaSQL.isEstatico() && !colunaSQL.isNaoUtilizarPesquisaRapida() || permiteColunaVirtual) {
                if (adicionouCondicoesEspecificas && !adicionouOperadorExtra) {
                    this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(OperadorLogico.OU));
                    this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(Separador.ABRE_PARENTESIS));
                    adicionouOperadorExtra = true;
                }
                boolean campoExtra = colunaSQL.getNome().matches("extra\\d{1,2}");
                if (colunaSQL.getAlias().equalsIgnoreCase("CODIGO")) {
                    if (colunaSQL.getTipoDadoBase() == null || TipoDadoBase.CHARACTER_VARYING.equals((Object)colunaSQL.getTipoDadoBase()) && !Long.class.equals((Object)colunaSQL.getClasseValor())) {
                        this.gridBuilder.addReferenciasPesquisa(colAlias);
                        this.addCondicaoPesquisaRapida(TipoPesquisaRapida.STRING, colAlias.getAlias(), texto, numcondicoes, adicionouCondicoesEspecificas);
                        ++numcondicoes;
                    } else {
                        String textoCodigo = texto.replace(".", "");
                        if (Util.isApenasNumeros((String)textoCodigo)) {
                            this.addCondicaoPesquisaRapida(TipoPesquisaRapida.VALOR, colunaSQL.getAlias(), textoCodigo, numcondicoes, adicionouCondicoesEspecificas);
                            ++numcondicoes;
                        }
                    }
                } else if (tipoPesquisaRapida == TipoPesquisaRapida.STRING && this.classe[numcolvisivel] == String.class) {
                    this.gridBuilder.addReferenciasPesquisa(colAlias);
                    this.addCondicaoPesquisaRapida(TipoPesquisaRapida.STRING, colAlias.getAlias(), texto, numcondicoes, adicionouCondicoesEspecificas);
                    ++numcondicoes;
                    if (colunaSQL.getNome().toLowerCase().contains("cpf") || colunaSQL.getNome().toLowerCase().contains("cnpj")) {
                        this.addCondicaoCpfCnpjSemPontuacao(colunaSQL, texto);
                        ++numcondicoes;
                    }
                } else if (tipoPesquisaRapida == TipoPesquisaRapida.DATA && this.classe[numcolvisivel] == java.util.Date.class) {
                    LocalDate data = this.isData(texto);
                    if (data != null && data.getYear() > 0 && data.getYear() < 9999) {
                        this.addCondicaoPesquisaRapida(TipoPesquisaRapida.DATA, colunaSQL.getAlias(), texto, numcondicoes, adicionouCondicoesEspecificas);
                        ++numcondicoes;
                    }
                } else if (tipoPesquisaRapida == TipoPesquisaRapida.VALOR && (this.classe[numcolvisivel] == BigDecimal.class || this.classe[numcolvisivel] == Long.class || this.classe[numcolvisivel] == Integer.class)) {
                    if (campoExtra) {
                        this.gridBuilder.addReferenciasPesquisa(colAlias);
                        this.addCondicaoPesquisaRapida(TipoPesquisaRapida.STRING, colAlias.getAlias(), texto, numcondicoes, adicionouCondicoesEspecificas);
                    } else {
                        this.addCondicaoPesquisaRapida(TipoPesquisaRapida.VALOR, colunaSQL.getAlias(), texto, numcondicoes, adicionouCondicoesEspecificas);
                    }
                    ++numcondicoes;
                } else if (tipoPesquisaRapida == TipoPesquisaRapida.VALOR && this.classe[numcolvisivel] == String.class) {
                    this.gridBuilder.addReferenciasPesquisa(colAlias);
                    this.addCondicaoPesquisaRapida(TipoPesquisaRapida.STRING, colAlias.getAlias(), texto, numcondicoes, adicionouCondicoesEspecificas);
                    ++numcondicoes;
                    if (colunaSQL.getNome().toLowerCase().contains("cpf") || colunaSQL.getNome().toLowerCase().contains("cnpj")) {
                        this.addCondicaoCpfCnpjSemPontuacao(colunaSQL, texto);
                        ++numcondicoes;
                    }
                } else if (this.classe[numcolvisivel] == Enum.class) {
                    List lista = Arrays.asList(colunaSQL.getClasseEnum().getEnumConstants());
                    ArrayList<AbstractEnum> listaEnum = new ArrayList<AbstractEnum>();
                    for (Object itemEnum : lista) {
                        AbstractEnum enu = (AbstractEnum)itemEnum;
                        if (!enu.getDescricao().toLowerCase().contains(texto.toLowerCase())) continue;
                        listaEnum.add(enu);
                    }
                    if (!listaEnum.isEmpty()) {
                        this.addCondicaoPesquisaRapida(TipoPesquisaRapida.CONTIDO_EM, colunaSQL.getAlias(), null, listaEnum, numcondicoes, adicionouCondicoesEspecificas);
                        ++numcondicoes;
                    }
                }
            }
            ++numcolvisivel;
        }
        if (numcondicoes > 0) {
            if (adicionouOperadorExtra) {
                this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(Separador.FECHA_PARENTESIS));
            }
            if (adicionouCondicoesEspecificas) {
                this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(Separador.FECHA_PARENTESIS));
            }
            this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(Separador.FECHA_PARENTESIS));
        }
    }

    private void addCondicaoCpfCnpjSemPontuacao(ColunaSQL colunaSQL, String texto) {
        this.gridBuilder.addReferencia(new Referencia(Funcao.REMOVER_CARACTERES_ESPECIAIS, colunaSQL.getNome(), "cpfCnpjSemPontuacao", EnumJoin.LEFT_JOIN, colunaSQL.getChavesEstrangeiras()));
        this.gridBuilder.addCondicaoPesquisaRapida(new Condicao(OperadorLogico.OU));
        this.gridBuilder.addCondicaoPesquisaRapida(new Condicao("cpfCnpjSemPontuacao", Operador.CONTEM, texto));
    }

    protected void parent(String parent) {
        if (parent != null && !parent.isEmpty()) {
            ParentField parentField = (ParentField)JsonUtil.fromJson((String)parent, ParentField.class);
            if (parentField != null) {
                this.gridBuilder.addReferencia(new Referencia(parentField.getField()));
                this.gridBuilder.addCondicao(new Condicao(parentField.getField(), Operador.IGUAL, NumberUtil.toLong((String)parentField.getValue())));
            } else {
                throw new RuntimeException("Parent inv\u00e1lido: " + parent);
            }
        }
    }

    protected void filtro(List<FilterField> filters) {
        if (!ListMapUtil.listNullOrEmpty(filters)) {
            for (FilterField filterField : filters) {
                ColunaSQL colunaSql = this.gridBuilder.getColunaSQL(filterField.getField());
                if (colunaSql != null && (colunaSql.isVirtual() || colunaSql.isEstatico()) && !colunaSql.isPermitiFiltrarColunaCustomizavel()) continue;
                if (!StringUtil.stringNullOrEmpty((String)filterField.getOperator())) {
                    if (!(this.gridBuilder.getCondicoes().isEmpty() && this.gridBuilder.getCondicoesDefault().isEmpty() && this.gridBuilder.getCondicoesPesquisaRapida().isEmpty())) {
                        this.gridBuilder.addCondicao(new Condicao(OperadorLogico.E));
                    }
                    this.gridBuilder.addCondicao(new Condicao(Separador.ABRE_PARENTESIS));
                }
                String type = filterField.getType();
                if (colunaSql != null && colunaSql.getClasseEnum() != null && !type.equals(TIPO_ORDEM)) {
                    Coluna coluna;
                    type = colunaSql.getClasseValor() != null ? (colunaSql.getClasseValor() == Integer.class || colunaSql.getClasseValor() == Long.class ? TIPO_INTEGER : TIPO_STRING) : ((coluna = this.getGridBuilder().getDefinicaoColuna(this.getGridBuilder().getTabela(), colunaSql)) != null && (coluna.getTipoDado().getClasseJava() == Integer.class || coluna.getTipoDado().getClasseJava() == Long.class) ? TIPO_INTEGER : TIPO_STRING);
                } else if (!(colunaSql == null || !colunaSql.getNome().matches("extra\\d{1,2}") || type.equalsIgnoreCase(TIPO_DATE) || type.equalsIgnoreCase(TIPO_NUMBER) || type.equalsIgnoreCase(TIPO_INTEGER) || type.equalsIgnoreCase(TIPO_ORDEM))) {
                    type = TIPO_STRING;
                }
                switch (type) {
                    case "String": {
                        this.filtroString(filterField, true);
                        if (StringUtil.stringNullOrEmpty((String)filterField.getOperator())) break;
                        this.gridBuilder.addCondicao(new Condicao(filterField.getOperator().equalsIgnoreCase(Operator.OPERADOR_LOGICO_E.getId()) ? OperadorLogico.E : OperadorLogico.OU));
                        this.filtroString(filterField, false);
                        break;
                    }
                    case "Date": {
                        this.filtroDate(filterField, colunaSql, true);
                        if (StringUtil.stringNullOrEmpty((String)filterField.getOperator())) break;
                        this.gridBuilder.addCondicao(new Condicao(filterField.getOperator().equalsIgnoreCase(Operator.OPERADOR_LOGICO_E.getId()) ? OperadorLogico.E : OperadorLogico.OU));
                        this.filtroDate(filterField, colunaSql, false);
                        break;
                    }
                    case "Number": {
                        this.filtroNumber(filterField, colunaSql, true);
                        if (StringUtil.stringNullOrEmpty((String)filterField.getOperator())) break;
                        this.gridBuilder.addCondicao(new Condicao(filterField.getOperator().equalsIgnoreCase(Operator.OPERADOR_LOGICO_E.getId()) ? OperadorLogico.E : OperadorLogico.OU));
                        this.filtroNumber(filterField, colunaSql, false);
                        break;
                    }
                    case "Integer": {
                        this.filtroInteger(filterField, colunaSql, true);
                        if (StringUtil.stringNullOrEmpty((String)filterField.getOperator())) break;
                        this.gridBuilder.addCondicao(new Condicao(filterField.getOperator().equalsIgnoreCase(Operator.OPERADOR_LOGICO_E.getId()) ? OperadorLogico.E : OperadorLogico.OU));
                        this.filtroInteger(filterField, colunaSql, false);
                        break;
                    }
                    case "Ordem": {
                        this.ordernar(filterField, colunaSql);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Tipo de dado n\u00e3o implementado: " + filterField.getType());
                    }
                }
                if (StringUtil.stringNullOrEmpty((String)filterField.getOperator())) continue;
                this.gridBuilder.addCondicao(new Condicao(Separador.FECHA_PARENTESIS));
            }
        }
    }

    private void ordernar(FilterField filterField, ColunaSQL colunaSQL) {
        boolean isExtra = colunaSQL.getNome().matches("extra\\d{1,2}");
        String alias = filterField.getField();
        if (isExtra) {
            alias = "alias_ordem_" + alias;
            if (colunaSQL.getTipoDadoBase().equals((Object)TipoDadoBase.DATE)) {
                this.gridBuilder.addReferencia(new Referencia(Funcao.CHAR_TO_DATE, filterField.getField(), alias, new Object[]{"dd/MM/yyyy"}));
            } else if (colunaSQL.getTipoDadoBase().equals((Object)TipoDadoBase.DATETIME)) {
                this.gridBuilder.addReferencia(new Referencia(Funcao.CHAR_TO_DATE_TIME, filterField.getField(), alias, new Object[]{"dd/MM/yyyy HH24:MI"}));
            } else if (colunaSQL.getTipoDadoBase().isNumero()) {
                this.gridBuilder.addReferencia(new Referencia(Funcao.TO_NUMBER_WITH_CASE, filterField.getField(), alias, new Object[0]));
            } else {
                this.gridBuilder.addReferencia(new Referencia(filterField.getField(), alias));
            }
        }
        this.gridBuilder.setOrdemDefault(new Ordem(alias, Boolean.parseBoolean(filterField.getValue1())));
    }

    private void filtroDate(FilterField filterField, ColunaSQL colunaSQL, boolean option1) {
        Operador op;
        Operator operator = (Operator)EnumUtils.getPorId(Operator.class, (Object)(option1 ? filterField.getFilter() : filterField.getFilter2()));
        switch (1.$SwitchMap$br$intelidata$uniplusweb$core$grid$Operator[operator.ordinal()]) {
            case 1: {
                op = Operador.IGUAL;
                break;
            }
            case 2: {
                op = Operador.DIFERENTE;
                break;
            }
            case 3: {
                op = Operador.MAIOR_QUE;
                break;
            }
            case 4: {
                op = Operador.MENOR_QUE;
                break;
            }
            case 5: {
                op = Operador.MAIOR_IGUAL_QUE;
                break;
            }
            case 6: {
                op = Operador.MENOR_IGUAL_QUE;
                break;
            }
            case 7: {
                op = Operador.ENTRE;
                break;
            }
            default: {
                throw new RuntimeException("Operador n\u00e3o implementado: " + filterField.getFilter());
            }
        }
        LocalDateTime dataHora = null;
        if (TipoDadoBase.DATETIME.equals((Object)colunaSQL.getTipoDadoBase())) {
            dataHora = DateUtil.string2LocalDateTime((String)(option1 ? filterField.getValue1() : filterField.getValue2()));
        }
        boolean isExtra = colunaSQL.getNome().matches("extra\\d{1,2}");
        String alias = "alias_filtro_" + filterField.getField();
        if (Operador.ENTRE.equals((Object)op)) {
            if (dataHora != null) {
                if (isExtra) {
                    this.gridBuilder.addReferencia(new Referencia(Funcao.CHAR_TO_DATE_TIME, filterField.getField(), alias, new Object[]{"dd/MM/yyyy HH24:MI"}));
                } else {
                    Referencia referencia;
                    if (colunaSQL.isSubquery()) {
                        referencia = new Referencia(colunaSQL.getNome(), alias);
                        referencia.setSubquery(colunaSQL.getSubquery());
                    } else {
                        referencia = new Referencia(Funcao.DATE_TRUNC_MINUTE, colunaSQL.getNome(), alias, new Object[0]);
                        referencia.setChavesEstrangeiras(colunaSQL.getChavesEstrangeiras());
                    }
                    this.gridBuilder.addReferencia(referencia);
                }
                this.gridBuilder.addCondicao(new Condicao(alias, op, dataHora, DateUtil.string2LocalDateTime((String)filterField.getValue2())));
            } else if (isExtra) {
                this.gridBuilder.addReferencia(new Referencia(Funcao.CHAR_TO_DATE, filterField.getField(), alias, new Object[]{"dd/MM/yyyy"}));
                this.gridBuilder.addCondicao(new Condicao(alias, op, DateUtil.string2LocalDate((String)filterField.getValue1()), DateUtil.string2LocalDate((String)filterField.getValue2())));
            } else {
                this.gridBuilder.addCondicao(new Condicao(filterField.getField(), op, DateUtil.string2LocalDate((String)filterField.getValue1()), DateUtil.string2LocalDate((String)filterField.getValue2())));
            }
        } else if (dataHora != null) {
            if (isExtra) {
                this.gridBuilder.addReferencia(new Referencia(Funcao.CHAR_TO_DATE_TIME, filterField.getField(), alias, new Object[]{"dd/MM/yyyy HH24:MI"}));
            } else {
                Referencia referencia;
                if (colunaSQL.isSubquery()) {
                    referencia = new Referencia(colunaSQL.getNome(), alias);
                    referencia.setSubquery(colunaSQL.getSubquery());
                } else {
                    referencia = new Referencia(Funcao.DATE_TRUNC_MINUTE, colunaSQL.getNome(), alias, new Object[0]);
                    referencia.setChavesEstrangeiras(colunaSQL.getChavesEstrangeiras());
                }
                this.gridBuilder.addReferencia(referencia);
            }
            this.gridBuilder.addCondicao(new Condicao(alias, op, dataHora));
        } else {
            LocalDate data = DateUtil.string2LocalDate((String)(option1 ? filterField.getValue1() : filterField.getValue2()));
            if (isExtra) {
                this.gridBuilder.addReferencia(new Referencia(Funcao.CHAR_TO_DATE, filterField.getField(), alias, new Object[]{"dd/MM/yyyy"}));
                this.gridBuilder.addCondicao(new Condicao(alias, op, data));
            } else {
                this.gridBuilder.addCondicao(new Condicao(filterField.getField(), op, data));
            }
        }
    }

    private void filtroNumber(FilterField filterField, ColunaSQL colunaSQL, boolean option1) {
        Operator operator = (Operator)EnumUtils.getPorId(Operator.class, (Object)(option1 ? filterField.getFilter() : filterField.getFilter2()));
        boolean isExtra = colunaSQL != null && colunaSQL.getNome().matches("extra\\d{1,2}");
        String campo = filterField.getField();
        if (isExtra) {
            campo = "alias_filtro_" + filterField.getField();
            this.gridBuilder.addReferencia(new Referencia(Funcao.TO_NUMBER_WITH_CASE, filterField.getField(), campo, new Object[0]));
        }
        switch (1.$SwitchMap$br$intelidata$uniplusweb$core$grid$Operator[operator.ordinal()]) {
            case 1: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.IGUAL, new BigDecimal(option1 ? filterField.getValue1() : filterField.getValue2())));
                break;
            }
            case 2: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.DIFERENTE, NumberUtil.string2BigDecimal((String)(option1 ? filterField.getValue1() : filterField.getValue2()))));
                break;
            }
            case 3: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.MAIOR_QUE, NumberUtil.string2BigDecimal((String)(option1 ? filterField.getValue1() : filterField.getValue2()))));
                break;
            }
            case 5: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.MAIOR_IGUAL_QUE, NumberUtil.string2BigDecimal((String)(option1 ? filterField.getValue1() : filterField.getValue2()))));
                break;
            }
            case 4: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.MENOR_QUE, NumberUtil.string2BigDecimal((String)(option1 ? filterField.getValue1() : filterField.getValue2()))));
                break;
            }
            case 6: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.MENOR_IGUAL_QUE, NumberUtil.string2BigDecimal((String)(option1 ? filterField.getValue1() : filterField.getValue2()))));
                break;
            }
            case 7: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.ENTRE, NumberUtil.string2BigDecimal((String)filterField.getValue1()), NumberUtil.string2BigDecimal((String)(option1 ? filterField.getValue1() : filterField.getValue2()))));
                break;
            }
            default: {
                throw new RuntimeException("Operador n\u00e3o implementado: " + filterField.getFilter());
            }
        }
    }

    private void filtroInteger(FilterField filterField, ColunaSQL colunaSql, boolean option1) {
        String valor = option1 ? filterField.getValue1() : filterField.getValue2();
        Operator operator = (Operator)EnumUtils.getPorId(Operator.class, (Object)(option1 ? filterField.getFilter() : filterField.getFilter2()));
        List<String> valoresFiltro = Arrays.asList(filterField.getValues());
        int valorConvertido = 0;
        Integer[] valores = new Integer[]{};
        if (colunaSql != null && colunaSql.getClasseEnum() != null) {
            if (operator.equals((Object)Operator.OPERADOR_CONTIDO_EM)) {
                valores = (Integer[])Stream.of(colunaSql.getClasseEnum().getEnumConstants()).filter(constant -> valoresFiltro.contains(((Enum)constant).name())).map(e -> (Integer)((AbstractEnum)e).getId()).toArray(Integer[]::new);
            } else {
                Optional<Object> filter = Stream.of(colunaSql.getClasseEnum().getEnumConstants()).filter(constant -> ((Enum)constant).name().equals(valor)).findFirst();
                if (filter.isPresent()) {
                    valorConvertido = (Integer)((AbstractEnum)filter.get()).getId();
                }
            }
        } else {
            valorConvertido = NumberUtil.isNumber((String)valor) ? NumberUtil.toInteger((String)valor) : (Boolean.parseBoolean(valor) ? 1 : 0);
        }
        boolean isExtra = colunaSql != null && colunaSql.getNome().matches("extra\\d{1,2}");
        String campo = filterField.getField();
        if (isExtra) {
            campo = "alias_filtro_" + filterField.getField();
            this.gridBuilder.addReferencia(new Referencia(Funcao.TO_NUMBER_WITH_CASE, filterField.getField(), campo, new Object[0]));
        }
        switch (1.$SwitchMap$br$intelidata$uniplusweb$core$grid$Operator[operator.ordinal()]) {
            case 1: 
            case 8: 
            case 9: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.IGUAL, valorConvertido));
                break;
            }
            case 2: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.DIFERENTE, valorConvertido));
                break;
            }
            case 3: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.MAIOR_QUE, valorConvertido));
                break;
            }
            case 5: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.MAIOR_IGUAL_QUE, valorConvertido));
                break;
            }
            case 4: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.MENOR_QUE, valorConvertido));
                break;
            }
            case 6: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.MENOR_IGUAL_QUE, valorConvertido));
                break;
            }
            case 10: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.CONTIDO_EM, valores));
                break;
            }
            case 11: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.CONTIDO_EM, Collections.singletonList(valorConvertido).toArray(new Integer[0])));
                break;
            }
            case 12: {
                this.gridBuilder.addCondicao(new Condicao(campo, Operador.NAO_CONTIDO_EM, Collections.singletonList(valorConvertido).toArray(new Integer[0])));
                break;
            }
            default: {
                throw new RuntimeException("Operador n\u00e3o implementado: " + filterField.getFilter());
            }
        }
    }

    private void filtroString(FilterField filterField, boolean option1) {
        String valor = option1 ? filterField.getValue1() : filterField.getValue2();
        Operator operator = (Operator)EnumUtils.getPorId(Operator.class, (Object)(option1 ? filterField.getFilter() : filterField.getFilter2()));
        List<String> valores = Arrays.asList(filterField.getValues());
        ColunaSQL colunaSql = this.gridBuilder.getColunaSQL(filterField.getField());
        if (colunaSql != null && colunaSql.getClasseEnum() != null) {
            if (operator.equals((Object)Operator.OPERADOR_CONTIDO_EM)) {
                List<String> constants = valores;
                valores = Stream.of(colunaSql.getClasseEnum().getEnumConstants()).filter(constant -> constants.contains(((Enum)constant).name())).map(e -> ((AbstractEnum)e).getId().toString()).collect(Collectors.toList());
            } else {
                String constante = valor;
                Optional<Object> filter = Stream.of(colunaSql.getClasseEnum().getEnumConstants()).filter(constant -> ((Enum)constant).name().equals(constante)).findFirst();
                if (filter.isPresent()) {
                    valor = ((AbstractEnum)filter.get()).getId().toString();
                }
            }
        }
        if (operator != null) {
            switch (1.$SwitchMap$br$intelidata$uniplusweb$core$grid$Operator[operator.ordinal()]) {
                case 1: {
                    if (StringUtil.stringNullOrEmpty((String)valor)) {
                        this.gridBuilder.addCondicao(new Condicao(OperadorLogico.E));
                        this.gridBuilder.addCondicao(new Condicao(Separador.ABRE_PARENTESIS));
                        this.gridBuilder.addCondicao(new Condicao(filterField.getField(), Operador.IGUAL, valor));
                        this.gridBuilder.addCondicao(new Condicao(OperadorLogico.OU));
                        this.gridBuilder.addCondicao(new Condicao(filterField.getField(), Operador.IS_NULL));
                        this.gridBuilder.addCondicao(new Condicao(Separador.FECHA_PARENTESIS));
                        break;
                    }
                    this.gridBuilder.addCondicao(new Condicao(filterField.getField(), Operador.IGUAL, valor));
                    break;
                }
                case 2: {
                    if (StringUtil.stringNullOrEmpty((String)valor)) {
                        this.gridBuilder.addCondicao(new Condicao(OperadorLogico.E));
                        this.gridBuilder.addCondicao(new Condicao(Separador.ABRE_PARENTESIS));
                        this.gridBuilder.addCondicao(new Condicao(filterField.getField(), Operador.DIFERENTE, valor));
                        this.gridBuilder.addCondicao(new Condicao(OperadorLogico.E));
                        this.gridBuilder.addCondicao(new Condicao(filterField.getField(), Operador.IS_NOT_NULL));
                        this.gridBuilder.addCondicao(new Condicao(Separador.FECHA_PARENTESIS));
                        break;
                    }
                    this.gridBuilder.addCondicao(new Condicao(filterField.getField(), Operador.DIFERENTE, valor));
                    break;
                }
                case 8: {
                    this.gridBuilder.addCondicao(new Condicao(filterField.getField(), Operador.COMECE_COM, valor));
                    break;
                }
                case 9: {
                    this.gridBuilder.addCondicao(new Condicao(filterField.getField(), Operador.TERMINE_COM, valor));
                    break;
                }
                case 11: {
                    this.gridBuilder.addCondicao(new Condicao(filterField.getField(), Operador.CONTEM, valor));
                    break;
                }
                case 12: {
                    this.gridBuilder.addCondicao(new Condicao(filterField.getField(), Operador.NAO_CONTEM, valor));
                    break;
                }
                case 10: {
                    if (ListMapUtil.listNullOrEmpty(valores)) {
                        valores = Collections.singletonList(valor);
                    }
                    this.gridBuilder.addCondicao(new Condicao(filterField.getField(), Operador.CONTIDO_EM, valores.toArray(new String[0])));
                    break;
                }
                default: {
                    throw new RuntimeException("Operador n\u00e3o implementado: " + filterField.getFilter());
                }
            }
        }
    }
}

