/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.grid;

import br.intelidata.commons.core.sistema.InterfaceColunaCustomizavel;
import br.intelidata.commons.core.sql.ConversorResultSet;
import br.intelidata.commons.core.sql.ConversorResultSet2;
import br.intelidata.commons.core.sql.DicionarioDados;
import br.intelidata.commons.core.sql.SGBDManager;
import br.intelidata.commons.core.sql.SQLServerManager;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.model.ChaveEstrangeira;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.model.Tabela;
import br.intelidata.commons.core.sql.model.TipoDado;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TratarPesquisaRapida;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GridBuilder<RN extends AbstractRegraNegocio<?, ?>>
implements Serializable,
InterfaceColunaCustomizavel {
    private List<ColunaSQL> colunasSql;
    private USelect select;
    private int quantidadeRegistroPorPagina = 50;
    private int paginaAtual = 0;
    private int paginaInicial = 35;
    private List<Condicao> condicoes;
    private List<Ordem> ordens;
    private List<Referencia> referencias;
    private List<Condicao> condicoesDefault;
    private List<Condicao> condicoesPesquisaRapida;
    private List<Ordem> ordensDefault;
    private List<Referencia> referenciasDefault;
    private List<Referencia> referenciasPesquisa;
    private List<Condicao> condicoesPaginado;
    private boolean atribuiuSelectPersonalizado;
    private List<Integer> colunasEnum;
    private boolean limparCondicoes = true;
    private boolean distinct;
    private final boolean usaVisao;
    private String aliasTabela;
    private String tabela;
    private TratarPesquisaRapida tratarPesquisaRapida;
    private HashMap<String, ColunaCustomizavelGrid> mapColunasCustomizaveisPorNome;
    private HashMap<String, ColunaCustomizavelGrid> mapColunasCustomizaveisPorAlias;

    public GridBuilder(String tabela, List<ColunaSQL> colunasSql) {
        this(tabela, colunasSql, new ArrayList());
    }

    public GridBuilder(String tabela, List<ColunaSQL> colunasSql, String aliasTabela) {
        this(tabela, colunasSql, new ArrayList(), aliasTabela, false);
    }

    public GridBuilder(String tabela, List<ColunaSQL> colunasSql, List<Ordem> ordens) {
        this(tabela, colunasSql, ordens, null, false);
    }

    public GridBuilder(String tabela, List<ColunaSQL> colunasSql, List<Ordem> ordens, String aliasTabela) {
        this(tabela, colunasSql, ordens, aliasTabela, false);
    }

    public GridBuilder(String tabela, List<ColunaSQL> colunasSql, List<Ordem> ordens, String aliasTabela, boolean usaVisao) {
        this.tabela = tabela;
        this.colunasSql = colunasSql;
        this.ordens = ordens;
        this.aliasTabela = aliasTabela;
        this.condicoes = new ArrayList();
        this.referencias = new ArrayList();
        this.ordensDefault = new ArrayList();
        this.condicoesDefault = new ArrayList();
        this.condicoesPesquisaRapida = new ArrayList();
        this.referenciasDefault = new ArrayList();
        this.referenciasPesquisa = new ArrayList();
        this.condicoesPaginado = new ArrayList();
        this.colunasEnum = new ArrayList();
        this.usaVisao = usaVisao;
        this.carregarEnuns();
    }

    public void carregarEnuns() {
        int numCol = 0;
        this.colunasEnum.clear();
        for (ColunaSQL colunaSQL : this.colunasSql) {
            if (colunaSQL.getClasseEnum() == null) {
                colunaSQL.setClasseEnum(this.buscarClassEnum(this.tabela, colunaSQL.getNome(), (List)(colunaSQL.getChavesEstrangeiras() == null ? null : new ArrayList<String>(Arrays.asList(colunaSQL.getChavesEstrangeiras())))));
            }
            if (colunaSQL.getClasseEnum() != null && !colunaSQL.isNaoAlterarValorEnum()) {
                this.colunasEnum.add(numCol);
            }
            ++numCol;
        }
    }

    public void setAliasTabela(String aliasTabela) {
        this.aliasTabela = aliasTabela;
    }

    public List<ColunaSQL> getColunasSql() {
        return this.colunasSql;
    }

    public void setColunasSql(List<ColunaSQL> colunasSql) {
        this.colunasSql = colunasSql;
    }

    public USelect getSelect() {
        if (this.select == null) {
            this.criarSelect();
        }
        return this.select;
    }

    public void setSelect(USelect select) {
        this.select = select;
        this.atribuiuSelectPersonalizado = true;
    }

    private synchronized void criarSelect() {
        if (this.atribuiuSelectPersonalizado) {
            return;
        }
        List colunasClone = ListMapUtil.clone((List)this.getColunasSql());
        List condicoesDefaultClone = ListMapUtil.clone((List)this.condicoesDefault);
        List condicoesPesquisaRapidaClone = ListMapUtil.clone((List)this.condicoesPesquisaRapida);
        List ordensDefaultClone = ListMapUtil.clone((List)this.ordensDefault);
        List referenciasDefaultClone = ListMapUtil.clone((List)this.referenciasDefault);
        List referenciasPesquisaClone = ListMapUtil.clone((List)this.referenciasPesquisa);
        List condicoesClone = ListMapUtil.clone((List)this.condicoes);
        List condicoesPaginadoClone = ListMapUtil.clone((List)this.condicoesPaginado);
        List ordensClone = ListMapUtil.clone((List)this.ordens);
        List referenciasClone = ListMapUtil.clone((List)this.referencias);
        this.select = new USelect(this.tabela);
        for (ColunaSQL coluna : colunasClone) {
            this.select.add(coluna);
        }
        for (Condicao condicao : condicoesDefaultClone) {
            this.select.add(condicao);
        }
        for (Condicao condicao : condicoesPesquisaRapidaClone) {
            this.select.add(condicao);
        }
        for (Ordem ordem : ordensDefaultClone) {
            this.select.add(ordem);
        }
        for (Referencia referencia : referenciasDefaultClone) {
            this.select.add((ColunaSQL)referencia);
        }
        for (Referencia referencia : referenciasPesquisaClone) {
            this.select.add((ColunaSQL)referencia);
        }
        for (Condicao condicao : condicoesClone) {
            this.select.add(condicao);
        }
        if (!Util.listNullOrEmpty((List)this.select.getCondicoes()) && !condicoesPaginadoClone.isEmpty()) {
            this.select.add(new Condicao(OperadorLogico.E));
        }
        for (Condicao condicao : condicoesPaginadoClone) {
            this.select.add(condicao);
        }
        for (Ordem ordem : ordensClone) {
            this.select.add(ordem);
        }
        for (Referencia referencia : referenciasClone) {
            this.select.add((ColunaSQL)referencia);
        }
        if (ordensClone.stream().noneMatch(ord -> ord.getAlias().equalsIgnoreCase("id")) && !this.distinct && SGBDManager.getInstance().existeColuna(this.tabela, "id")) {
            if (colunasClone.stream().noneMatch(col -> col.getAlias() != null && col.getAlias().equalsIgnoreCase("id"))) {
                this.select.add((ColunaSQL)new Referencia("id"));
            }
            this.select.getOrdens().add(new Ordem("id"));
        }
        this.select.setOffset(this.paginaAtual);
        this.select.setLimit(this.quantidadeRegistroPorPagina);
        this.select.setDistinct(this.distinct);
    }

    public void limparOrdenacoes() {
        this.ordens.clear();
    }

    public void setOrdemSQL(Ordem ordem) {
        this.limparOrdenacoes();
        this.ordens.add(ordem);
    }

    public void addOrdem(Ordem ordem) {
        this.ordens.add(ordem);
    }

    public List<Ordem> getOrdens() {
        return this.ordens;
    }

    public void setOrdens(List<Ordem> ordens) {
        this.limparOrdenacoes();
        ordens.addAll(ordens);
    }

    public void setOrdensDefault(List<Ordem> ordens) {
        this.limparOrdensDefault();
        this.ordensDefault.addAll(ordens);
    }

    public void limparCondicoes() {
        this.condicoes.clear();
    }

    public List<Condicao> getCondicoes() {
        return this.condicoes;
    }

    public List<Condicao> getCondicoesPesquisaRapida() {
        return this.condicoesPesquisaRapida;
    }

    public void setCondicao(Condicao condicao) {
        this.limparCondicoes();
        this.condicoes.add(condicao);
    }

    public void setCondicoes(List<Condicao> condicoes) {
        this.condicoes.clear();
        this.condicoes.addAll(condicoes);
    }

    public void addCondicao(Condicao condicao) {
        this.condicoes.add(condicao);
    }

    public void limparReferencias() {
        this.referencias.clear();
    }

    public List<Referencia> getReferencias() {
        return this.referencias;
    }

    public void setReferencias(List<Referencia> referencias) {
        this.limparReferencias();
        this.referencias.addAll(referencias);
    }

    public void addReferencia(Referencia referencia) {
        this.referencias.add(referencia);
    }

    public List<Condicao> getCondicoesDefault() {
        return this.condicoesDefault;
    }

    public void limparCondicoesDefault() {
        this.condicoesDefault.clear();
    }

    public void addCodicaoDefault(Condicao condicao) {
        this.condicoesDefault.add(condicao);
    }

    public void setCondicaoDefault(Condicao condicao) {
        this.limparCondicoesDefault();
        this.addCodicaoDefault(condicao);
    }

    public List<Condicao> getCondicoesPaginado() {
        return this.condicoesPaginado;
    }

    public void limparCondicoesPaginado() {
        this.condicoesPaginado.clear();
    }

    public void addCodicaoPaginado(Condicao condicao) {
        this.condicoesPaginado.add(condicao);
    }

    public void setCondicoesPaginado(List<Condicao> condicoes) {
        this.limparCondicoesPaginado();
        this.condicoesPaginado.addAll(condicoes);
    }

    public void setCondicaoPaginado(Condicao condicao) {
        this.limparCondicoesPaginado();
        this.addCodicaoPaginado(condicao);
    }

    public List<Ordem> getOrdensDefault() {
        return this.ordensDefault;
    }

    public void limparOrdensDefault() {
        this.getOrdensDefault().clear();
    }

    public void addOrdemDefault(Ordem ordem) {
        this.getOrdensDefault().add(ordem);
    }

    public void setOrdemDefault(Ordem ordem) {
        this.limparOrdensDefault();
        this.addOrdemDefault(ordem);
    }

    public List<Referencia> getReferenciasDefault() {
        return this.referenciasDefault;
    }

    public void limparReferenciasDefault() {
        this.getReferenciasDefault().clear();
    }

    public void addReferenciaDefault(Referencia referencia) {
        this.getReferenciasDefault().add(referencia);
    }

    public void setReferenciaDefault(Referencia referencia) {
        this.limparReferenciasDefault();
        this.addReferenciaDefault(referencia);
    }

    public List<Referencia> getReferenciasPesquisa() {
        return this.referenciasPesquisa;
    }

    public void limparReferenciasPesquisa() {
        this.getReferenciasPesquisa().clear();
    }

    public void addReferenciasPesquisa(Referencia referencia) {
        this.getReferenciasPesquisa().add(referencia);
    }

    private void popularValorColunas() {
        for (ColunaSQL colunaSQL : this.getColunasSql()) {
            List fks = Util.array2List((Object[])colunaSQL.getChavesEstrangeiras());
            Coluna coluna = this.buscarColuna(this.tabela, colunaSQL.getNome(), fks);
            if (coluna == null) continue;
            colunaSQL.setClasseEnum(coluna.getClasseEnum());
            if (coluna.getClasseEnum() != null) {
                colunaSQL.setClasseValor(String.class);
                continue;
            }
            colunaSQL.setClasseValor(coluna.getClasseDado());
        }
    }

    public List<Object[]> getDados2() {
        this.paginaAtual = 0;
        this.criarSelect();
        int delta = 0;
        if (this.paginaAtual > 0 && SGBDManager.getInstance() instanceof SQLServerManager) {
            delta = 1;
        }
        Sql sql = new Sql(this.getSelect());
        List dados = ConversorResultSet2.converterSql((List)this.getColunasSql(), (Sql)sql, (boolean)false, (int)delta);
        if (Util.listNullOrEmpty((List)dados)) {
            this.popularValorColunas();
        }
        sql.close();
        return dados;
    }

    public void setQuantidadeRegistroPorPagina(int quantidadeRegistroPorPagina) {
        this.quantidadeRegistroPorPagina = quantidadeRegistroPorPagina;
    }

    public int getQuantidadeRegistroPorPagina() {
        return this.quantidadeRegistroPorPagina;
    }

    public void setPaginaAtual(int paginaAtual) {
        this.paginaAtual = paginaAtual;
    }

    public int getPaginaInicial() {
        return this.paginaInicial;
    }

    public List<Object[]> getDadosWeb() {
        this.criarSelect();
        int delta = 0;
        if (this.paginaAtual > 0 && SGBDManager.getInstance() instanceof SQLServerManager) {
            delta = 1;
        }
        Sql sql = new Sql(this.getSelect());
        List dados = ConversorResultSet2.converterSqlWeb((List)this.getColunasSql(), (List)this.colunasEnum, (Sql)sql, (int)delta);
        sql.close();
        return dados;
    }

    public int getTotalRegistros(String colunaTotalizador) {
        Sql sql = new Sql(this.getSelect().transformCount(colunaTotalizador, "total", this.distinct));
        sql.executaQuery();
        sql.next();
        int total = sql.getInt("total");
        sql.close();
        return total;
    }

    public ColunaSQL getColunaSQL(String alias) {
        for (ColunaSQL colunaSQL : this.getColunasSql()) {
            if (!colunaSQL.getAlias().equals(alias)) continue;
            return colunaSQL;
        }
        return null;
    }

    public Class<?> buscarClassEnum(String nomeTabela, String campo, List<String> fks) {
        Coluna coluna = this.buscarColuna(nomeTabela, campo, fks);
        if (coluna != null && coluna.getClasseEnum() != null) {
            return coluna.getClasseEnum();
        }
        return null;
    }

    private Coluna buscarColuna(String nomeTabela, String campo, List<String> fks) {
        if (!Util.listNullOrEmpty(fks)) {
            ChaveEstrangeira chave;
            Tabela tabela = DicionarioDados.getInstance().getTabela(nomeTabela);
            if (tabela != null && (chave = tabela.getChaveEstrangeira(fks.get(0))) != null) {
                fks.remove(0);
                return this.buscarColuna(chave.getTabelaReferencia(), campo.toLowerCase(), fks);
            }
        } else {
            Tabela tabela = DicionarioDados.getInstance().getTabela(nomeTabela);
            if (tabela != null) {
                return tabela.getColuna(campo.toLowerCase());
            }
        }
        return null;
    }

    public boolean isColunaTotalizavel(String alias) {
        for (ColunaSQL coluna : this.getColunasSql()) {
            if (!coluna.getAlias().equals(alias) || !coluna.isTotalizar() || !coluna.isVisivel()) continue;
            return true;
        }
        return false;
    }

    public void limparCondicoesPesquisaRapida() {
        this.condicoesPesquisaRapida.clear();
    }

    public void addCondicaoPesquisaRapida(Condicao condicao) {
        this.condicoesPesquisaRapida.add(condicao);
    }

    public void setTratarPesquisaRapida(TratarPesquisaRapida tratarPesquisaRapida) {
        this.tratarPesquisaRapida = tratarPesquisaRapida;
    }

    public TratarPesquisaRapida getTratarPesquisaRapida() {
        return this.tratarPesquisaRapida;
    }

    Map<String, BigDecimal> getMapValoresTotalizados(List<ColunaSQL> colunasTotalizaveis) {
        HashMap<String, BigDecimal> map = null;
        Sql sql = new Sql(this.getSelect(), true);
        List resultado = ConversorResultSet.getInstance().converterSql(colunasTotalizaveis, sql, false);
        if (!Util.listNullOrEmpty((List)resultado)) {
            map = new HashMap<String, BigDecimal>();
            LinkedHashMap map1 = (LinkedHashMap)resultado.get(0);
            for (Map.Entry entry : map1.entrySet()) {
                map.put((String)entry.getKey(), Util.seBigDecimalNullOrZeroEntao((BigDecimal)((BigDecimal)entry.getValue()), (BigDecimal)BigDecimal.ZERO));
            }
        }
        sql.close();
        return map;
    }

    public boolean isLimparCondicoes() {
        return this.limparCondicoes;
    }

    public void setLimparCondicoes(boolean limparCondicoes) {
        this.limparCondicoes = limparCondicoes;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public String getAliasTabela() {
        return this.aliasTabela;
    }

    public String getTabela() {
        return this.tabela;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Coluna getDefinicaoColuna(String nomeTabela, ColunaSQL colunaSQL) {
        List fks = Util.array2List((Object[])colunaSQL.getChavesEstrangeiras());
        Coluna coluna = this.getDefinicaoColuna(nomeTabela, colunaSQL.getNome(), fks);
        if (coluna == null) {
            if (colunaSQL.getClasseValor() == BigDecimal.class) {
                return new Coluna(colunaSQL.getNome(), (TipoDado)TipoDadoBase.NUMERIC, 12, 2, null);
            }
            if (colunaSQL.getClasseValor() == String.class) return new Coluna(colunaSQL.getNome(), (TipoDado)TipoDadoBase.CHARACTER_VARYING, null);
            if ((colunaSQL.isVirtual() || colunaSQL.isEstatico()) && !colunaSQL.isPermitiFiltrarColunaCustomizavel()) {
                return new Coluna(colunaSQL.getNome(), (TipoDado)TipoDadoBase.CHARACTER_VARYING, null);
            }
            if (colunaSQL.getTipoDadoBase() == null) throw new RuntimeException("Tipo de coluna virtual n\u00e3o implementado: " + colunaSQL.getNome() + " - " + colunaSQL.getClasseValor());
            return new Coluna(colunaSQL.getNome(), (TipoDado)colunaSQL.getTipoDadoBase(), null);
        }
        if (!colunaSQL.getNome().matches("extra\\d{1,2}")) return coluna;
        if (colunaSQL.getTipoDadoBase() == null) return coluna;
        coluna.setTipoDado(colunaSQL.getTipoDadoBase());
        return coluna;
    }

    private Coluna getDefinicaoColuna(String nomeTabela, String campo, List<String> fks) {
        if (Util.listNullOrEmpty(fks)) {
            return DicionarioDados.getInstance().getTabela(nomeTabela).getColuna(campo.toLowerCase(Locale.getDefault()));
        }
        Tabela tabela = DicionarioDados.getInstance().getTabela(nomeTabela);
        ChaveEstrangeira chave = tabela.getChaveEstrangeira(fks.get(0));
        fks.remove(0);
        return this.getDefinicaoColuna(chave.getTabelaReferencia(), campo.toLowerCase(Locale.getDefault()), fks);
    }

    public HashMap<String, ColunaCustomizavelGrid> getMapColunasCustomizaveisPorNome() {
        if (this.mapColunasCustomizaveisPorNome == null) {
            this.mapColunasCustomizaveisPorNome = new HashMap();
        }
        return this.mapColunasCustomizaveisPorNome;
    }

    public HashMap<String, ColunaCustomizavelGrid> getMapColunasCustomizaveisPorAlias() {
        if (this.mapColunasCustomizaveisPorAlias == null) {
            this.mapColunasCustomizaveisPorAlias = new HashMap();
        }
        return this.mapColunasCustomizaveisPorAlias;
    }

    public boolean isUsaVisao() {
        return this.usaVisao;
    }
}

