/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.grid;

import br.intelidata.commons.core.sql.ConversorResultSet2;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.uniplusweb.core.service.SelectJson;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class SelectHierarquiaJson
extends SelectJson {
    public SelectHierarquiaJson(String tabela, String colunaParaPesquisar, String ... colunasParaIncluir) {
        super(tabela, colunaParaPesquisar, colunasParaIncluir);
        this.colunasParaIncluir.add(new ColunaSQL("codigo"));
        this.uSelect.add(new ColunaSQL("codigo"));
    }

    public SelectHierarquiaJson(String tabela, ArrayList<String> colunasParaPesquisar, String ... colunasParaIncluir) {
        super(tabela, colunasParaPesquisar, colunasParaIncluir);
        this.colunasParaIncluir.add(new ColunaSQL("codigo"));
        this.uSelect.add(new ColunaSQL("codigo"));
    }

    public ResponseEntity<String> getDataJson(String query, String codigo) {
        this.uSelect.getCondicoes().clear();
        if (query == null || query.isEmpty()) {
            this.filtro(codigo);
        } else {
            if (codigo == null) {
                IntStream.range(0, this.colunasParaPesquisar.size()).forEach(index -> {
                    String coluna = ((ColunaSQL)this.colunasParaPesquisar.get(index)).getNome();
                    this.uSelect.add(new Condicao(coluna, Operador.CONTEM, query));
                    if (index + 1 < this.colunasParaPesquisar.size()) {
                        this.uSelect.add(new Condicao(OperadorLogico.OU));
                    }
                });
                this.uSelect.setLimit(10);
            }
            this.filtroComQuery(codigo);
        }
        Sql sql = new Sql(this.uSelect);
        List dados = ConversorResultSet2.converterSqlWeb((List)this.colunasParaIncluir, null, (Sql)sql, (int)0);
        sql.close();
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Type", "application/json; charset=UTF-8");
        return new ResponseEntity((Object)JsonUtil.toJson((List)dados, (List)this.colunasParaIncluir), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    protected void filtro(String codigo) {
        if (codigo == null || codigo.isEmpty()) {
            this.uSelect.add((ColunaSQL)new Referencia(Funcao.LENGTH, "codigo", "ref", new Object[0]));
            this.uSelect.add(new Condicao("ref", Operador.IGUAL, 6));
        } else {
            this.uSelect.add(new Condicao("codigo", Operador.COMECE_COM, codigo));
            this.uSelect.add((ColunaSQL)new Referencia(Funcao.LENGTH, "codigo", "ref", new Object[0]));
            this.uSelect.add(new Condicao("ref", Operador.IGUAL, codigo.length() + 6));
        }
    }

    protected void filtroComQuery(String codigo) {
        if (codigo != null) {
            this.uSelect.add(new Condicao("codigo", Operador.COMECE_COM, codigo));
            this.uSelect.add((ColunaSQL)new Referencia(Funcao.LENGTH, "codigo", "ref", new Object[0]));
            this.uSelect.add(new Condicao("ref", Operador.IGUAL, codigo.length() + 6));
        }
    }
}

