/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.metrics;

import com.sun.management.OperatingSystemMXBean;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import java.io.File;
import java.lang.management.ManagementFactory;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="false")
@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="Capturar espa\u00e7o em disco.")
public class HostMetric {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    DataSource dataSource;
    private final File file = new File("/");
    private final Gauge hostDiskFreeSpaceGauge;
    private final Gauge hostMemoryFreeSpaceGauge;

    public HostMetric(CollectorRegistry registry) {
        Gauge hostDiskTotalSpaceGauge = ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("host_disk_total_space")).help("espa\u00e7o total em disco")).create();
        this.hostDiskFreeSpaceGauge = ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("host_disk_free_space")).help("espa\u00e7o livre em disco")).create();
        this.hostMemoryFreeSpaceGauge = ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("host_memory_free_space")).help("espa\u00e7o livre em memoria")).create();
        Gauge hostMemoryTotalSpaceGauge = ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("host_memory_total_space")).help("espa\u00e7o total em memoria")).create();
        registry.register((Collector)hostDiskTotalSpaceGauge);
        registry.register((Collector)this.hostDiskFreeSpaceGauge);
        registry.register((Collector)this.hostMemoryFreeSpaceGauge);
        registry.register((Collector)hostMemoryTotalSpaceGauge);
        long memorySize = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
        hostMemoryTotalSpaceGauge.set((double)memorySize);
        hostDiskTotalSpaceGauge.set((double)this.file.getTotalSpace());
    }

    @Async
    @Scheduled(fixedDelay=30000L)
    public void coletaMetricaHost() {
        this.log.debug("Metricas atualizadas");
        this.hostDiskFreeSpaceGauge.set((double)this.file.getFreeSpace());
        this.hostMemoryFreeSpaceGauge.set((double)Runtime.getRuntime().freeMemory());
    }
}

