/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.metrics;

import br.intelidata.uniplusweb.config.UnipluswebProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@ConditionalOnExpression(value="false")
public class MetricRegistryService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UnipluswebProperties unipluswebProperties;
    private RestTemplate restTemplate = new RestTemplate();
    private String serverHost;

    public MetricRegistryService() {
        try {
            this.serverHost = InetAddress.getLocalHost().getHostAddress() + ":8080";
        }
        catch (UnknownHostException e) {
            this.log.info("Falhou ao capturar o IP.");
        }
        this.log.info("IP local: {}", (Object)this.serverHost);
    }

    @Async
    @Scheduled(fixedDelay=30000L)
    public void registra() {
        this.log.debug("Metricas atualizadas");
        try {
            this.restTemplate.getForEntity(this.unipluswebProperties.getMetrics().getUrl() + "/" + this.serverHost, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("N\u00e3o foi poss\u00edvel obter as m\u00e9tricas.");
        }
    }
}

