/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.service;

import br.intelidata.commons.bridge.Bridge;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.agendador.ProcessBuilderWrapper;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.service.AtualizacaoBaseDadosService;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.SystemUtil;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.service.MDCConfigService;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class RestoreBackupService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String[] COMANDOS_BASICOS;
    private final IConnectionHandler connectionHandler;
    private final StorageService storageService;
    private final UnipluswebProperties unipluswebProperties;
    private final MDCConfigService mdcConfigService;
    private final TenantService tenantService;
    private final AtualizacaoBaseDadosService atualizacaoBaseDadosService;
    private final ConnectionOAuth2Service connectionOAuth2Service;

    public RestoreBackupService(IConnectionHandler connectionHandler, StorageService storageService, UnipluswebProperties unipluswebProperties, TenantService tenantService, AtualizacaoBaseDadosService atualizacaoBaseDadosService, ConnectionOAuth2Service connectionOAuth2Service, MDCConfigService mdcConfigService) {
        String[] stringArray;
        if (SystemUtil.isLinux()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "/bin/sh";
            stringArray = stringArray2;
            stringArray2[1] = "-c";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "cmd.exe";
            stringArray = stringArray3;
            stringArray3[1] = "/c";
        }
        this.COMANDOS_BASICOS = stringArray;
        this.tenantService = tenantService;
        this.atualizacaoBaseDadosService = atualizacaoBaseDadosService;
        this.connectionOAuth2Service = connectionOAuth2Service;
        this.connectionHandler = connectionHandler;
        this.storageService = storageService;
        this.unipluswebProperties = unipluswebProperties;
        this.mdcConfigService = mdcConfigService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restaurarAWS(Tenant tenant, String ambiente, String nomeArquivo) {
        this.mdcConfigService.confiMDC(tenant.getCodigo());
        File backup = null;
        try {
            backup = File.createTempFile("backup", ".backup");
            File directory = backup.getParentFile();
            this.log.info("Realizando o download do arquivo " + nomeArquivo + " para restaurar o backup.");
            this.storageService.downloadBackup(backup, tenant.getCodigo(), ambiente, nomeArquivo, TipoArquivoArmazenado.Backup, tenant.isDemonstracao());
            String variaveisAmbiente = "PGPASSWORD=" + this.unipluswebProperties.getDatasource().getPassword();
            String url = this.unipluswebProperties.getDatasource().getRawUrl();
            List<String> comandos = Arrays.asList("/bin/sh", "-c", "/usr/bin/pg_restore --host \"" + url + "\" --port 5432 --no-owner --role=uniplusweb --username \"" + this.unipluswebProperties.getDatasource().getUsername() + "\" --dbname " + this.tenantService.getDatabase(tenant.getCodigo()) + " " + backup.getAbsolutePath());
            this.log.info("Executando a restaura\u00e7\u00e3o com os seguintes comandos: " + String.join((CharSequence)",", comandos));
            ProcessBuilderWrapper processBuilder = new ProcessBuilderWrapper(directory, comandos, new String[]{variaveisAmbiente});
            int result = processBuilder.getStatus();
            this.log.info("Restaura\u00e7\u00e3o efetuada com sucesso: Result postgres {}, {}", (Object)result, (Object)processBuilder.getErrors());
            this.atualizarBase(tenant);
        }
        catch (Throwable e) {
            this.log.error("Erro ao executar o comando de restaura\u00e7\u00e3o de backup", e);
            try {
                this.atualizarBase(tenant);
            }
            catch (UnicoMensagemUsuarioException ex) {
                this.log.error("N\u00e3o foi poss\u00edvel restaurar a base de dados {} {}", (Object)tenant.getCodigo(), (Object)ex);
            }
        }
        finally {
            try {
                ResponseEntity response = this.connectionOAuth2Service.post("/tenant/atualizar-dados-restauracao/" + tenant.getCodigo(), new JSONObject(), Void.class);
                if (response.getStatusCode() != HttpStatus.OK) {
                    this.log.error("N\u00e3o foi poss\u00edvel atualizar os dados da restaura\u00e7\u00e3o de backup do tenant no Logtracker");
                }
            }
            catch (UnicoMensagemUsuarioException ex) {
                this.log.error("N\u00e3o foi poss\u00edvel atualizar os dados da restaura\u00e7\u00e3o de backup do tenant no Logtracker", (Throwable)ex);
            }
            if (this.connectionHandler.isConnected()) {
                this.connectionHandler.releaseConnection();
            }
            if (backup != null && backup.exists()) {
                try {
                    FileUtils.forceDelete((File)backup);
                }
                catch (IOException e) {
                    backup.deleteOnExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restaurarLocalmente(Tenant tenant, File backupTempLocal) throws UnicoMensagemUsuarioException {
        try {
            File directory = backupTempLocal.getParentFile();
            String variaveisAmbiente = "PGPASSWORD=" + this.unipluswebProperties.getDatasource().getPassword();
            String url = this.unipluswebProperties.getDatasource().getRawUrl();
            boolean isLinux = SystemUtil.isLinux();
            String pg = isLinux ? "/usr/bin/pg_restore " : "pg_restore.exe ";
            Object[] comando = new String[]{pg + "  --host \"" + url + "\" --port 5432 --no-owner --role=uniplusweb --username \"" + this.unipluswebProperties.getDatasource().getUsername() + "\" --dbname " + this.tenantService.getDatabase(tenant) + " " + backupTempLocal.getAbsolutePath()};
            if (!isLinux) {
                String diretorioPG = this.unipluswebProperties.getBancoDados().getDiretorio();
                if (!SystemUtil.isExisteInstalacaoPostgresOuCaminhoConfigurado((String)diretorioPG)) {
                    throw new UnicoMensagemUsuarioException("WWW404", "N\u00e3o foi poss\u00edvel executar o backup. Verifique o diret\u00f3rio configurado para o Banco de Dados.");
                }
                this.log.info("Diret\u00f3rio do PG: " + SystemUtil.getDiretorioPostgres((String)diretorioPG));
                directory = new File(SystemUtil.getDiretorioPostgres((String)diretorioPG));
            }
            CharSequence[] comandos = (String[])ArrayUtils.addAll((Object[])this.COMANDOS_BASICOS, (Object[])comando);
            this.log.warn("Executando restaura\u00e7\u00e3o no " + (isLinux ? "Linux" : "Windows") + " com os seguintes comandos: {}", (Object)String.join((CharSequence)" ", comandos));
            ProcessBuilderWrapper processBuilder = new ProcessBuilderWrapper(directory, Arrays.asList(comandos), new String[]{variaveisAmbiente});
            int result = processBuilder.getStatus();
            this.log.warn("Restaura\u00e7\u00e3o efetuada com sucesso: Result postgres {}, {}", (Object)result, (Object)processBuilder.getErrors());
            try {
                this.atualizarBase(tenant);
            }
            catch (Exception ex) {
                throw new UnicoMensagemUsuarioException("WWW405", "N\u00e3o foi poss\u00edvel determinar se houve sucesso ao restaurar a base de dados. Por favor consulte a base.", (Throwable)ex);
            }
        }
        finally {
            if (this.connectionHandler.isConnected()) {
                this.connectionHandler.releaseConnection();
            }
            FileUtils.deleteQuietly((File)backupTempLocal);
        }
    }

    private void atualizarBase(Tenant tenant) throws UnicoMensagemUsuarioException {
        this.log.info("Conectando a base de dados do tenant " + tenant.getCodigo());
        ContextoHolder.setTenant((String)tenant.getCodigo(), (String)this.tenantService.getDatabase(tenant.getCodigo()));
        try {
            if (!this.connectionHandler.isConnected()) {
                this.connectionHandler.createConnection(true);
                this.connectionHandler.beginTransaction();
            }
            Bridge.getBridge().initCache();
            this.log.info("Verificando a base de dados do tenant " + tenant.getCodigo());
            ContextoHolder.setSessao((Sessao)SessaoUtil.getSessaoSistema());
            this.atualizacaoBaseDadosService.atualizacaoBaseDados(tenant.getCodigo());
            this.log.info("Fim da verifica\u00e7\u00e3o da base de dados");
            this.tenantService.inicializaTenant(tenant.getCodigo());
            this.connectionHandler.commit();
        }
        catch (Exception ex) {
            this.log.error("A base de dados foi restaurada, por\u00e9m n\u00e3o foi poss\u00edvel verificar a atualiza\u00e7\u00e3o das tabelas/colunas.", (Throwable)ex);
            throw ex;
        }
    }
}

