/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring.aop;

import br.intelidata.commons.bridge.Bridge;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.ServerStartupMonitor;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sistema.StatelessRequest;
import br.intelidata.core.aop.DBTransactionExecutor;
import br.intelidata.core.aop.InterfaceAfterCommit;
import br.intelidata.core.sgdb.IConnectionHandler;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DBTransactionWeb
implements DBTransactionExecutor {
    private final Logger log = LoggerFactory.getLogger(DBTransactionWeb.class);
    private final IConnectionHandler connectionHandler;

    @Autowired
    public DBTransactionWeb(IConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public Object dbTransaction(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object value;
        if (proceedingJoinPoint.getArgs().length > 0 && proceedingJoinPoint.getArgs()[0] instanceof StatelessRequest) {
            StatelessRequest req = (StatelessRequest)proceedingJoinPoint.getArgs()[0];
            Sessao sessao = req.getSessao();
            ContextoHolder.setSessao((Sessao)sessao);
        }
        if (!ServerStartupMonitor.isIniciado((String)ContextoHolder.getTenant())) {
            throw new UnicoException("WWW729", "O servidor ainda n\u00e3o est\u00e1 dispon\u00edvel para receber conex\u00f5es.");
        }
        try {
            this.connectionHandler.createConnection(false);
            this.connectionHandler.beginTransaction();
            Bridge.getBridge().initCache();
            value = proceedingJoinPoint.proceed();
            this.connectionHandler.commit();
            if (proceedingJoinPoint.getTarget() instanceof InterfaceAfterCommit) {
                InterfaceAfterCommit iac = (InterfaceAfterCommit)proceedingJoinPoint.getTarget();
                iac.afterCommit();
            }
        }
        catch (Throwable throwable) {
            Bridge.getBridge().remove();
            try {
                if (this.connectionHandler != null) {
                    this.connectionHandler.rollback();
                }
            }
            catch (RuntimeException e) {
                this.log.error("Erro ao executar o rollback ", (Throwable)e);
            }
            throw throwable;
        }
        finally {
            Bridge.getBridge().remove();
            try {
                if (this.connectionHandler != null) {
                    this.connectionHandler.releaseConnection();
                }
            }
            catch (RuntimeException e) {
                this.log.error("Method - " + proceedingJoinPoint.getSignature().getDeclaringType().getSimpleName() + "." + proceedingJoinPoint.getSignature().getName());
            }
        }
        return value;
    }
}

