/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring.aop.baseUniplusWeb;

import br.intelidata.uniplusweb.core.sgbd.ConnectionHandlerJob;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DBAutoCommitCoreExecute {
    private final Logger log = LoggerFactory.getLogger(DBAutoCommitCoreExecute.class);
    private final ConnectionHandlerJob connectionHandler;

    @Autowired
    public DBAutoCommitCoreExecute(ConnectionHandlerJob connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public Object dbCommit(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object value = null;
        try {
            this.connectionHandler.createConnection(true);
            value = proceedingJoinPoint.proceed();
        }
        catch (Exception e) {
            this.log.error("Error", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (this.connectionHandler != null) {
                    this.connectionHandler.releaseConnection();
                }
            }
            catch (RuntimeException e) {
                this.log.error("Core -> Method - " + proceedingJoinPoint.getSignature().getDeclaringType().getSimpleName() + "." + proceedingJoinPoint.getSignature().getName());
            }
        }
        return value;
    }
}

