/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring.multitenant;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.RuntimeDataSource;
import br.intelidata.commons.bridge.TenantNaoPermitidoException;
import br.intelidata.uniplusweb.core.spring.multitenant.DataSourceFactory;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MultitenantDataSource
implements RuntimeDataSource {
    @Autowired
    private DataSourceFactory dataSourceFactory;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private DataSource dataSource;
    private ConcurrentMap<String, DataSource> map = new ConcurrentHashMap();

    public DataSource getDataSource() {
        String tenant = ContextoHolder.getTenant();
        if (tenant == null) {
            return this.dataSource;
        }
        return this.getDataSource(tenant);
    }

    public DataSource getDataSource(String idTenant) {
        if (idTenant == null || idTenant.isEmpty()) {
            throw new TenantNaoPermitidoException("Tenant n\u00e3o definido");
        }
        DataSource dataSource = (DataSource)this.map.get(idTenant);
        if (dataSource == null) {
            Tenant tenant = this.tenantService.getTenant(idTenant);
            dataSource = this.dataSourceFactory.criaDataSource(tenant.getUrlDatabase());
            if ((dataSource = this.map.putIfAbsent(idTenant, dataSource)) == null) {
                dataSource = (DataSource)this.map.get(idTenant);
            }
        }
        return dataSource;
    }
}

