/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.tenant;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.uniplusweb.core.service.RestoreBackupService;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.service.TenantLocalService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Profile(value={"dev", "prod", "aws"})
@RestController
public class TenantController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RestoreBackupService restoreBackupService;
    private final TenantLocalService tenantLocalService;
    private final TenantService tenantService;

    public TenantController(TenantLocalService tenantLocalService, TenantService tenantService, RestoreBackupService restoreBackupService) {
        this.tenantLocalService = tenantLocalService;
        this.tenantService = tenantService;
        this.restoreBackupService = restoreBackupService;
    }

    @RequestMapping(value={"/tenants/atualizar-tenants"})
    public ResponseEntity<String> atualizarTenants() {
        this.log.info("Atualizando a lista de tenants manualmente.");
        boolean tenantAtualizados = this.tenantLocalService.atualizarTenants();
        return tenantAtualizados ? ResponseEntity.ok((Object)"Tenants atualizados com sucesso.") : new ResponseEntity((Object)"N\u00e3o foi poss\u00edvel atualizar os tenants. Consulte o log para mais detalhes.", HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @RequestMapping(value={"/tenants/informacoes/{tenant}"})
    public Tenant getInformacoesTenant(@PathVariable(value="tenant") String codigoTenant) {
        Tenant t = this.tenantService.getTenant(codigoTenant, false);
        if (t != null) {
            return new Tenant(t.getCodigo(), t.getDescricao(), t.getInativo(), t.getInicializado());
        }
        return null;
    }

    @RequestMapping(value={"/tenants/restaurar-backup/{tenant}"}, method={RequestMethod.POST})
    public void agendarRestauracao(@RequestPart(value="file") MultipartFile multipartFile, @PathVariable(value="tenant") String codigoTenant) throws UnicoMensagemUsuarioException {
        long maxSizeBytes;
        if (multipartFile.isEmpty()) {
            throw new UnicoMensagemUsuarioException("WWW398", "Arquivo inv\u00e1lido.");
        }
        long fileSizeBytes = multipartFile.getSize();
        if (fileSizeBytes > (maxSizeBytes = 0x40000000L)) {
            throw new UnicoMensagemUsuarioException("WWW406", "O arquivo de backup \u00e9 muito grande. O tamanho m\u00e1ximo suportado \u00e9 de  1GB. Para restaurar arquivos maiores, v\u00e1 no painel de controle, guia 'Tenants' e utilize a op\u00e7\u00e3o 'Restaurar backup'");
        }
        Tenant tenant = this.tenantService.getTenant(codigoTenant);
        File backupTemp = FileUtil.validarArquivoBackup((MultipartFile)multipartFile);
        this.restoreBackupService.restaurarLocalmente(tenant, backupTemp);
    }
}

