/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.security.oauth2;

import br.intelidata.commons.bridge.ContextoHolder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class JwtTokenEnhancer
implements TokenEnhancer {
    public OAuth2AccessToken enhance(OAuth2AccessToken accessToken, OAuth2Authentication authentication) {
        LinkedHashMap m;
        HashMap<String, String> additionalInformation = new HashMap<String, String>();
        String tenant = ContextoHolder.getTenant();
        additionalInformation.put("tenant", tenant);
        DefaultOAuth2AccessToken defaultAccessToken = (DefaultOAuth2AccessToken)accessToken;
        defaultAccessToken.setAdditionalInformation(additionalInformation);
        if (authentication.getUserAuthentication() != null && (m = (LinkedHashMap)authentication.getUserAuthentication().getDetails()) != null && m.containsKey("tecnico") && m.get("tecnico").equals("true")) {
            List listScope = Arrays.stream(accessToken.getScope().toArray(new String[0])).collect(Collectors.toList());
            listScope.add("jobs-admin");
            String scope = String.join((CharSequence)",", listScope);
            defaultAccessToken.setScope(StringUtils.commaDelimitedListToSet((String)scope));
        }
        return defaultAccessToken;
    }
}

