/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.api.batch.BatchService;
import br.intelidata.api.batch.ITask;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.batch.TaskStatus;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"aws"})
public class BatchServiceAmazon
implements BatchService {
    private final UnipluswebProperties unipluswebProperties;

    public BatchServiceAmazon(UnipluswebProperties unipluswebProperties) {
        this.unipluswebProperties = unipluswebProperties;
    }

    public void atualizaTask(Task task) {
        task.setAmiInstancia(this.getAmi());
    }

    public List<Task> getTasks(ITask iTask, int limit) {
        return iTask.getTasksToProcessBlocked(TaskStatus.ENQUEUED, limit, this.getAmi());
    }

    public List<Task> getTasks(ITask iTask, TaskStatus ... status) {
        return iTask.getTasks(this.getAmi(), status);
    }

    private String getAmi() {
        return this.unipluswebProperties.getAmbiente().getInstancia() + this.unipluswebProperties.getAmbiente().getAwsami();
    }
}

