/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoArquivoBlocoX;
import br.intelidata.commons.domain.pojo.pafecf.EnvioBlocoX;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Service;
import unipaf.geracaoarquivo.blocox.GravacaoArquivoBlocoX;

@Service
public class GravacaoArquivoBlocoXService
implements GravacaoArquivoBlocoX {
    private final StorageService storageService;

    public GravacaoArquivoBlocoXService(StorageService storageService) {
        this.storageService = storageService;
    }

    public void gravarRecibo(EnvioBlocoX envioBlocoX) throws UnicoMensagemUsuarioException {
        if (this.arquivoExiste(envioBlocoX.getArquivo())) {
            try {
                if (TipoArquivoBlocoX.ESTOQUE.equals((Object)envioBlocoX.getTipoArquivo())) {
                    String nomeArquivo = envioBlocoX.getArquivo().replace(".xml", "") + "_recibo";
                    File recibo = File.createTempFile(nomeArquivo, ".xml");
                    try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(recibo.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                        if (!StringUtil.stringNullOrEmpty((String)envioBlocoX.getRetornoConsulta())) {
                            bw.write(envioBlocoX.getRetornoConsulta());
                        } else {
                            bw.write(envioBlocoX.getRetornoEnvio());
                        }
                    }
                    this.storageService.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, recibo, "pafecf/geracaoautomatica/Recibos dos Arquivos com Informacoes do Estoque Mensal do Estabelecimento", nomeArquivo, false, null, false, true);
                }
                this.storageService.moveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, "pafecf/geracaoautomatica/enviar" + File.separator + envioBlocoX.getArquivo(), "pafecf/geracaoautomatica/transmitidos" + File.separator + envioBlocoX.getArquivo(), false, false);
                if (!this.storageService.isFileServer()) {
                    this.excluirArquivo(envioBlocoX.getArquivo());
                }
            }
            catch (IOException ex) {
                throw new UnicoMensagemUsuarioException("WWW545", "N\u00e3o foi poss\u00edvel gravar o recibo do BlocoX", (Throwable)ex);
            }
        }
    }

    public void gravarArquivoBlocoX(File tmp, String nomeArquivo) {
        this.storageService.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, tmp, "pafecf/geracaoautomatica/enviar", FilenameUtils.removeExtension((String)nomeArquivo), false, null, false, true);
    }

    public boolean excluirArquivo(String nomeArquivo) {
        this.storageService.excluirArquivo(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, "pafecf/geracaoautomatica/enviar" + File.separator + nomeArquivo, false, false);
        return true;
    }

    public boolean arquivoExiste(String nomeArquivo) {
        return this.storageService.existObject(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, "pafecf/geracaoautomatica/enviar" + File.separator + nomeArquivo, false, false);
    }

    public File getArquivo(String nomeArquivo) throws UnicoMensagemUsuarioException {
        return this.storageService.downloadFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, "pafecf/geracaoautomatica/enviar" + File.separator + nomeArquivo, false, false);
    }

    public void inicializarDiretorios() {
        String tenant = ContextoHolder.getTenant();
        if (!StringUtil.stringNullOrEmpty((String)tenant)) {
            this.storageService.createFolders(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, "pafecf/geracaoautomatica/enviar", false);
            this.storageService.createFolders(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, "pafecf/geracaoautomatica/transmitidos", false);
            this.storageService.createFolders(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, "pafecf/geracaoautomatica/Recibos dos Arquivos com Informacoes do Estoque Mensal do Estabelecimento", false);
            this.storageService.createFolders(ContextoHolder.getTenant(), TipoArquivoArmazenado.BlocoX, "pafecf/geracaoautomatica/Recibos dos Arquivos com Informacoes da Reducao Z do PAF-ECF", false);
        }
    }

    public void criarDiretorios() {
        this.inicializarDiretorios();
    }
}

