/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.logtracker.pojo.Info;
import br.intelidata.commons.core.logtracker.pojo.InfoFilial;
import br.intelidata.commons.core.logtracker.pojo.InfoLicenca;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.sql.ConnectionSql;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.regranegocio.EcfCommonRN;
import br.intelidata.commons.domain.regranegocio.FilialCommonRN;
import br.intelidata.commons.domain.regranegocio.LicencaCommonRN;
import br.intelidata.commons.modulo.pdv.regranegocio.EnvioBlocoXRN;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import unico.pojo.Licenca;

@Service
public class IdentificadorLicencaService {
    public Map<String, Object> getIdentificador() {
        return this.getIdentificador(null);
    }

    public Map<String, Object> getIdentificador(Object identificadorPersonalizado) {
        HashMap<String, Object> identificador = new HashMap<String, Object>();
        Info info = new Info();
        info.setNomeMaquina(Util.getNomeMaquina());
        info.setIp(Util.getIpLocal());
        info.setEnderecoMAC(Util.getEnderecoMac());
        info.setVersaoSistema(UnicoSistema.getVersao());
        info.setBuildSistema(UnicoSistema.getVersao());
        info.setCompilacaoSistema(UnicoSistema.getVersao());
        info.setVersaoUnipaf(EcfCommonRN.getInstance().buscarVersoesPaf());
        info.setEnderecoServidorBaseDados(ConnectionSql.getConfiguraConexao().getHost());
        info.setNomeBaseDados(ConnectionSql.getConfiguraConexao().getBaseDados());
        info.setNumeroUsuariosLicenca(Integer.valueOf(LicencaManager.getInstance().getNumeroUsuariosLicenca()));
        identificador.put("info", info);
        if (identificadorPersonalizado != null) {
            identificador.put("person", identificadorPersonalizado);
        } else {
            info.setFiliais(this.getListaFiliais());
            Licenca licencaPrincipal = LicencaCommonRN.getInstance().buscarLicencaPrincipal();
            if (licencaPrincipal != null) {
                List licencas = licencaPrincipal.getLicencasInstaladas();
                ArrayList<InfoLicenca> listaInfoLicenca = new ArrayList<InfoLicenca>();
                for (Licenca licenca : licencas) {
                    InfoLicenca infoLicenca = new InfoLicenca();
                    infoLicenca.setRazaoSocial(licenca.getRazaSocial());
                    infoLicenca.setCnpj(licenca.getCnpj());
                    infoLicenca.setChaveInstalacao(licenca.getChaveInstalacao());
                    infoLicenca.setLicenca(licenca.getChaveAtivacao());
                    infoLicenca.setAtivacao(licenca.getDataAtivacao());
                    infoLicenca.setVersaoAtual(licenca.getVersaoAtual());
                    infoLicenca.setBuildAtual(licenca.getBuildAtual());
                    infoLicenca.setVencimento(licenca.getDataValidade());
                    infoLicenca.setVariacaoCPF(licenca.getVariacaoCPF());
                    listaInfoLicenca.add(infoLicenca);
                }
                info.setLicencas(listaInfoLicenca);
            }
        }
        return new HashMap<String, Object>(identificador);
    }

    private List<InfoFilial> getListaFiliais() {
        return FilialCommonRN.getInstance().buscarLista().stream().map(filial -> {
            InfoFilial infoFilial = new InfoFilial();
            infoFilial.setRazaoSocial(filial.getRazaoSocialCompleta());
            infoFilial.setNome(filial.getNome());
            infoFilial.setCnpj(filial.getCnpj());
            infoFilial.setBairro(filial.getBairro());
            infoFilial.setCidade(filial.getCidade());
            infoFilial.setEstado(filial.getEstado());
            infoFilial.setEndereco(filial.getEndereco());
            infoFilial.setNumero(filial.getNumero());
            infoFilial.setComplemento(filial.getComplemento());
            infoFilial.setCep(filial.getCep());
            infoFilial.setEmail(filial.getEmail());
            infoFilial.setTelefone(filial.getTelefone());
            infoFilial.setInscricaoEstadual(filial.getInscricaoEstadual());
            infoFilial.setInscricaoMunicipal(filial.getInscricaoMunicipal());
            infoFilial.setReponsavel(filial.getResponsavel());
            infoFilial.setSite(filial.getSite());
            infoFilial.setCnae(filial.getCnae());
            infoFilial.setVariacaoCPF(filial.getVariacaoCPF());
            if (filial.getTipoEnquadramento() != null) {
                infoFilial.setEnquadramentoFiscal(filial.getTipoEnquadramento().getDescricao());
            }
            infoFilial.setDiasSemTransmitirBlocoX(EnvioBlocoXRN.getInstance().getQuantidadeDiasSemTransmitir(filial.getId()));
            return infoFilial;
        }).collect(Collectors.toList());
    }
}

