/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sql.usql.Coalesce;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCusto;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCustoAquisicao;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCustoMedio;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCustoMedioInicial;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelDataUltimaCompra;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelICMSEntradaComporPrecoAntigo;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelPercentualLucro;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelPercentualMarkup;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelPreco;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelPrecoUltimaCompra;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import java.util.ArrayList;
import org.springframework.stereotype.Component;

@Component
public class PromptProdutoServicoGridService {
    private final FuncionalidadeService funcionalidadeService;

    public PromptProdutoServicoGridService(FuncionalidadeService funcionalidadeService) {
        this.funcionalidadeService = funcionalidadeService;
    }

    public GridBuilder<ProdutoRN> getGrid(TipoRegistroProduto tipoRegistro) {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 80, true));
        colunas.add(new ColunaSQL("referencia", "Refer\u00eancia", 80, true));
        colunas.add(new ColunaSQL("ean", "C\u00f3digo de barras", 150, true));
        colunas.add(new ColunaSQL("nome", "Nome", 400, true));
        colunas.add(new ColunaSQL("codigo", "unidademedida", "UN", 50, true, new String[]{"fk_produto_unidademedida"}));
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            USelect grid = new USelect("preco", "pf");
            grid.add(new ColunaSQL("preco", "preco"));
            grid.add((ColunaSQL)new Referencia("produto", "prod"));
            grid.add((ColunaSQL)new Referencia("filial", "filial"));
            grid.add(new Condicao("prod", Operador.IGUAL_REFERENCIA_EXTERNA, "codigo"));
            grid.add(new Condicao("filial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getCodigo()));
            ColunaSQL colunaPreco = new ColunaSQL(new Coalesce(grid, "precoproduto"), "preco", new String[0]);
            colunaPreco.setVisivel(true);
            colunaPreco.setTamanho(100);
            colunaPreco.setDescricao("Pre\u00e7o unit.");
            colunas.add(colunaPreco);
        } else {
            colunas.add(new ColunaSQL("preco", "Pre\u00e7o unit.", 100, true));
        }
        colunas.add(new ColunaSQL("observacao", "Observa\u00e7\u00e3o", 300, true));
        colunas.add(new ColunaSQL("casasdecimais", "Casas decimais", 0, false));
        colunas.add(new ColunaSQL("casasDecimais", "Casas decimais", 0, false));
        colunas.add(new ColunaSQL("casasDecimaisPrecoCusto", "Casas decimais custo", 0, false));
        colunas.add(new ColunaSQL("casasdecimais", "casasdecimaisunidade", null, 0, false, new String[]{"fk_produto_unidademedida"}));
        colunas.add(new ColunaSQL("numeroSerie", "N\u00famero de s\u00e9rie", 0, false));
        colunas.add(new ColunaSQL("possuiLote", "Lote", 0, false));
        colunas.add(new ColunaSQL("possuiVariacao", "Variacao", 0, false));
        String alias = "_prompt";
        alias = tipoRegistro != null ? tipoRegistro.getDescricao().toLowerCase() + alias : TipoRegistroProduto.PRODUTO.getDescricao().toLowerCase() + alias;
        GridBuilder grid = new GridBuilder(ProdutoRN.getInstance().getTabela(), colunas, alias);
        grid.addReferenciaDefault(new Referencia("preco", "precoproduto"));
        grid.addReferenciaDefault(new Referencia("tipo", "tipoRegistro"));
        grid.addReferenciaDefault(new Referencia("precocusto", "precocustoproduto"));
        grid.addReferenciaDefault(new Referencia("precoultimacompra", "precoultimacompraproduto"));
        grid.addReferenciaDefault(new Referencia("customedio", "customedioproduto"));
        grid.addReferenciaDefault(new Referencia("produtoNovo"));
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PRODUTO_EMPRESA)) {
            Long idEmpresa = SessaoUtil.getSessao().getFilial().getIdEmpresa();
            if (tipoRegistro == null) {
                grid.addReferenciaDefault(new Referencia("idempresa", "idempresa", new String[]{"fk_produtoempresa_produto"}));
                grid.addCodicaoDefault(new Condicao(OperadorLogico.E));
                grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
                grid.addCodicaoDefault(new Condicao("idempresa", Operador.IGUAL, idEmpresa));
                grid.addCodicaoDefault(new Condicao("tipoRegistro", Operador.IGUAL, TipoRegistroProduto.PRODUTO.getId()));
                grid.addCodicaoDefault(new Condicao(OperadorLogico.OU));
                grid.addCodicaoDefault(new Condicao("tipoRegistro", Operador.IGUAL, TipoRegistroProduto.SERVICO.getId()));
                grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
            } else if (tipoRegistro == TipoRegistroProduto.PRODUTO) {
                grid.addReferenciaDefault(new Referencia("idempresa", "idempresa", new String[]{"fk_produtoempresa_produto"}));
                grid.addCodicaoDefault(new Condicao("idempresa", Operador.IGUAL, idEmpresa));
            }
        }
        if (tipoRegistro != null) {
            grid.addCodicaoDefault(new Condicao("tipoRegistro", Operador.IGUAL, tipoRegistro.getId()));
        }
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCusto(SessaoUtil.getSessao()));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCustoAquisicao(SessaoUtil.getSessao()));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPreco(SessaoUtil.getSessao()));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelDataUltimaCompra(SessaoUtil.getSessao()));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPrecoUltimaCompra(SessaoUtil.getSessao()));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCustoMedio(SessaoUtil.getSessao()));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCustoMedioInicial(SessaoUtil.getSessao()));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPercentualLucro(SessaoUtil.getSessao()));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPercentualMarkup(SessaoUtil.getSessao()));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelICMSEntradaComporPrecoAntigo(SessaoUtil.getSessao()));
        return grid;
    }
}

