/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.Propriedade;
import br.intelidata.commons.core.sistema.Propriedades;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.UnicoCrypt;
import br.intelidata.commons.domain.pojo.Configuracao;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoCommonRN;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.TipoCache;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.stereotype.Service;

@Service
public class PropriedadeService {
    private final CacheService cacheService;
    private final ModuloService moduloService;
    private final FuncionalidadeService funcionalidadeService;

    public PropriedadeService(CacheService cacheService, ModuloService moduloService, FuncionalidadeService funcionalidadeService) {
        this.cacheService = cacheService;
        this.moduloService = moduloService;
        this.funcionalidadeService = funcionalidadeService;
    }

    public Map<Integer, Object> getPropriedadeValor() {
        return this.getPropriedadeValor(SessaoUtil.getSessao().getFilial().getId());
    }

    public synchronized Map<Integer, Object> getPropriedadeValor(Long idFilial) {
        String idPreferencia = TipoCache.ID_PREFERENCIA.getId().concat(ContextoHolder.getTenant()).concat("_").concat(idFilial.toString());
        Map<Integer, Object> mapPreferencias = null;
        SimpleValueWrapper simpleValueWrapper = (SimpleValueWrapper)this.cacheService.get((Object)idPreferencia);
        if (simpleValueWrapper != null) {
            mapPreferencias = (Map<Integer, Object>)simpleValueWrapper.get();
        }
        if (ListMapUtil.mapNullOrEmpty(mapPreferencias)) {
            List preferencias = ConfiguracaoCommonRN.getInstance().buscarListaPorIdFilial(idFilial);
            preferencias.forEach(preferencia -> {
                if (preferencia.getChave() == 213 || preferencia.getChave() == 40 || preferencia.getChave() == 198) {
                    String senha = preferencia.getValor();
                    if (preferencia.getChave() == 213 && !senha.equalsIgnoreCase("postgres")) {
                        senha = UnicoCrypt.decript((String)senha);
                    } else if ((preferencia.getChave() == 40 || preferencia.getChave() == 198) && UnicoCrypt.decriptIfErroReturnNull((String)senha) != null) {
                        senha = UnicoCrypt.decript((String)senha);
                    }
                    preferencia.setValor(senha);
                }
            });
            mapPreferencias = preferencias.stream().collect(Collectors.toMap(Configuracao::getChave, Configuracao::getValor));
            this.cacheService.put((Object)idPreferencia, mapPreferencias);
        }
        return mapPreferencias;
    }

    public Map<Integer, Propriedade> getPropriedades(Sessao sessao) {
        HashMap mapProp;
        String idPreferencia = TipoCache.ID_PROPRIEDADES.getId().concat(ContextoHolder.getTenant()).concat("_").concat(sessao.getIdFilial().toString());
        HashMap mapPropriedades = null;
        SimpleValueWrapper simpleValueWrapper = (SimpleValueWrapper)this.cacheService.get((Object)idPreferencia);
        if (simpleValueWrapper != null) {
            mapPropriedades = mapProp = (HashMap)simpleValueWrapper.get();
        }
        if (mapPropriedades == null) {
            mapProp = new HashMap();
            Map modulos = this.moduloService.getMapModulos();
            Map funcionalidades = this.funcionalidadeService.getMapFuncionalidade();
            Propriedades visiveis = ModuloManager.getInstance().carregarPreferencias(sessao, modulos, funcionalidades);
            Propriedades insiviveis = ModuloManager.getInstance().carregarPreferenciasInvisiveis(sessao, modulos, funcionalidades);
            Consumer<Propriedade> consumer = p -> mapProp.put(p.getId(), p);
            visiveis.getList().forEach(consumer);
            insiviveis.getList().forEach(consumer);
            mapPropriedades = mapProp;
            this.cacheService.put((Object)idPreferencia, mapPropriedades);
        }
        return mapPropriedades;
    }
}

