/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.core.base.StorageInteface;
import br.intelidata.core.wrapper.ArquivoInfoWrapper;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.coreinterfaces.AmazonS3;
import br.intelidata.uniplusweb.core.coreinterfaces.Profile;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.core.util.SystemUtil;
import br.intelidata.uniplusweb.web.enums.TipoArmazenamentoArquivo;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.Protocol;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Service
public class StorageService
implements StorageInteface {
    private static final String awsBucket = "uniplusweb-ambiente-";
    private static final String rootLocation = "fileserver";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final UnipluswebProperties unipluswebProperties;
    private final AmazonS3 amazonS3Service;
    private final Profile profile;

    @Autowired
    public StorageService(UnipluswebProperties unipluswebProperties, AmazonS3 amazonS3Service, Profile profile) {
        this.unipluswebProperties = unipluswebProperties;
        this.amazonS3Service = amazonS3Service;
        this.profile = profile;
    }

    public boolean isTabela() {
        return this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo() == TipoArmazenamentoArquivo.tabela;
    }

    public boolean isFileServer() {
        return this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo() == TipoArmazenamentoArquivo.arquivo;
    }

    public String saveImagemApi(String tenant, String tipo, MultipartFile multipartFile) throws UnicoMensagemUsuarioException {
        TipoArquivoArmazenado tipoArquivoArmazenado = Enum.valueOf(TipoArquivoArmazenado.class, tipo);
        return this.saveImagem(tenant, tipoArquivoArmazenado, multipartFile);
    }

    public String saveImagem(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, MultipartFile multipartFile) throws UnicoMensagemUsuarioException {
        return this.saveImagem(tenant, tipoArquivoArmazenado, multipartFile, true);
    }

    public String saveImagem(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, MultipartFile multipartFile, boolean gzip) throws UnicoMensagemUsuarioException {
        String extensao = FilenameUtils.getExtension((String)multipartFile.getOriginalFilename());
        FileUtil.validarImagem((String)extensao, (MultipartFile)multipartFile);
        return this.saveFile(tenant, tipoArquivoArmazenado, multipartFile, extensao, true, false, gzip);
    }

    public String saveFile(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, MultipartFile multipartFile, boolean temp) {
        Object[] split;
        Object nameFile = multipartFile.getName();
        String originalName = multipartFile.getOriginalFilename();
        if (!StringUtil.stringNullOrEmpty((String)originalName) && !ListMapUtil.arrayNullOrEmpty((Object[])(split = originalName.split("\\|")))) {
            nameFile = split[1];
        }
        String extensao = FilenameUtils.getExtension((String)nameFile);
        return this.saveFile(tenant, tipoArquivoArmazenado, multipartFile, extensao, false, temp, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String saveFile(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, MultipartFile multipartFile, String extensao, boolean imagem, boolean temp, boolean gzip) {
        TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
        if (tipo == TipoArmazenamentoArquivo.tabela || tipo == TipoArmazenamentoArquivo.arquivo) {
            try {
                String nomeArquivo = null;
                if (!StringUtil.stringNullOrEmpty((String)multipartFile.getName())) {
                    nomeArquivo = multipartFile.getName();
                }
                this.verificaDiretorio(tenant, tipoArquivoArmazenado);
                Path arquivo = this.getPath(tenant, tipoArquivoArmazenado, null, extensao, nomeArquivo, false);
                Files.copy(multipartFile.getInputStream(), arquivo, new CopyOption[0]);
                if (!imagem) return arquivo.toString();
                this.resizeImage(arquivo.toString());
                return arquivo.toString();
            }
            catch (Exception e) {
                throw new UnicoException("WWW429", "Falhou ao salvar o arquivo", (Throwable)e);
            }
        }
        String tempBucket = temp ? "-temp" : "";
        String diretorio = awsBucket + this.unipluswebProperties.getAmbiente().getNome() + tempBucket + "/" + tenant + "/" + tipoArquivoArmazenado.getPath();
        String arquivo = UUID.randomUUID() + "." + extensao;
        com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
        try (InputStream is = multipartFile.getInputStream();){
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(multipartFile.getSize());
            this.uploadFileS3InMemory(s3, diretorio, arquivo, is, metadata, gzip);
            String URL2 = s3.getUrl(awsBucket + this.unipluswebProperties.getAmbiente().getNome() + tempBucket, tenant + "/" + tipoArquivoArmazenado.getPath() + "/" + arquivo).toString();
            if (imagem) {
                this.resizeImageS3(s3, diretorio, arquivo, multipartFile, gzip);
            }
            String string = URL2;
            return string;
        }
        catch (IOException e) {
            throw new UnicoException("WWW430", "Falhou ao salvar o arquivo");
        }
    }

    public String saveFile(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, File file, boolean gzip, ObjectMetadata metadata, boolean temp) {
        return this.saveFile(tenant, tipoArquivoArmazenado, file, null, null, gzip, metadata, temp, false);
    }

    public String saveFile(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, File file, String caminhoRelativo, String fileName, boolean gzip, ObjectMetadata metadata, boolean temp, boolean manterNomeArquivo) {
        String nomeArquivo;
        block18: {
            String extensao = FilenameUtils.getExtension((String)file.getName());
            TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
            if (tipo == TipoArmazenamentoArquivo.tabela || tipo == TipoArmazenamentoArquivo.arquivo) {
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    this.verificaDiretorio(tenant, tipoArquivoArmazenado);
                    String name = !StringUtil.stringNullOrEmpty((String)fileName) ? fileName : FilenameUtils.removeExtension((String)file.getName());
                    Path arquivo = this.getPath(tenant, tipoArquivoArmazenado, caminhoRelativo, extensao, name, manterNomeArquivo);
                    Files.copy(fileInputStream, arquivo, new CopyOption[0]);
                    nomeArquivo = arquivo.toString();
                    break block18;
                }
                catch (IOException e) {
                    throw new UnicoException("WWW431", "Falhou ao salvar o arquivo", (Throwable)e);
                }
            }
            String tempBucket = temp ? "-temp" : "";
            String diretorio = this.getDiretorioS3(tenant, tipoArquivoArmazenado, caminhoRelativo, temp);
            String name = !StringUtil.stringNullOrEmpty((String)fileName) ? fileName : FilenameUtils.removeExtension((String)file.getName());
            String arquivo = name + (manterNomeArquivo ? "" : "-" + UUID.randomUUID().toString()) + "." + extensao;
            com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
            try {
                this.uploadFileS3(s3, diretorio, arquivo, file, gzip, metadata);
                nomeArquivo = this.amazonS3Service.isDev() ? s3.getUrl("uniplusweb-ambiente-intelidata" + tempBucket, tenant + "/" + tipoArquivoArmazenado.getPath() + (!StringUtil.stringNullOrEmpty((String)caminhoRelativo) ? caminhoRelativo : "") + "/" + arquivo).toString() : s3.getUrl(awsBucket + this.unipluswebProperties.getAmbiente().getNome() + tempBucket, tenant + "/" + tipoArquivoArmazenado.getPath() + (!StringUtil.stringNullOrEmpty((String)caminhoRelativo) ? caminhoRelativo : "") + "/" + arquivo).toString();
            }
            catch (Exception e) {
                throw new UnicoException("WWW432", "Falhou ao salvar o arquivo");
            }
        }
        if (!file.delete()) {
            this.log.error("N\u00e3o foi poss\u00edvel excluir o arquivo tempor\u00e1rio {}", (Object)file.getName());
        }
        return nomeArquivo;
    }

    public List<String> share(Malote malote) {
        ArrayList<String> filesName = new ArrayList<String>(malote.getMapArquivos().size());
        TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
        if (tipo == TipoArmazenamentoArquivo.arquivo) {
            try {
                this.verificaDiretorio("", TipoArquivoArmazenado.Share);
                for (Map.Entry entry : malote.getMapArquivos().entrySet()) {
                    String fileName;
                    String extensao = FilenameUtils.getExtension((String)((String)entry.getKey()));
                    Path diretorio = Paths.get(rootLocation, TipoArquivoArmazenado.Share.getPath());
                    Path arquivo = diretorio.resolve((fileName = FilenameUtils.removeExtension((String)((String)entry.getKey())) + "-" + UUID.randomUUID().toString()) + "." + extensao);
                    if (Files.exists(arquivo, new LinkOption[0])) {
                        Files.delete(arquivo);
                    }
                    try (ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])entry.getValue());){
                        Files.copy(inputStream, arquivo, new CopyOption[0]);
                    }
                    filesName.add(this.getServidorURL() + arquivo.toString());
                }
            }
            catch (IOException e) {
                throw new UnicoException("WWW572", "Falhou ao salvar o arquivo");
            }
        }
        String diretorio = this.getShareFolderS3();
        com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
        try {
            for (Map.Entry entry : malote.getMapArquivos().entrySet()) {
                String extensao = FilenameUtils.getExtension((String)((String)entry.getKey()));
                String fileName = FilenameUtils.removeExtension((String)((String)entry.getKey())) + "-" + UUID.randomUUID().toString() + "." + extensao;
                byte[] bt = (byte[])entry.getValue();
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentLength((long)bt.length);
                this.uploadFileS3InMemory(s3, diretorio, fileName, (InputStream)new ByteArrayInputStream(bt), metadata, false);
                String nomeArquivo = s3.getUrl(awsBucket + (this.amazonS3Service.isDev() ? "intelidata" : this.unipluswebProperties.getAmbiente().getNome()) + "-temp", TipoArquivoArmazenado.Share.getPath() + "/" + fileName).toString();
                filesName.add(nomeArquivo);
            }
        }
        catch (Exception e) {
            throw new UnicoException("WWW573", "Falhou ao salvar o arquivo");
        }
        return filesName;
    }

    public void deleteShareFiles(int days) {
        TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
        if (tipo == TipoArmazenamentoArquivo.arquivo) {
            this.verificaDiretorio("", TipoArquivoArmazenado.Share);
            Path diretorio = Paths.get(rootLocation, TipoArquivoArmazenado.Share.getPath());
            try (Stream<Path> paths = Files.list(diretorio);){
                List files = paths.collect(Collectors.toList());
                for (Path file : files) {
                    BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                    LocalDate creation = DataHoraFactory.long2LocalDate((long)attr.lastModifiedTime().to(TimeUnit.MILLISECONDS));
                    int dias = (int)ChronoUnit.DAYS.between(creation, DataHoraFactory.getDataHora(null));
                    if (dias <= days) continue;
                    Files.delete(file);
                }
            }
            catch (IOException ex) {
                this.log.error("N\u00e3o foi poss\u00edvel excluir os arquivos da pasta share", (Throwable)ex);
            }
        }
    }

    public void uploadBackupFile(File file, String tenant, String ambiente, String arquivo, TipoArquivoArmazenado tipoArquivoArmazenado) {
        String extensao = FilenameUtils.getExtension((String)file.getName());
        arquivo = arquivo + "." + extensao;
        String diretorio = awsBucket + ambiente + "-temp/" + tenant + "/" + tipoArquivoArmazenado.getPath();
        com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
        try {
            this.uploadFileS3(s3, diretorio, arquivo, file, true, null);
        }
        catch (Exception e) {
            throw new UnicoException("WWW433", "Falhou ao salvar o arquivo", (Throwable)e);
        }
    }

    public void downloadBackup(File file, String tenant, String ambiente, String nomeArquivo, TipoArquivoArmazenado tipoArquivoArmazenado, boolean isDemonstracao) {
        String diretorio = isDemonstracao ? awsBucket + ambiente : awsBucket + ambiente + "-temp/" + tenant + "/" + tipoArquivoArmazenado.getPath();
        com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
        this.downloadS3(s3, file, diretorio, nomeArquivo);
    }

    public File downloadFile(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, String caminhoRelativo, boolean temp, boolean isCaminhoCompleto) throws UnicoMensagemUsuarioException {
        String nomeArquivo;
        TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
        if (tipo == TipoArmazenamentoArquivo.tabela || tipo == TipoArmazenamentoArquivo.arquivo) {
            Path arquivo;
            Path path = arquivo = isCaminhoCompleto ? Paths.get(caminhoRelativo, new String[0]) : Paths.get(rootLocation, tenant, tipoArquivoArmazenado.getPath(), caminhoRelativo);
            if (Files.exists(arquivo, new LinkOption[0])) {
                return arquivo.toFile();
            }
            return null;
        }
        String complementoDiretorio = null;
        if (!isCaminhoCompleto) {
            String[] fragmentos = caminhoRelativo.split("/");
            nomeArquivo = fragmentos[fragmentos.length - 1];
            complementoDiretorio = Arrays.stream(fragmentos).filter(f -> !f.equals(fragmentos[fragmentos.length - 1])).collect(Collectors.joining("/"));
        } else {
            nomeArquivo = caminhoRelativo.substring(caminhoRelativo.lastIndexOf("/") + 1);
        }
        String diretorio = this.getDiretorioS3(tenant, tipoArquivoArmazenado, complementoDiretorio, temp);
        com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
        try {
            File file = File.createTempFile(FilenameUtils.removeExtension((String)nomeArquivo), "." + FilenameUtils.getExtension((String)caminhoRelativo));
            this.downloadS3(s3, file, diretorio, nomeArquivo);
            return file;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW546", "N\u00e3o foi poss\u00edvel realizar o download", (Throwable)e);
        }
    }

    private void uploadFileS3(com.amazonaws.services.s3.AmazonS3 s3, String diretorio, String arquivo, File file, boolean gzip, ObjectMetadata metadata) throws IOException {
        if (gzip) {
            this.gzipAndUploadS3(s3, diretorio, arquivo, file);
        } else {
            PutObjectRequest request = new PutObjectRequest(diretorio, arquivo, file).withCannedAcl(CannedAccessControlList.PublicRead);
            request.setMetadata(metadata);
            this.uploadS3(s3, request);
        }
    }

    private Path getPath(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, String caminhoRelativo, String extensao, String nomeArquivo, boolean manterNomeArquivo) throws IOException {
        Path diretorio = Paths.get(rootLocation, tenant, tipoArquivoArmazenado.getPath(), !StringUtil.stringNullOrEmpty((String)caminhoRelativo) ? caminhoRelativo : "");
        String fileName = !StringUtil.stringNullOrEmpty((String)nomeArquivo) ? (manterNomeArquivo ? nomeArquivo : nomeArquivo + "-" + UUID.randomUUID().toString()) : UUID.randomUUID().toString();
        Path arquivo = diretorio.resolve(fileName + "." + extensao);
        if (Files.exists(arquivo, new LinkOption[0])) {
            Files.delete(arquivo);
        }
        return arquivo;
    }

    private void uploadFileS3InMemory(com.amazonaws.services.s3.AmazonS3 s3, String diretorio, String arquivo, InputStream input, ObjectMetadata metadata, boolean gzip) throws IOException {
        block39: {
            if (gzip) {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                     GZIPOutputStream output = new GZIPOutputStream(byteArrayOutputStream);){
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                    output.finish();
                    byte[] zipByteArray = byteArrayOutputStream.toByteArray();
                    try (ByteArrayInputStream zipInputStream = new ByteArrayInputStream(zipByteArray);){
                        ObjectMetadata metadataZip = new ObjectMetadata();
                        metadataZip.setContentEncoding("gzip");
                        metadataZip.setContentLength((long)((InputStream)zipInputStream).available());
                        PutObjectRequest request = new PutObjectRequest(diretorio, arquivo, (InputStream)zipInputStream, metadataZip).withCannedAcl(CannedAccessControlList.PublicRead);
                        s3.putObject(request);
                        break block39;
                    }
                    catch (Exception e) {
                        this.exceptionS3(e);
                    }
                    break block39;
                }
            }
            PutObjectRequest request = new PutObjectRequest(diretorio, arquivo, input, metadata).withCannedAcl(CannedAccessControlList.PublicRead);
            this.uploadS3(s3, request);
        }
    }

    private void gzipAndUploadS3(com.amazonaws.services.s3.AmazonS3 s3, String diretorio, String arquivo, File file) throws IOException {
        byte[] buffer = new byte[1024];
        File zipTemp = File.createTempFile(arquivo, ".gzip");
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipTemp);
             GZIPOutputStream output = new GZIPOutputStream(fileOutputStream);
             FileInputStream fileInputStream = new FileInputStream(file);){
            int bytes_read;
            while ((bytes_read = fileInputStream.read(buffer)) > 0) {
                output.write(buffer, 0, bytes_read);
            }
            output.finish();
            PutObjectRequest request = new PutObjectRequest(diretorio, arquivo, zipTemp).withCannedAcl(CannedAccessControlList.PublicRead);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentEncoding("gzip");
            request.setMetadata(metadata);
            this.uploadS3(s3, request);
        }
        Files.deleteIfExists(Paths.get(zipTemp.toURI()));
    }

    private boolean existObject(com.amazonaws.services.s3.AmazonS3 s3, String diretorio, String arquivo) {
        try {
            return s3.doesObjectExist(diretorio, arquivo);
        }
        catch (Exception e) {
            this.exceptionS3(e);
            return false;
        }
    }

    private void uploadS3(com.amazonaws.services.s3.AmazonS3 s3, PutObjectRequest request) {
        try {
            s3.putObject(request);
        }
        catch (Exception e) {
            this.exceptionS3(e);
        }
    }

    private void deleteS3(com.amazonaws.services.s3.AmazonS3 s3, String diretorio, String arquivo) {
        try {
            s3.deleteObject(new DeleteObjectRequest(diretorio, arquivo));
        }
        catch (Exception e) {
            this.exceptionS3(e);
        }
    }

    private void downloadS3(com.amazonaws.services.s3.AmazonS3 s3, File file, String diretorio, String arquivo) {
        try {
            GetObjectRequest request = new GetObjectRequest(diretorio, arquivo);
            S3Object object = s3.getObject(request);
            boolean gzip = false;
            if (object.getObjectMetadata() != null && object.getObjectMetadata().getContentEncoding() != null) {
                gzip = object.getObjectMetadata().getContentEncoding().equalsIgnoreCase("gzip");
            }
            if (gzip) {
                FileUtils.copyInputStreamToFile((InputStream)new GZIPInputStream((InputStream)object.getObjectContent()), (File)file);
            } else {
                FileUtils.copyInputStreamToFile((InputStream)object.getObjectContent(), (File)file);
            }
        }
        catch (Exception e) {
            this.exceptionS3(e);
        }
    }

    public String publishImagem(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, TipoImagem tipoImagem, String arquivoRelativo) {
        return this.publishImagem(tenant, tipoArquivoArmazenado, tipoImagem, arquivoRelativo, null);
    }

    public String publishImagem(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, TipoImagem tipoImagem, String arquivoRelativo, byte[] bFile) {
        TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
        if (tipo == TipoArmazenamentoArquivo.tabela || tipo == TipoArmazenamentoArquivo.arquivo) {
            Path arquivo;
            try {
                arquivo = Paths.get(arquivoRelativo, new String[0]);
            }
            catch (InvalidPathException ex) {
                return "";
            }
            if (Files.notExists(arquivo, new LinkOption[0])) {
                return "";
            }
            if (bFile != null && Files.notExists(arquivo, new LinkOption[0])) {
                this.verificaDiretorio(tenant, tipoArquivoArmazenado);
                try {
                    Files.write(arquivo, bFile, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UnicoException("WWW31", "Falhou ao salvar a imagem");
                }
                this.resizeImage(arquivo.toString());
            }
            return this.getServidorURL() + this.getArquivoImagem(arquivoRelativo, tipoImagem);
        }
        return this.getArquivoImagem(arquivoRelativo, tipoImagem);
    }

    public String publishArquivo(String arquivoRelativo) {
        TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
        if (tipo == TipoArmazenamentoArquivo.tabela || tipo == TipoArmazenamentoArquivo.arquivo) {
            return this.getServidorURL() + arquivoRelativo;
        }
        return arquivoRelativo;
    }

    public boolean existObject(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, String arquivoRelativo, boolean temp) {
        return this.existObject(tenant, tipoArquivoArmazenado, arquivoRelativo, temp, true);
    }

    public boolean existObject(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, String arquivoRelativo, boolean temp, boolean isCaminhoCompleto) {
        String nameFile;
        TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
        if (tipo == TipoArmazenamentoArquivo.tabela || tipo == TipoArmazenamentoArquivo.arquivo) {
            Path arquivo = isCaminhoCompleto ? Paths.get(arquivoRelativo, new String[0]) : Paths.get(rootLocation, tenant, tipoArquivoArmazenado.getPath(), arquivoRelativo);
            return Files.exists(arquivo, new LinkOption[0]);
        }
        String complementoDiretorio = null;
        if (!isCaminhoCompleto) {
            String[] fragmentos = arquivoRelativo.split("/");
            nameFile = fragmentos[fragmentos.length - 1];
            complementoDiretorio = Arrays.stream(fragmentos).filter(f -> !f.equals(fragmentos[fragmentos.length - 1])).collect(Collectors.joining("/"));
        } else {
            nameFile = arquivoRelativo.substring(arquivoRelativo.lastIndexOf("/") + 1);
        }
        String diretorio = this.getDiretorioS3(tenant, tipoArquivoArmazenado, complementoDiretorio, temp);
        com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
        try {
            return this.existObject(s3, diretorio, nameFile);
        }
        catch (Exception e) {
            throw new UnicoException("WWW354", "Falhou ao verificar se existe o arquivo");
        }
    }

    public void excluirArquivo(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, String arquivoRelativo, boolean temp) {
        this.excluirArquivo(tenant, tipoArquivoArmazenado, arquivoRelativo, temp, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void excluirArquivo(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, String arquivoRelativo, boolean temp, boolean isCaminhoCompleto) {
        String nameFile;
        TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
        if (tipo == TipoArmazenamentoArquivo.tabela || tipo == TipoArmazenamentoArquivo.arquivo) {
            try {
                Path arquivo;
                Path path = arquivo = isCaminhoCompleto ? Paths.get(arquivoRelativo, new String[0]) : Paths.get(rootLocation, tenant, tipoArquivoArmazenado.getPath(), arquivoRelativo);
                if (!arquivo.toFile().exists()) return;
                Files.delete(arquivo);
                return;
            }
            catch (IOException e) {
                throw new UnicoException("WWW212", "Falhou ao excluir o arquivo", (Throwable)e);
            }
        }
        String complementoDiretorio = null;
        if (!isCaminhoCompleto) {
            String[] fragmentos = arquivoRelativo.split("/");
            nameFile = fragmentos[fragmentos.length - 1];
            complementoDiretorio = Arrays.stream(fragmentos).filter(f -> !f.equals(fragmentos[fragmentos.length - 1])).collect(Collectors.joining("/"));
        } else {
            nameFile = arquivoRelativo.substring(arquivoRelativo.lastIndexOf("/") + 1);
        }
        String diretorio = this.getDiretorioS3(tenant, tipoArquivoArmazenado, complementoDiretorio, temp);
        com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
        try {
            if (!this.existObject(tenant, tipoArquivoArmazenado, arquivoRelativo, temp, isCaminhoCompleto)) return;
            this.deleteS3(s3, diretorio, nameFile);
            return;
        }
        catch (Exception e) {
            throw new UnicoException("WWW434", "Falhou ao excluir o arquivo");
        }
    }

    public void createFolders(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, String diretorio, boolean temp) {
        TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
        if (tipo == TipoArmazenamentoArquivo.tabela || tipo == TipoArmazenamentoArquivo.arquivo) {
            this.verificaDiretorio(tenant, tipoArquivoArmazenado);
            File file = new File(rootLocation + File.separator + tenant + File.separator + tipoArquivoArmazenado.getPath() + File.separator + diretorio);
            if (!file.exists() && !file.mkdirs()) {
                throw new UnicoException("WWW543", "Falha ao criar o diret\u00f3rio: " + diretorio);
            }
        } else {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(0L);
            ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
            com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
            PutObjectRequest bucketPrincipal = new PutObjectRequest(this.getDiretorioS3(tenant, tipoArquivoArmazenado, null, temp), diretorio + "/", (InputStream)emptyContent, metadata);
            s3.putObject(bucketPrincipal);
        }
    }

    public void moveFile(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, String arquivoRelativoOrigem, String arquivoRelativoDestino, boolean temp, boolean isCaminhoCompleto) {
        TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
        if (tipo == TipoArmazenamentoArquivo.tabela || tipo == TipoArmazenamentoArquivo.arquivo) {
            Path arquivo;
            this.verificaDiretorio(tenant, tipoArquivoArmazenado);
            Path path = arquivo = isCaminhoCompleto ? Paths.get(arquivoRelativoOrigem, new String[0]) : Paths.get(rootLocation, tenant, tipoArquivoArmazenado.getPath(), arquivoRelativoOrigem);
            if (Files.exists(arquivo, new LinkOption[0])) {
                try {
                    Path dest = isCaminhoCompleto ? Paths.get(arquivoRelativoDestino, new String[0]) : Paths.get(rootLocation, tenant, tipoArquivoArmazenado.getPath(), arquivoRelativoDestino);
                    Files.move(arquivo, dest, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception ex) {
                    throw new UnicoException("WWW544", "Erro ao mover arquivo " + arquivoRelativoOrigem + " para " + arquivoRelativoDestino, (Throwable)ex);
                }
            }
        } else {
            com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
            try {
                String nameFileDestino;
                String nameFileOrigem;
                String complementoDiretorioOrigem = null;
                String complementoDiretorioDestino = null;
                if (!isCaminhoCompleto) {
                    String[] fragmentosOrigem = arquivoRelativoOrigem.split("/");
                    nameFileOrigem = fragmentosOrigem[fragmentosOrigem.length - 1];
                    complementoDiretorioOrigem = Arrays.stream(fragmentosOrigem).filter(f -> !f.equals(fragmentosOrigem[fragmentosOrigem.length - 1])).collect(Collectors.joining("/"));
                    String[] fragmentosDest = arquivoRelativoDestino.split("/");
                    nameFileDestino = fragmentosDest[fragmentosDest.length - 1];
                    complementoDiretorioDestino = Arrays.stream(fragmentosDest).filter(f -> !f.equals(fragmentosDest[fragmentosDest.length - 1])).collect(Collectors.joining("/"));
                } else {
                    nameFileOrigem = arquivoRelativoOrigem.substring(arquivoRelativoOrigem.lastIndexOf("/") + 1);
                    nameFileDestino = arquivoRelativoDestino.substring(arquivoRelativoDestino.lastIndexOf("/") + 1);
                }
                if (this.existObject(tenant, tipoArquivoArmazenado, arquivoRelativoOrigem, temp, isCaminhoCompleto)) {
                    CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.getDiretorioS3(tenant, tipoArquivoArmazenado, complementoDiretorioOrigem, temp), nameFileOrigem, this.getDiretorioS3(tenant, tipoArquivoArmazenado, complementoDiretorioDestino, temp), nameFileDestino);
                    s3.copyObject(copyObjectRequest);
                }
            }
            catch (Exception e) {
                throw new UnicoException("WWW547", "Falhou ao copiar o arquivo.", (Throwable)e);
            }
        }
    }

    public void excluirImagem(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, String arquivoRelativo) {
        TipoArmazenamentoArquivo tipo = this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo();
        if (tipo == TipoArmazenamentoArquivo.tabela || tipo == TipoArmazenamentoArquivo.arquivo) {
            try {
                Path arquivo;
                try {
                    arquivo = Paths.get(arquivoRelativo, new String[0]);
                }
                catch (InvalidPathException ex) {
                    return;
                }
                if (Files.exists(arquivo, new LinkOption[0])) {
                    Files.delete(arquivo);
                }
                this.deleteLocal(arquivoRelativo, TipoImagem.Thumbnail);
                this.deleteLocal(arquivoRelativo, TipoImagem.Icone);
                this.deleteLocal(arquivoRelativo, TipoImagem.Pequena);
                this.deleteLocal(arquivoRelativo, TipoImagem.Grande);
                this.deleteLocal(arquivoRelativo, TipoImagem.Icone_Shop);
                this.deleteLocal(arquivoRelativo, TipoImagem.Pequena_Shop);
                this.deleteLocal(arquivoRelativo, TipoImagem.Icone_Gourmet);
            }
            catch (IOException e) {
                throw new UnicoException("WWW199", "Falhou ao excluir o arquivo", (Throwable)e);
            }
        }
        String diretorio = awsBucket + this.unipluswebProperties.getAmbiente().getNome() + "/" + tenant + "/" + tipoArquivoArmazenado.getPath();
        com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
        try {
            String nameFile = arquivoRelativo.substring(arquivoRelativo.lastIndexOf("/") + 1);
            this.deleteS3(s3, diretorio, nameFile);
            this.deleteS3(s3, diretorio, this.getArquivoImagem(nameFile, TipoImagem.Thumbnail));
            this.deleteS3(s3, diretorio, this.getArquivoImagem(nameFile, TipoImagem.Icone));
            this.deleteS3(s3, diretorio, this.getArquivoImagem(nameFile, TipoImagem.Pequena));
            this.deleteS3(s3, diretorio, this.getArquivoImagem(nameFile, TipoImagem.Grande));
            this.deleteS3(s3, diretorio, this.getArquivoImagem(nameFile, TipoImagem.Icone_Shop));
            this.deleteS3(s3, diretorio, this.getArquivoImagem(nameFile, TipoImagem.Pequena_Shop));
            this.deleteS3(s3, diretorio, this.getArquivoImagem(nameFile, TipoImagem.Icone_Gourmet));
        }
        catch (Exception e) {
            throw new UnicoException("WWW435", "Falhou ao excluir o arquivo", (Throwable)e);
        }
    }

    public List<ArquivoInfoWrapper> getArquivos(String tenant, String tipoArquivo, String diretorio) throws UnicoMensagemUsuarioException {
        TipoArquivoArmazenado tipoArquivoArmazenado = Enum.valueOf(TipoArquivoArmazenado.class, tipoArquivo);
        return this.getArquivos(tenant, tipoArquivoArmazenado, diretorio);
    }

    public List<ArquivoInfoWrapper> getArquivos(String tenant, TipoArquivoArmazenado tipoArquivo, String diretorio) throws UnicoMensagemUsuarioException {
        ArrayList<ArquivoInfoWrapper> arquivos;
        block18: {
            ObjectListing objectListing;
            arquivos = new ArrayList<ArquivoInfoWrapper>();
            if (this.isFileServer() || this.isTabela()) {
                try {
                    this.verificaDiretorio(tenant, tipoArquivo);
                    try (Stream<Path> filesList = Files.list(Paths.get(rootLocation, tenant, tipoArquivo.getPath(), diretorio));){
                        List paths = filesList.collect(Collectors.toList());
                        for (Path path : paths) {
                            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                            LocalDateTime dataCriacaoArquivo = DataHoraFactory.long2LocalDateTime((long)attr.lastModifiedTime().to(TimeUnit.MILLISECONDS));
                            String nome = "";
                            Path pathNome = path.getFileName();
                            if (pathNome != null) {
                                nome = pathNome.toString();
                            }
                            arquivos.add(new ArquivoInfoWrapper(diretorio + path, nome, dataCriacaoArquivo, attr.size()));
                        }
                        break block18;
                    }
                }
                catch (IOException io) {
                    throw new UnicoMensagemUsuarioException("WWW682", "N\u00e3o foi poss\u00edvel carregar os aquivos", (Throwable)io);
                }
            }
            String bucketName = awsBucket + (this.amazonS3Service.isDev() ? "intelidata" : this.unipluswebProperties.getAmbiente().getNome()) + "-temp";
            String prefixo = tenant + "/" + tipoArquivo.getPath() + "/" + diretorio + "/";
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withPrefix(prefixo);
            com.amazonaws.services.s3.AmazonS3 s3 = this.amazonS3Service.getAmazonS3();
            do {
                objectListing = s3.listObjects(listObjectsRequest);
                objectListing.getObjectSummaries().stream().map(sumario -> {
                    String nome = sumario.getKey().replace(prefixo, "");
                    LocalDateTime data = LocalDateTime.ofInstant(sumario.getLastModified().toInstant(), ZoneId.of("UTC"));
                    return new ArquivoInfoWrapper(diretorio + "/" + nome, nome, data, sumario.getSize());
                }).filter(arquivoWrapper -> arquivoWrapper.getTamanho() != 0L).forEach(arquivos::add);
                listObjectsRequest.setMarker(objectListing.getNextMarker());
            } while (objectListing.isTruncated());
        }
        return arquivos;
    }

    public String getServidorURL() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            String url = request.getRequestURL().toString().replace(request.getRequestURI(), "").concat("/");
            if (this.unipluswebProperties.getAmbiente().isLocal() && SystemUtil.isLinux() && this.profile.isProd() && !url.startsWith(Protocol.HTTPS.toString())) {
                url = url.replace(Protocol.HTTP.toString(), Protocol.HTTPS.toString());
            }
            return url;
        }
        return null;
    }

    private void verificaDiretorio(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado) {
        try {
            if (!Files.exists(Paths.get(rootLocation, new String[0]), new LinkOption[0])) {
                Files.createDirectory(Paths.get(rootLocation, new String[0]), new FileAttribute[0]);
            }
            if (!Files.exists(Paths.get(rootLocation, tenant), new LinkOption[0])) {
                Files.createDirectory(Paths.get(rootLocation, tenant), new FileAttribute[0]);
            }
            if (!Files.exists(Paths.get(rootLocation, tenant, tipoArquivoArmazenado.getPath()), new LinkOption[0])) {
                Files.createDirectory(Paths.get(rootLocation, tenant, tipoArquivoArmazenado.getPath()), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new UnicoException("WWW436", "Falhou ao criar o diret\u00f3rio", (Throwable)e);
        }
    }

    private void resizeImage(String arquivo) {
        try {
            BufferedImage image = ImageIO.read(new File(arquivo));
            this.resizeImage(image, arquivo, TipoImagem.Thumbnail);
            this.resizeImage(image, arquivo, TipoImagem.Icone);
            this.resizeImage(image, arquivo, TipoImagem.Pequena);
            this.resizeImage(image, arquivo, TipoImagem.Grande);
            this.resizeImage(image, arquivo, TipoImagem.Icone_Shop);
            this.resizeImage(image, arquivo, TipoImagem.Pequena_Shop);
            this.resizeImage(image, arquivo, TipoImagem.Icone_Gourmet);
        }
        catch (IOException e) {
            throw new UnicoException("WWW437", "Falhou ao fazer o resize da imagem", (Throwable)e);
        }
    }

    public void resizeImage(BufferedImage image, String arquivo, TipoImagem tipoImagem) throws IOException {
        BufferedImage resized = this.resize(image, tipoImagem);
        ImageIO.write((RenderedImage)resized, this.getExtensao(arquivo), new File(this.getArquivoImagem(arquivo, tipoImagem)));
    }

    private void resizeImageS3(com.amazonaws.services.s3.AmazonS3 s3, String diretorio, String arquivo, MultipartFile multipartFile, boolean gzip) throws IOException {
        try (InputStream is = multipartFile.getInputStream();){
            BufferedImage image = ImageIO.read(is);
            this.resizeImageS3(s3, diretorio, arquivo, image, TipoImagem.Thumbnail, gzip);
            this.resizeImageS3(s3, diretorio, arquivo, image, TipoImagem.Icone, gzip);
            this.resizeImageS3(s3, diretorio, arquivo, image, TipoImagem.Pequena, gzip);
            this.resizeImageS3(s3, diretorio, arquivo, image, TipoImagem.Grande, gzip);
            this.resizeImageS3(s3, diretorio, arquivo, image, TipoImagem.Icone_Shop, gzip);
            this.resizeImageS3(s3, diretorio, arquivo, image, TipoImagem.Pequena_Shop, gzip);
            this.resizeImageS3(s3, diretorio, arquivo, image, TipoImagem.Icone_Gourmet, gzip);
        }
    }

    private void resizeImageS3(com.amazonaws.services.s3.AmazonS3 s3, String diretorio, String arquivo, BufferedImage image, TipoImagem tipoImagem, boolean gzip) throws IOException {
        BufferedImage resized = this.resize(image, tipoImagem);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)resized, this.getExtensao(arquivo), baos);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentLength((long)baos.size());
                this.uploadFileS3InMemory(s3, diretorio, this.getArquivoImagem(arquivo, tipoImagem), (InputStream)bais, metadata, gzip);
            }
        }
    }

    private BufferedImage resize(BufferedImage image, TipoImagem tipoImagem) {
        boolean isOpenJdk = System.getProperty("java.vm.name").toLowerCase().contains("open");
        if (isOpenJdk) {
            int w = image.getWidth();
            int h = image.getHeight();
            int type = image.getColorModel().getComponentSize().length > 3 ? 6 : 5;
            BufferedImage newImage = new BufferedImage(w, h, type);
            Graphics2D g = newImage.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
            image = newImage;
        }
        return Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)tipoImagem.getWidth(), (BufferedImageOp[])new BufferedImageOp[0]);
    }

    private String getArquivoImagem(String arquivoOriginal, TipoImagem tipoImagem) {
        int pos = arquivoOriginal.lastIndexOf(46);
        if (pos < 0) {
            return "";
        }
        return arquivoOriginal.substring(0, pos) + tipoImagem.getSufixo() + arquivoOriginal.substring(pos);
    }

    private String getExtensao(String arquivo) {
        int pos = arquivo.lastIndexOf(46);
        return arquivo.substring(pos + 1);
    }

    private void deleteLocal(String arquivoRelativo, TipoImagem tipoImagem) throws IOException {
        Path arquivo;
        String arquivoImagem = this.getArquivoImagem(arquivoRelativo, tipoImagem);
        if (!StringUtil.stringNullOrEmpty((String)arquivoImagem) && Files.exists(arquivo = Paths.get(arquivoImagem, new String[0]), new LinkOption[0])) {
            Files.deleteIfExists(arquivo);
        }
    }

    private void exceptionS3(Exception e) {
        if (e.getCause() instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)e;
            this.log.error("S3 retornou error Error Message: {} HTTP Status Code: {} AWS Error Code: {} Error Type: {} Request ID: {}", new Object[]{ase.getMessage(), ase.getStatusCode(), ase.getErrorCode(), ase.getErrorType(), ase.getRequestId()});
            throw new UnicoException("WWW438", "N\u00e3o foi poss\u00edvel gravar o arquivo no S3");
        }
        if (e.getCause() instanceof AmazonClientException) {
            AmazonClientException ace = (AmazonClientException)e;
            this.log.error("S3 retornou error de comunica\u00e7\u00e3o Error Message", (Throwable)ace);
            throw new UnicoException("WWW439", "N\u00e3o foi poss\u00edvel gravar o arquivo no S3");
        }
        this.log.error("Falhou ao gravar o arquivo", (Throwable)e);
        throw new UnicoException("WWW440", "N\u00e3o foi poss\u00edvel gravar o arquivo no servidor", (Throwable)e);
    }

    private String getDiretorioS3(String tenant, TipoArquivoArmazenado tipoArquivoArmazenado, String caminhoRelativo, boolean temp) {
        String tempBucket;
        String string = tempBucket = temp ? "-temp" : "";
        String diretorio = this.amazonS3Service.isDev() ? "uniplusweb-ambiente-intelidata" + tempBucket + "/" + tenant + "/" + tipoArquivoArmazenado.getPath() + (!StringUtil.stringNullOrEmpty((String)caminhoRelativo) ? "/" + caminhoRelativo : "") : awsBucket + this.unipluswebProperties.getAmbiente().getNome() + tempBucket + "/" + tenant + "/" + tipoArquivoArmazenado.getPath() + (!StringUtil.stringNullOrEmpty((String)caminhoRelativo) ? "/" + caminhoRelativo : "");
        return diretorio;
    }

    private String getShareFolderS3() {
        String folder = this.amazonS3Service.isDev() ? "uniplusweb-ambiente-intelidata-temp/" + TipoArquivoArmazenado.Share.getPath() : awsBucket + this.unipluswebProperties.getAmbiente().getNome() + "-temp/" + TipoArquivoArmazenado.Share.getPath();
        return folder;
    }
}

