/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service.socket;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.NotificacaoUsuario;
import br.intelidata.commons.modulo.cadastros.regranegocio.NotificacaoUsuarioRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notification"})
public class NotificationController {
    @RequestMapping
    @DBAutoCommit
    public List<NotificacaoUsuario> get() {
        return NotificacaoUsuarioRN.getInstance().buscaNotificaoesNaoLidas(SessaoUtil.getSessao().getIdUsuario());
    }

    @RequestMapping(value={"/{id}/mark-as-read"}, method={RequestMethod.PUT})
    @DBTransaction
    public void setAsRead(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        NotificacaoUsuarioRN.getInstance().marcaNotificacaoLida(SessaoUtil.getSessao(), id);
    }

    @RequestMapping(value={"marcar-todas-como-lida"})
    @DBTransaction
    public void marcarTodasLida() throws UnicoMensagemUsuarioException {
        List notificacoes = NotificacaoUsuarioRN.getInstance().buscarNotificacoesNaoLidas();
        for (NotificacaoUsuario notificacao : notificacoes) {
            notificacao.setLida(1);
            notificacao.setDatahoralida(DataHoraFactory.getDataHora());
            NotificacaoUsuarioRN.getInstance().alterar((AbstractPojo)notificacao, SessaoUtil.getSessao());
        }
    }
}

