/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.dashboard.base.scheduler;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Configuracao;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.dashboard.ResumoDashBoard;
import br.intelidata.core.dashboard.base.interfaces.DistribuicaoDashBoard;
import br.intelidata.core.dashboard.base.services.DistribuicoesService;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;

public class ResumoDashBoardScheduler
extends AbstractPrepareScheduler {
    private final NotificationService notificationService = (NotificationService)BeanUtil.getBean((String)"notificationService");
    private final Map<String, DistribuicaoDashBoard> distribuicoes;

    public ResumoDashBoardScheduler() {
        super("Atualizador de Dashboards", Cron.dailyMinute((int)51), TipoJob.RESUMOS_DASHBOARD);
        DistribuicoesService distribuicoesService = (DistribuicoesService)BeanUtil.getBean((String)"distribuicoesService");
        this.distribuicoes = distribuicoesService.getDistribuicoes();
    }

    public void execute() throws Exception {
        Sessao sessao = SessaoUtil.getSessao();
        new ResumoDashBoard(this.distribuicoes).gerar(sessao, () -> this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, ""));
        List filiais = FilialRN.getInstance().getFiliais();
        for (Filial filial : filiais) {
            Configuracao confUltimaExecucao = ConfiguracaoCommonRN.getInstance().buscarPorChave(2000001, filial.getId());
            if (confUltimaExecucao == null) {
                confUltimaExecucao = new Configuracao();
                confUltimaExecucao.setChave(2000001);
            }
            confUltimaExecucao.setValor(DateUtil.formataDataHora((Temporal)DataHoraFactory.getDataHora(), (String)"yyyy-MM-dd HH:mm"));
            confUltimaExecucao.setIdFilial(filial.getId());
            ConfiguracaoCommonRN.getInstance().gravar(NumberUtil.longNullOuZero((Long)confUltimaExecucao.getId()) ? 0 : 1, (AbstractPojo)confUltimaExecucao, sessao);
        }
    }

    public void onFailure(Exception ex) {
    }

    public boolean isAtivo() {
        return true;
    }
}

