/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public abstract class BaseController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    private String minifyHTML(String html) {
        HtmlCompressor htmlCompressor = new HtmlCompressor();
        String compressedHtml = htmlCompressor.compress(html);
        return compressedHtml;
    }

    private String minifyJS(String javascript) {
        HtmlCompressor compressor = new HtmlCompressor();
        String compressedJavascript = compressor.compress(javascript);
        return compressedJavascript;
    }

    protected ResponseEntity<String> createHtmlResponse(String html) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_HTML);
        html = this.minifyHTML(html);
        return new ResponseEntity((Object)html, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    protected ResponseEntity<byte[]> createHtmlResponse(byte[] html) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_HTML);
        return new ResponseEntity((Object)html, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    protected ResponseEntity<String> createJSONResponse(String json) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        return new ResponseEntity((Object)json, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    protected ResponseEntity<byte[]> createJavascriptResponse(String javascript) throws UnicoMensagemUsuarioException {
        try {
            javascript = this.minifyJS(javascript);
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentType(MediaType.parseMediaType((String)"text/javascript; charset=UTF-8"));
            if (javascript.length() > 2048) {
                // empty if block
            }
            return new ResponseEntity((Object)javascript.getBytes("UTF-8"), (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW20", "N\u00e3o foi poss\u00edvel gravar o arquivo no servidor");
        }
    }

    protected ResponseEntity<byte[]> createPDFResponse(byte[] pdf) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        return new ResponseEntity((Object)pdf, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    protected ResponseEntity<byte[]> createXLSResponse(byte[] xls) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)"application/vnd.ms-excel"));
        return new ResponseEntity((Object)xls, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    protected ResponseEntity<byte[]> createTXTResponse(byte[] txt) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)txt, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }
}

