/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.crud;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.service.MDCConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"dev", "prod", "aws"})
@RestController
public class ClearCache {
    private final Logger log = LoggerFactory.getLogger(ClearCache.class);
    private final CacheService cacheService;
    private final MDCConfigService mdcConfigService;
    private final TenantService tenantService;

    @Autowired
    public ClearCache(CacheService cacheService, MDCConfigService mdcConfigService, TenantService tenantService) {
        this.cacheService = cacheService;
        this.mdcConfigService = mdcConfigService;
        this.tenantService = tenantService;
    }

    @RequestMapping(value={"/clearCache/{tenant}"})
    public ResponseEntity<String> clear(@PathVariable String tenant) {
        this.mdcConfigService.confiMDC(tenant);
        ContextoHolder.setTenant((String)tenant, (String)this.tenantService.getDatabase(tenant));
        this.log.info("Clear cache");
        this.cacheService.clear();
        this.log.info("Cache cleaned successfully!");
        return ResponseEntity.ok((Object)"Cache cleaned successfully!");
    }
}

