/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.crud;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.UnicoCrypt;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobEmailTask;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.activation.DataSource;

public class CreateTaskEmail
implements ICreateTask {
    public final TaskManager taskManager;
    public final ParametrosEmailWeb parametrosEmail;
    public final String descricao;

    public CreateTaskEmail(TaskManager taskManager, ParametrosEmailWeb parametrosEmail, String descricao) {
        this.taskManager = taskManager;
        this.parametrosEmail = parametrosEmail;
        this.descricao = descricao;
    }

    public CreateTaskEmail(TaskManager taskManager, ParametrosEmailWeb parametrosEmail) {
        this(taskManager, parametrosEmail, "");
    }

    public TypeQueue getQueue() {
        return TypeQueue.EMAIL_QUEUE;
    }

    public TipoJob getTipoJob() {
        return TipoJob.EMAIL;
    }

    public Class<? extends AbstractJob> job() {
        return JobEmailTask.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void getOutPut(Task task) throws UnicoMensagemUsuarioException {
        this.criptografaSenha(task);
        if (this.parametrosEmail.getAnexos() != null) {
            byte[] arquivo = FileUtil.montaZipFile((DataSource[])this.parametrosEmail.getAnexos());
            StorageService storageService = (StorageService)BeanUtil.getBean((String)"storageService");
            try {
                File file = File.createTempFile("Anexos_email", ".zip");
                file.deleteOnExit();
                try (FileOutputStream fileoutputstream = new FileOutputStream(file);){
                    fileoutputstream.write(arquivo);
                }
                task.setUrl(storageService.saveFile(task.getTenant(), TipoArquivoArmazenado.JobExecutor, file, false, null, true));
            }
            catch (IOException ex) {
                throw new UnicoMensagemUsuarioException("BATCH11", "N\u00e3o foi poss\u00edvel criar os arquivos tempor\u00e1rios para anexo.");
            }
        }
    }

    private void criptografaSenha(Task task) {
        ParametrosEmailWeb p = (ParametrosEmailWeb)JsonUtil.fromJson((String)task.getParameters(), ParametrosEmailWeb.class);
        if (p != null) {
            p.setSenhaServidorSmtp(UnicoCrypt.cript((String)p.getSenhaServidorSmtp()));
        }
        task.setParameters(JsonUtil.toJson((Object)p));
    }
}

