/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.crud;

import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TabelaRelatorioConfigurado
implements Serializable {
    private String codigo;
    private String descricao;
    private String tabelaOriginal;
    private TipoDadoBase tipoDado;
    private String listaValores;
    private int decimal = 0;
    private boolean virtual;
    private TabelaRelatorioConfigurado pai;
    private List<TabelaRelatorioConfigurado> relacionamentos;

    public TabelaRelatorioConfigurado() {
    }

    public TabelaRelatorioConfigurado(String codigo, String descricao, String tabelaOriginal) {
        this.codigo = codigo;
        this.descricao = descricao;
        this.tabelaOriginal = tabelaOriginal;
    }

    public TabelaRelatorioConfigurado(String codigo, String descricao, String tabelaOriginal, List<TabelaRelatorioConfigurado> relacionamentos) {
        this.codigo = codigo;
        this.descricao = descricao;
        this.tabelaOriginal = tabelaOriginal;
        this.relacionamentos = relacionamentos;
    }

    public TabelaRelatorioConfigurado(Coluna coluna, String descricaoCustomizada) {
        this.descricao = !StringUtil.stringNullOrEmpty((String)descricaoCustomizada) ? descricaoCustomizada : coluna.getDescricaoGrid();
        this.tipoDado = coluna.getTipoDado();
        if (coluna.getClasseEnum() != null) {
            this.listaValores = JsonUtil.enumConstantsToJson((Class)coluna.getClasseEnum(), (boolean)false);
        }
        this.codigo = coluna.getNome();
        this.decimal = coluna.getDecimal();
        this.virtual = coluna.isVirtual();
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getTabelaOriginal() {
        return this.tabelaOriginal;
    }

    public TipoDadoBase getTipoDado() {
        return this.tipoDado;
    }

    public String getListaValores() {
        return this.listaValores;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public List<TabelaRelatorioConfigurado> getRelacionamentos() {
        return this.relacionamentos;
    }

    public void setRelacionamentos(List<TabelaRelatorioConfigurado> relacionamentos) {
        this.relacionamentos = relacionamentos;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public TabelaRelatorioConfigurado getPai() {
        return this.pai;
    }

    public void setPai(TabelaRelatorioConfigurado pai) {
        this.pai = pai;
    }

    public void addRelacionamento(TabelaRelatorioConfigurado configuracaoRelatorio) {
        if (this.relacionamentos == null) {
            this.relacionamentos = new ArrayList();
        }
        this.getRelacionamentos().add(configuracaoRelatorio);
    }

    public void sort() {
        if (ListMapUtil.listNullOrEmpty((List)this.getRelacionamentos())) {
            return;
        }
        this.getRelacionamentos().sort(Comparator.comparing(TabelaRelatorioConfigurado::getDescricao));
    }
}

