/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.fileupload;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.uniplusweb.web.rest.BaseController;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

public abstract class FileUploadController
extends BaseController {
    private static final Regions REGION_S3 = Regions.SA_EAST_1;
    private static final String awsId = "AKIAJDBPLASPGOID6DWQ";
    private static final String awsSecret = "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";

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<String> upload(MultipartFile file) throws UnicoMensagemUsuarioException {
        InputStream is = null;
        this.beforeSending(file);
        try {
            String bucket = "uniplusweb/" + ContextoHolder.getTenant();
            is = file.getInputStream();
            String url = this.enviaParaS3(REGION_S3, bucket, System.currentTimeMillis() + " - " + file.getOriginalFilename(), is);
            ResponseEntity responseEntity = this.createJSONResponse("{\"url\":\"" + url + "\"}");
            return responseEntity;
        }
        catch (Exception e) {
            throw new UnicoMensagemUsuarioException("WWW458", "N\u00e3o foi poss\u00edvel gravar o arquivo no servidor");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new UnicoMensagemUsuarioException("WWW19", "N\u00e3o foi poss\u00edvel gravar o arquivo no servidor");
                }
            }
        }
    }

    protected abstract String getFolder();

    protected void beforeSending(MultipartFile file) {
    }

    private String enviaParaS3(Regions region, String bucket, String key, InputStream inputStream) {
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(awsId, awsSecret);
        AmazonS3Client s3 = new AmazonS3Client((AWSCredentials)awsCreds);
        s3.setRegion(Region.getRegion((Regions)region));
        s3.putObject(new PutObjectRequest(bucket + this.getFolder(), key, inputStream, null).withCannedAcl(CannedAccessControlList.PublicRead));
        String url = "https://s3-" + region.getName() + ".amazonaws.com/" + bucket + this.getFolder() + "/" + key;
        return url;
    }
}

