/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.report;

import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReport;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReportParams;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import java.io.File;

public abstract class AbstractReporteExecute<E extends AbstractReport>
extends AbstractPrepareJob {
    public boolean download;

    public AbstractReporteExecute(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public abstract Remessa deserialize(Sessao var1, String var2) throws UnicoMensagemUsuarioException;

    public abstract Remessa executa(Sessao var1, E var2) throws UnicoMensagemUsuarioException;

    protected E fromJson(String json, Class<E> clazz) {
        AbstractReport objeto = (AbstractReport)JsonUtil.fromJson((String)json, clazz);
        if (objeto == null) {
            throw new UnicoException("WWW637", "N\u00e3o foi poss\u00edvel deserializar o objeto.");
        }
        return (E)objeto;
    }

    public void execute() throws Exception {
        AbstractReportParams abstractReportParams = (AbstractReportParams)this.getObjetoDeserializado(AbstractReportParams.class);
        String formato = abstractReportParams.getSaidaRelatorio().getFormato();
        Remessa remessa = this.deserialize(this.getSessao(), this.getParameters());
        Object obj = remessa.getMalote().getMapArquivos().get(formato);
        File file = null;
        if (obj instanceof File) {
            file = (File)obj;
        } else if (obj instanceof byte[]) {
            file = new File(StringUtil.removerAcentos((String)this.getTask().getName()).replace(" ", "_") + this.getExtensao(remessa.getMalote()));
            Util.byteArray2File((byte[])((byte[])obj), (File)file);
        }
        this.saveFile(file);
        this.download = !abstractReportParams.getOpcaoSaidaRelatorio().equals("NOVA_GUIA");
    }

    public void notificar(boolean sucesso) {
        Notificacao notificacao;
        NotificationService notificationService = (NotificationService)BeanUtil.getBean((String)"notificationService");
        TipoNotificacaoSimples tipoNotificacao = null;
        if (sucesso) {
            notificacao = this.getNotificacaoSucesso(this.getTask());
            if (notificacao != null) {
                tipoNotificacao = notificacao.getTipoNotificacao() == null ? TipoNotificacaoSimples.SUCCESS : notificacao.getTipoNotificacao();
            }
        } else {
            notificacao = this.getNotificacaoErro(this.getTask());
            if (notificacao != null) {
                TipoNotificacaoSimples tipoNotificacaoSimples = tipoNotificacao = notificacao.getTipoNotificacao() == null ? TipoNotificacaoSimples.ERROR : notificacao.getTipoNotificacao();
            }
        }
        if (notificacao != null) {
            notificationService.notifyUserTask(this.getSessao().getIdUsuario(), notificacao.getMsg(), tipoNotificacao, this.getTask(), this.download);
        }
    }

    public void onFailure(Exception ex) {
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao(task.getName() + "<br>Seu relat\u00f3rio esta pronto! Entre no Gerenciador de tarefas para abrir");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        String msg = "Ocorreu um problema ao executar o " + task.getName();
        if (task.getExcecao() != null && task.getExcecao() instanceof UnicoMensagemUsuarioException) {
            msg = ((UnicoMensagemUsuarioException)((Object)task.getExcecao())).getMensagemSemCodigoDeErro();
        }
        return new Notificacao(TipoNotificacaoSimples.ERROR, msg);
    }

    private String getExtensao(Malote malote) {
        if (malote.contem("html")) {
            return ".html";
        }
        if (malote.contem("text")) {
            return ".txt";
        }
        if (malote.contem("excel")) {
            return ".xls";
        }
        return ".pdf";
    }

    public boolean abstractControlTransaction() {
        return false;
    }
}

