/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.ConfiguracaoScanntech;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoScanntechCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.pdv.promocaoscanntech.download.CargaPromocoesScanntech;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanntechPromocaoWebScheduler
extends AbstractPrepareScheduler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FuncionalidadeService funcionalidadeService = (FuncionalidadeService)BeanUtil.getBean((String)"funcionalidadeService");

    public ScanntechPromocaoWebScheduler() {
        super("Scanntech (Carga de Promo\u00e7\u00f5es)", Cron.everyXminutes((int)45), TipoJob.SCANNTECH_CARGA_PROMOCAO_WEB);
    }

    public void execute() throws Exception {
        ConfiguracaoScanntech configuracao = ConfiguracaoScanntechCommonRN.getInstance().buscar(true);
        if (configuracao != null && ConfiguracaoScanntechCommonRN.getInstance().podeFazerCarga(configuracao)) {
            Sessao sessao = SessaoUtil.getSessaoSistema();
            this.log.info("Scanntech (Carga de Promo\u00e7\u00f5es) do tenant: " + this.getTask().getTenant());
            List filiais = FilialRN.getInstance().getFiliaisAtivaScantech();
            new CargaPromocoesScanntech(sessao, configuracao, filiais).fazerCarga();
            this.log.info("Scanntech (Carga de Promo\u00e7\u00f5es) completada para o tenant: " + this.getTask().getTenant());
        }
    }

    public void onFailure(Exception ex) {
    }

    public boolean isAtivo() {
        return this.funcionalidadeService.isAtiva(Funcionalidade.SCANNTECH);
    }

    public boolean abstractControlTransaction() {
        return false;
    }
}

