/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.b2c.SessaoWebDTO;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.b2c.SessaoWebRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import java.util.List;

public class SessaoExpiradaScheduler
extends AbstractPrepareScheduler {
    private final NotificationService notificationService = (NotificationService)BeanUtil.getBean((String)"notificationService");

    public SessaoExpiradaScheduler() {
        super("Remover as sess\u00f5es web expiradas", Cron.daily((int)1), TipoJob.SESSAO_EXPIRADA);
    }

    public void execute() throws Exception {
        List sessoes = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessaoSistema().getFilial(), 1054) ? SessaoWebRN.getInstance().buscarTodasSessoes() : SessaoWebRN.getInstance().buscarTodasSessoesAntigas();
        for (SessaoWebDTO sessao : sessoes) {
            SessaoWebDTO sessaoWebDTO = SessaoWebRN.getInstance().buscaSessaoWebDTO(sessao.getJti());
            SessaoWebRN.getInstance().apagaSessaoWeb(sessao.getJti());
            String mensagem = "Voc\u00ea foi desconectado por " + SessaoUtil.getSessao().getUsuario().getNome() + ". Considere aumentar o n\u00famero de usu\u00e1rios contratados.";
            this.notificationService.notifyTokenNow(ContextoHolder.getTenant(), sessaoWebDTO.getJti(), NotificationType.ENCERRAR_SESSAO, (Object)mensagem);
            this.log.info("A sua sess\u00e3o foi deslogada pelo processo 'Remover as sess\u00f5es web expiradas'");
        }
    }

    public void onFailure(Exception ex) {
    }

    public boolean isAtivo() {
        return true;
    }
}

