/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.service;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.Controle;
import br.intelidata.commons.domain.pojo.importacao.ImportacaoArquivo;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.modulo.c3po.ecommerce.regranegocio.geral.ListenerLog;
import br.intelidata.commons.tools.recursos.ArquivoRecursoExterno;
import br.intelidata.commons.tools.recursos.RecursoExternoManager;
import br.intelidata.commons.tools.recursos.RecursoExternoRetorno;
import br.intelidata.commons.tools.regranegocio.ImportacaoArquivoRN;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.web.rest.app.crud.recursoexterno.ParamsRecursoExterno;
import org.json.JSONObject;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class RecusrosExternosService {
    ConnectionOAuth2Service connectionOAuth2Service;

    public RecusrosExternosService(ConnectionOAuth2Service connectionOAuth2Service) {
        this.connectionOAuth2Service = connectionOAuth2Service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void atualizarRecursos(String parametros, ListenerLog log) throws UnicoMensagemUsuarioException {
        ParamsRecursoExterno params = null;
        if (!StringUtil.stringNullOrEmpty((String)parametros)) {
            params = (ParamsRecursoExterno)JsonUtil.fromJson((String)parametros, ParamsRecursoExterno.class);
        }
        Sessao sessao = SessaoUtil.getSessao();
        ResponseEntity response = this.connectionOAuth2Service.execute("/api/", "recursosexternos", new JSONObject(), RecursoExternoRetorno.class, HttpMethod.GET, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK && response.getBody() != null) {
            RecursoExternoRetorno recursoExternoRetorno = (RecursoExternoRetorno)response.getBody();
            if (params != null && params.getId() != null) {
                ImportacaoArquivo importacaoArquivo = (ImportacaoArquivo)ImportacaoArquivoRN.getInstance().buscarPorId(params.getId());
                ArquivoRecursoExterno arquivoRecursoExterno = recursoExternoRetorno.getArquivos().stream().filter(arquivo -> arquivo.getTipo().equals(importacaoArquivo.getArquivo().getId())).findFirst().orElse(null);
                if (arquivoRecursoExterno == null) return;
                RecursoExternoManager.getInstance().atualizarRecurso(sessao, arquivoRecursoExterno, importacaoArquivo.getArquivo(), importacaoArquivo, null);
                return;
            }
            boolean isAtualizarRecursosExternos = RecursoExternoManager.getInstance().isAtualizarRecursosExternos(recursoExternoRetorno, true);
            if (isAtualizarRecursosExternos) {
                boolean isAtualizandoRecursos;
                Controle controle = ControleRN.getInstance().getRegistroControle();
                boolean bl = isAtualizandoRecursos = controle != null && controle.isAtualizandoRecursosExternos();
                if (isAtualizandoRecursos) {
                    log.error("Os recursos externos est\u00e3o sendo atualizados.");
                    return;
                }
                try {
                    RecursoExternoManager.getInstance().atualizarRecursosExternos(sessao, recursoExternoRetorno, null);
                    return;
                }
                finally {
                    try {
                        ControleRN.getInstance().atualizandoRecursosExternos(Contexto.getInstance().getSessao(), false);
                    }
                    catch (Throwable ex) {
                        log.info("Falhou ao atualizar a tabela controle.");
                    }
                }
            }
            log.info("Nenhum arquivo foi atualizado. Todos j\u00e1 est\u00e3o na \u00faltima vers\u00e3o dispon\u00edvel.");
            return;
        }
        log.error("N\u00e3o foi poss\u00edvel importar os recursos externos");
    }
}

