/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.thread;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.domain.pojo.JobExecutor;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.cadastros.regranegocio.JobExecutorRN;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.SystemUtil;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Job;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobPersistent;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobTask;
import br.intelidata.uniplusweb.web.rest.app.client.thread.PriorityThreadPoolExecutor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobExecutorService {
    private PriorityThreadPoolExecutor executor;
    private Map<TipoJob, List<Long>> jobs;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public JobExecutorService(@Autowired UnipluswebProperties unipluswebProperties) {
        int corePoolSize = unipluswebProperties.getJobExecutor().getCorePoolSize();
        int maxPoolSize = unipluswebProperties.getJobExecutor().getMaxPoolSize();
        int keepAliveSeconds = unipluswebProperties.getJobExecutor().getKeepAliveSeconds();
        int queueCapacity = unipluswebProperties.getJobExecutor().getQueueCapacity();
        LoggerFactory.getLogger(this.getClass()).info("Iniciando JobExecutorService: {} Core Pool Size, {} Max Pool Size, {} Keep Alive Seconds, {} Queue capacity", new Object[]{corePoolSize, maxPoolSize, keepAliveSeconds, queueCapacity});
        this.executor = PriorityThreadPoolExecutor.newPriorityThreadPoolExecutor((int)corePoolSize, (int)maxPoolSize, (int)keepAliveSeconds, (int)queueCapacity);
        this.jobs = new HashMap();
    }

    public void execute(TipoJob tipoJob) {
        this.execute(tipoJob, true);
    }

    public void execute(TipoJob tipoJob, boolean validar) {
        List idsJobs = this.jobs.getOrDefault(tipoJob, new ArrayList());
        if (ListMapUtil.listNullOrEmpty((List)idsJobs) && validar) {
            throw new UnicoException("WWW360", "Lista de jobs n\u00e3o informada. Verifique!");
        }
        idsJobs.forEach(id -> {
            SystemUtil.espera((int)5000);
            this.execute(id);
        });
        this.clear(tipoJob);
    }

    public void execute(Long jobId) {
        this.execute((JobExecutor)JobExecutorRN.getInstance().buscarPorId(jobId), ContextoHolder.getTenant());
    }

    public void execute(JobExecutor jobExecutor, String tenant) {
        try {
            Class<?> classe = Class.forName(jobExecutor.getTipoJob().getClasseImplementacao());
            Method metodo = classe.getMethod("recreate", JobExecutor.class, String.class);
            JobPersistent jobPersistent = (JobPersistent)metodo.invoke(null, jobExecutor, tenant);
            this.executor.execute((Runnable)jobPersistent, jobExecutor.getTipoJob().getPrioridade().intValue());
        }
        catch (Exception e) {
            this.log.error("Falhou ao executar job", (Throwable)e);
        }
    }

    public void executeSemJobPersistent(Job job, TipoJob tipoJob) {
        this.executor.execute((Runnable)job, tipoJob.getPrioridade().intValue());
    }

    public void executeJobTask(JobTask job, TipoJob tipoJob) {
        this.executor.execute((Runnable)job, tipoJob.getPrioridade().intValue());
    }

    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    public void clear(TipoJob tipoJob) {
        this.jobs.remove(tipoJob);
    }

    public void addJob(TipoJob tipoJob, Long id) {
        if (NumberUtil.longNullOuZero((Long)id)) {
            throw new UnicoException("WWW359", "Id do job n\u00e3o informado.");
        }
        List ids = this.jobs.getOrDefault(tipoJob, new ArrayList());
        ids.add(id);
        this.jobs.putIfAbsent(tipoJob, ids);
    }
}

