/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.thread;

import br.intelidata.api.batch.AbstractTaskManager;
import br.intelidata.api.batch.AbstractTaskProcessor;
import br.intelidata.api.batch.ITask;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.service.monitor.MonitorService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.batch.serices.TaskService;
import javax.annotation.PostConstruct;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TaskProcessor
extends AbstractTaskProcessor {
    private final MonitorService monitorService;

    public TaskProcessor(TaskManager taskManager, TaskService taskService, UnipluswebProperties unipluswebProperties, MonitorService monitorService) {
        super((AbstractTaskManager)taskManager, (ITask)taskService);
        this.threads = unipluswebProperties.getBatch().getThreads();
        this.cpuMaxLimit = unipluswebProperties.getBatch().getCpuMaxLimit();
        this.monitorService = monitorService;
        LoggerFactory.getLogger(this.getClass()).info("Iniciando Task processor: {} Threads Size, {} Cpu max, {} Polling", new Object[]{this.threads, this.cpuMaxLimit, unipluswebProperties.getBatch().getPolling()});
    }

    @PostConstruct
    public void postConstruct() {
        super.postConstruct();
    }

    @Scheduled(fixedDelayString="${uniplusweb.batch.polling:5000}")
    public void pop() {
        super.pop();
    }

    @Scheduled(fixedRate=2000L)
    public void monitorCpu() {
        this.monitorService.monitorarCpu(this.threads, this.threadPoolExecutor.getActiveCount(), this.startUp);
    }
}

