/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ajusteapuracaoicms;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoImpostoAjusteApuracao;
import br.intelidata.commons.domain.pojo.enuns.UtilizacaoAjusteApuracao;
import br.intelidata.commons.domain.pojo.fiscal.AjusteApuracaoIcms;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.sped.regranegocio.AjusteApuracaoIcmsRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ajustes-apuracao-icms"})
@SubMenuMapping(MENU="SubMenuPainelContadorParametrosAuxiliarSpedFiscal", NOME="Ajustes na apura\u00e7\u00e3o do ICMS", ROTA="/speds/ajustes-apuracao-icms", PROGRAMA=1424)
public class AjusteApuracaoIcmsCrudController
extends CrudController<AjusteApuracaoIcms, AjusteApuracaoIcmsRN> {
    public AjusteApuracaoIcmsCrudController() {
        super((AbstractRegraNegocio)AjusteApuracaoIcmsRN.getInstance(), AjusteApuracaoIcms::new);
    }

    protected void beforeSave(AjusteApuracaoIcms ajusteApuracaoIcms, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (ajusteApuracaoIcms.getCodigo().length() != 8) {
            throw new UnicoMensagemUsuarioException("WWW7", "O c\u00f3digo deve ter 8 caracteres!");
        }
        String strTipoApuracao = ajusteApuracaoIcms.getCodigo().substring(2, 3);
        TipoImpostoAjusteApuracao tipoImposto = (TipoImpostoAjusteApuracao)EnumUtils.getPorId(TipoImpostoAjusteApuracao.class, (Object)strTipoApuracao);
        if (tipoImposto == null) {
            throw new UnicoMensagemUsuarioException("WWW8", "Terceira posi\u00e7\u00e3o n\u00e3o \u00e9 v\u00e1lida o valor [" + strTipoApuracao + "]!");
        }
        String strUtilizacaoApuracao = ajusteApuracaoIcms.getCodigo().substring(3, 4);
        UtilizacaoAjusteApuracao utilizacaoApuracao = (UtilizacaoAjusteApuracao)EnumUtils.getPorId(UtilizacaoAjusteApuracao.class, (Object)strUtilizacaoApuracao);
        if (utilizacaoApuracao == null) {
            throw new UnicoMensagemUsuarioException("WWW9", "Quarta posi\u00e7\u00e3o n\u00e3o \u00e9 v\u00e1lida o valor [" + strUtilizacaoApuracao + "]!");
        }
    }

    protected GridBuilder<AjusteApuracaoIcmsRN> getGridBuilder() {
        return new GridBuilder(AjusteApuracaoIcmsRN.getInstance().getTabela(), Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("codigo", "C\u00f3digo", 0, true), new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true)));
    }

    protected String getCacheId() {
        return "ajustes-apuracao-icms";
    }
}

