/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.aliquotaestado;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.AliquotaEstado;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.AliquotaEstadoCommonRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aliquotas-estado"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Aliquotas por estado", ROTA="/notas-fiscais/aliquotas-estado", PROGRAMA=1000034)
public class AliquotaEstadoCrudController
extends CrudController<AliquotaEstado, AliquotaEstadoCommonRN> {
    public AliquotaEstadoCrudController() {
        super((AbstractRegraNegocio)AliquotaEstadoCommonRN.getInstance(), AliquotaEstado::new);
    }

    protected GridBuilder<AliquotaEstadoCommonRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("tipoAliquota", "Tipo", 0, true));
        colunas.add(new ColunaSQL("nome", "nomeEstado", "Estado", 0, true, new String[]{"fk_aliqest_estado"}));
        colunas.add(new ColunaSQL("aliquota", "Al\u00edquota", 0, true));
        GridBuilder grid = new GridBuilder(AliquotaEstadoCommonRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("tipoAliquota"));
        grid.setOrdemDefault(new Ordem("nomeEstado"));
        grid.setOrdemDefault(new Ordem("aliquota"));
        return grid;
    }

    protected void beforeSave(AliquotaEstado aliquotaEstado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.bigDecimalNullOrZero((BigDecimal)aliquotaEstado.getAliquota())) {
            throw new UnicoMensagemUsuarioException("NTF8980", "A al\u00edquota deve ser maior que zero.");
        }
    }

    protected String getCacheId() {
        return "aliquotas-estado";
    }
}

