/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.banco;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.financeiro.regranegocio.BancoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bancos"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Bancos", ROTA="/financeiros/bancos", PROGRAMA=74)
public class BancoCrudController
extends CrudController<Banco, BancoRN> {
    public BancoCrudController() {
        super((AbstractRegraNegocio)BancoRN.getInstance(), Banco::new);
    }

    @RequestMapping(value={"/bancos-financeiro"})
    @DBAutoCommit
    public List<Banco> getCombo(@RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="6") int limit) {
        return BancoRN.getInstance().getSelectAutocompleteWeb(query, limit);
    }

    protected GridBuilder<BancoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        return new GridBuilder(BancoRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "bancos";
    }
}

