/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.bandeira;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.pafecf.BandeiraCartao;
import br.intelidata.commons.domain.pojo.pafecf.BandeiraCartaoIdentificador;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.pdv.regranegocio.BandeiraCartaoIdentificadorRN;
import br.intelidata.commons.modulo.pdv.regranegocio.BandeiraCartaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bandeiras-cartoes"})
public class BandeiraCartaoCrudController
extends CrudController<BandeiraCartao, BandeiraCartaoRN> {
    public BandeiraCartaoCrudController() {
        super((AbstractRegraNegocio)BandeiraCartaoRN.getInstance(), BandeiraCartao::new);
    }

    @RequestMapping(value={"/validar-codigo-descricao"})
    @DBAutoCommit
    public boolean validaCodigo(@RequestParam String codigo, @RequestParam String campo, @RequestParam(required=false) Long id) throws UnicoMensagemUsuarioException {
        if (campo.equalsIgnoreCase("codigo")) {
            this.validarCodigoBandeira(codigo, id);
        } else if (campo.equalsIgnoreCase("nome")) {
            this.validarNomeBandeira(codigo, id);
        }
        return true;
    }

    @RequestMapping(value={"/buscar-identificadores"})
    @DBAutoCommit
    public List<BandeiraCartaoIdentificador> buscarListaIdentificador(@RequestParam Long idBandeira) {
        return BandeiraCartaoIdentificadorRN.getInstance().buscarPorBandeira(idBandeira);
    }

    @RequestMapping(value={"/gravar-identificadores"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravarListaIdentificador(@RequestBody List<BandeiraCartaoIdentificador> identificadores, @RequestParam Long idBandeira) throws UnicoMensagemUsuarioException {
        BandeiraCartaoIdentificadorRN.getInstance().gravarList(idBandeira, identificadores, SessaoUtil.getSessao());
    }

    protected GridBuilder<BandeiraCartaoRN> getGridBuilder() {
        List<ColunaSQL> colunas = Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("nome", "Nome", 0, true), new ColunaSQL("inativo", "Inativo", 0, false));
        return new GridBuilder(BandeiraCartaoRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "bandeiras-cartoes";
    }

    protected void afterSave(BandeiraCartao bandeiraCartao, Optional<Long> parentId) {
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, "bandeiras-relacionadas");
    }

    private void validarCodigoBandeira(String codigo, Long id) throws UnicoMensagemUsuarioException {
        BandeiraCartao bandeira = (BandeiraCartao)BandeiraCartaoRN.getInstance().buscarPorCodigo(codigo);
        if (bandeira != null && !bandeira.getId().equals(id)) {
            throw new UnicoMensagemUsuarioException("PDV554", "J\u00e1 existe uma bandeira cadastrada com o c\u00f3digo " + codigo);
        }
    }

    private void validarNomeBandeira(String nome, Long id) throws UnicoMensagemUsuarioException {
        BandeiraCartao bandeira = BandeiraCartaoRN.getInstance().getByNome(nome.toUpperCase());
        if (bandeira != null && !bandeira.getId().equals(id)) {
            throw new UnicoMensagemUsuarioException("WPDV274", "J\u00e1 existe uma bandeira cadastrada com o nome " + nome);
        }
    }

    @RequestMapping(value={"/lista-completa"})
    @DBAutoCommit
    public List<BandeiraCartao> comboListaCompleta() {
        return BandeiraCartaoRN.getInstance().buscarLista();
    }
}

