/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.certificado;

import br.intelidata.commons.core.documentosfiscais.common.enums.TipoCertificado;
import br.intelidata.commons.core.documentosfiscais.common.pojo.DadosCertificado;
import br.intelidata.commons.core.documentosfiscais.util.DadosCertificadoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.UnicoCrypt;
import br.intelidata.commons.domain.pojo.Certificado;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.CertificadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.certificado.CertificadoWrapper;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/certificados"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Certificados digitais", ICONE="icon-config", ROTA="/ferramentas/certificados", PROGRAMA=1443)
public class CertificadoCrudController
extends CrudController<Certificado, CertificadoRN> {
    public CertificadoCrudController() {
        super((AbstractRegraNegocio)CertificadoRN.getInstance(), Certificado::new);
    }

    @RequestMapping(value={"/carregar-certificado"}, method={RequestMethod.POST})
    public CertificadoWrapper carregarCertificado(@RequestPart(value="file") MultipartFile file, @RequestPart(value="wrapper") CertificadoWrapper wrapper) throws UnicoMensagemUsuarioException {
        try {
            return this.carregarDadosCertificado(file.getBytes(), wrapper.getTipoCertificado(), wrapper.getSenha(), null);
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW442", "N\u00e3o foi poss\u00edvel carregar o certificado.");
        }
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<Certificado> getCombo() {
        return CertificadoRN.getInstance().getComboWeb();
    }

    protected void beforeRead(Certificado certificado, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!TipoCertificado.A1.equals((Object)certificado.getTipoCertificado())) {
            throw new UnicoMensagemUsuarioException("COM23669756", "N\u00e3o foi poss\u00edvel selecionar um certificado com o tipo 'Reposit\u00f3rio do Windows', Selecione outro certificado");
        }
        certificado.setSenha(UnicoCrypt.decript((String)certificado.getSenha()));
        CertificadoWrapper wrapper = this.carregarDadosCertificado(certificado.getBinario(), certificado.getTipoCertificado(), certificado.getSenha(), certificado.getAlias());
        certificado.setAlias(wrapper.getAlias());
        certificado.setDetalhes(wrapper.getDetalhes());
        certificado.setBinario(null);
    }

    protected void beforeSave(Certificado certificado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (StringUtil.stringNullOrEmpty((String)certificado.getAlias())) {
            throw new UnicoMensagemUsuarioException("WCAD43", "N\u00e3o foi poss\u00edvel ler o 'Alias' do certificado.");
        }
        if (!NumberUtil.longNullOuZero((Long)certificado.getId()) && certificado.getBinario() == null) {
            certificado.setBinario(((Certificado)CertificadoRN.getInstance().buscarPorId(certificado.getId())).getBinario());
        }
        if (certificado.getTipo().in(new AbstractEnum[]{TipoCertificado.A1, TipoCertificado.A3})) {
            if (StringUtil.stringNullOrEmpty((String)certificado.getSenha())) {
                throw new UnicoMensagemUsuarioException("WCAD55", "Informe a senha.");
            }
            if (certificado.getTipo().equals((Object)TipoCertificado.A3)) {
                if (StringUtil.stringNullOrEmpty((String)certificado.getDiretorioDLL())) {
                    throw new UnicoMensagemUsuarioException("WCAD56", "Informe a caminho para a DDL do certificado A3.");
                }
            } else if (certificado.getBinario() == null && NumberUtil.longNullOuZero((Long)certificado.getId())) {
                throw new UnicoMensagemUsuarioException("WCAD57", "Selecionar um certificado A1.");
            }
        }
        certificado.setSenha(UnicoCrypt.cript((String)certificado.getSenha()));
    }

    public void loadFile(MultipartFile[] files, Certificado certificado) throws UnicoMensagemUsuarioException {
        if (files.length != 0) {
            try {
                certificado.setBinario(files[0].getBytes());
            }
            catch (IOException e) {
                throw new UnicoMensagemUsuarioException("WWW245", "N\u00e3o foi poss\u00edvel carregar o certificado. " + e.getMessage());
            }
        } else if (certificado.getBinario() == null) {
            if (!NumberUtil.longNullOuZero((Long)certificado.getId())) {
                certificado.setBinario(((Certificado)CertificadoRN.getInstance().buscarPorId(certificado.getId())).getBinario());
            } else {
                throw new UnicoMensagemUsuarioException("WWW246", "Por favor informe o certificado.");
            }
        }
    }

    protected String getCacheId() {
        return "certificados";
    }

    protected GridBuilder<CertificadoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("tipo", "Tipo", 0, true));
        GridBuilder grid = new GridBuilder(CertificadoRN.getInstance().getTabela(), colunas);
        grid.addCodicaoDefault(new Condicao("tipo", Operador.IGUAL, TipoCertificado.A1.getId().intValue()));
        grid.setOrdemDefault(new Ordem("descricao"));
        return grid;
    }

    private CertificadoWrapper carregarDadosCertificado(byte[] certificado, TipoCertificado tipoCertificado, String senha, String alias) throws UnicoMensagemUsuarioException {
        try {
            DadosCertificado dados = DadosCertificadoUtil.carregarCertificado((TipoCertificado)tipoCertificado, (byte[])certificado, null, (String)senha, (String)alias);
            if (dados != null) {
                X509Certificate certificate = (X509Certificate)dados.getKeyStore().getCertificate(dados.getAlias());
                LocalDate validade = DataHoraFactory.date2LocalDate((Date)certificate.getNotAfter());
                String detalhe = certificate.getSubjectX500Principal() + "\nValidade: " + StringUtil.formataDataHora((Temporal)validade, (String)"dd/MM/yyyy");
                return new CertificadoWrapper(dados.getAlias(), detalhe);
            }
            throw new UnicoMensagemUsuarioException("WWW443", "N\u00e3o foi poss\u00edvel carregar o certificado.");
        }
        catch (KeyStoreException e) {
            throw new UnicoMensagemUsuarioException("WWW247", e.getMessage());
        }
    }
}

