/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.compras.pedidocompra;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.CfopItem;
import br.intelidata.commons.domain.pojo.CustoInterface;
import br.intelidata.commons.domain.pojo.Embalagem;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.ParametrosNotaFiscalInterface;
import br.intelidata.commons.domain.pojo.PedidoCompraItemWeb;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItem;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.ProdutoPreco;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.compras.ItensRelacionarNotafiscal;
import br.intelidata.commons.domain.pojo.compras.PedidoCompra;
import br.intelidata.commons.domain.pojo.compras.PedidoCompraItem;
import br.intelidata.commons.domain.pojo.compras.PedidoCompraItemBaixa;
import br.intelidata.commons.domain.pojo.compras.ProdutoSugestao;
import br.intelidata.commons.domain.pojo.edi.EDIProcessado;
import br.intelidata.commons.domain.pojo.enuns.CstIPI;
import br.intelidata.commons.domain.pojo.enuns.CstPisCofins;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.StatusPedidoCompra;
import br.intelidata.commons.domain.pojo.enuns.TipoCustoCompra;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoEnquadramentoFilial;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoPessoa;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.enuns.nfe.TipoContribuinte;
import br.intelidata.commons.domain.pojo.enuns.notafiscal.TipoCalculoImposto;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.domain.pojo.generico.VariavelTextoGenerico;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.PedidoCompraCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoItemRN;
import br.intelidata.commons.domain.regranegocio.UnidademedidaCommonRN;
import br.intelidata.commons.domain.wrapper.ImpostoWrapper;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.TextoGenericoRN;
import br.intelidata.commons.modulo.compras.regranegocio.BuscarProdutosPedidoCompraRN;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraItemBaixaRN;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraItemRN;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoFactory;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoController;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImportacaoDadosColetor;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.pedidocompra.ImpostoPedidoCompraWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.pedidocompra.PedidoCompraCancelarSaldoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.pedidocompra.PedidoCompraItemWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.pedidocompra.PedidoCompraProdutoSugestaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.pedidocompra.PedidoCompraWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.ImpostoCalculadoWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Component(value="pedido_compra")
@ConfiguracaoCampoExtra(TABELA="pedido_compra", QUANTIDADE=QuantidadeCampoExtra.PEDIDO_COMPRA)
@RestController
@RequestMapping(value={"/api/pedido-compras"})
@SubMenuMapping(MENU="SubMenuComprasGeral", NOME="Pedido de compras", ROTA="/compras/pedido-compras", ICONE="icon-pedido", PROGRAMA=702)
public class PedidoCompraCrudController
extends CalculoImpostoController<PedidoCompra, PedidoCompraItemWeb, PedidoCompraItemWeb, PedidoCompraRN> {
    protected final FuncionalidadeService funcionalidadeService;
    protected CalculoImpostoService<PedidoCompraItemWeb> calculoImpostoService;

    public PedidoCompraCrudController(CalculoImpostoService<PedidoCompraItemWeb> calculoImpostoService, FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)PedidoCompraRN.getInstance(), calculoImpostoService, PedidoCompra::new);
        this.calculoImpostoService = calculoImpostoService;
        this.funcionalidadeService = funcionalidadeService;
    }

    @DBAutoCommit
    public ImpostoCalculadoWrapper<PedidoCompraItemWeb> atualizarComponentes(@RequestBody ImpostoWrapper<PedidoCompraItemWeb> impostoWrapper) throws UnicoMensagemUsuarioException {
        impostoWrapper.setTipoNotaFiscal(TipoNotaFiscal.ENTRADA);
        return super.atualizarComponentes(impostoWrapper);
    }

    @DBAutoCommit
    public ImpostoCalculadoWrapper<PedidoCompraItemWeb> calcularImpostos(@RequestBody ImpostoWrapper<PedidoCompraItemWeb> impostoWrapper, @RequestParam(required=false) String crud, @RequestParam(required=false, defaultValue="true") boolean mapearAcoes) throws UnicoMensagemUsuarioException {
        ((PedidoCompraItemWeb)impostoWrapper.getItem()).setPrecoUnitario(((PedidoCompraItemWeb)impostoWrapper.getItem()).getPrecoComAcrecimo());
        impostoWrapper.setTipoNotaFiscal(TipoNotaFiscal.ENTRADA);
        ImpostoCalculadoWrapper retorno = super.calcularImpostos(impostoWrapper, crud, mapearAcoes);
        ((PedidoCompraItemWeb)retorno.getItem()).setImpostoCalculado(true);
        return retorno;
    }

    @DBAutoCommit
    public List<PedidoCompraItemWeb> recalcularImpostosItens(@RequestBody ImpostoWrapper<PedidoCompraItemWeb> impostoWrapper) throws UnicoMensagemUsuarioException {
        impostoWrapper.setTipoNotaFiscal(TipoNotaFiscal.ENTRADA);
        List lista = super.recalcularImpostosItens(impostoWrapper);
        lista.forEach(it -> it.setImpostoCalculado(true));
        return lista;
    }

    @RequestMapping(value={"/itens"})
    @DBAutoCommit
    public List<PedidoCompraItem> buscarItens(@RequestParam Long id, @RequestParam(required=false, defaultValue="false") boolean duplicacao) throws UnicoMensagemUsuarioException {
        PedidoCompra pedidoCompra = (PedidoCompra)((PedidoCompraRN)this.rn).buscarPorId(id);
        if (pedidoCompra == null) {
            throw new UnicoMensagemUsuarioException("WCMP153", "Pedido de compra n\u00e3o encontrado");
        }
        List items = PedidoCompraItemRN.getInstance().buscarListaPorIdPedidoCompra(new Long[]{id});
        if (!duplicacao) {
            items.forEach(item -> item.setPodeAlterarExcluir(pedidoCompra.getStatus().isPermiteAlterar()));
        } else {
            items.forEach(item -> item.setId(null));
        }
        return items;
    }

    @RequestMapping(value={"/carregar-itens-por-sugestao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<PedidoCompraItemWeb> carregarItensPorListaSugestao(@RequestBody PedidoCompraProdutoSugestaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        ArrayList<PedidoCompraItemWeb> itens = new ArrayList<PedidoCompraItemWeb>();
        for (ProdutoSugestao produtoSugestao : wrapper.getListaProdutoSugestao()) {
            ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), produtoSugestao.getIdProduto());
            ProdutoItemWeb produtoItemWeb = this.carregarDadosItem(produto, wrapper.getIdParametro(), wrapper.getIdFornecedor(), wrapper.getIdCondicaoPagamento(), true, wrapper.getTransacao(), null);
            ((PedidoCompraItemWeb)produtoItemWeb.getItem()).setQuantidade(produtoSugestao.getEditarsugestao());
            produtoItemWeb = this.getPrecoProduto(produto, (PedidoCompraItemWeb)produtoItemWeb.getItem(), wrapper.getIdFornecedor(), wrapper.getIdParametro(), wrapper.isPossuiItens(), wrapper.getTransacao(), TipoCalculoImposto.CST_IPI);
            itens.add((PedidoCompraItemWeb)produtoItemWeb.getItem());
        }
        return itens;
    }

    @RequestMapping(value={"/buscar-preco-produto"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ProdutoItemWeb<PedidoCompraItemWeb> getPrecoProduto(@RequestBody PedidoCompraItemWrapper wrapper) throws UnicoMensagemUsuarioException {
        ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), wrapper.getItem().getIdProduto());
        return this.getPrecoProduto(produto, wrapper.getItem(), wrapper.getIdFornecedor(), wrapper.getIdParametro(), wrapper.isPossuiItens(), wrapper.getTransacao(), wrapper.getTipoCalculo());
    }

    public ProdutoItemWeb<PedidoCompraItemWeb> getPrecoProduto(ProdutoDTOWeb produto, PedidoCompraItemWeb item, Long idFornecedor, Long idParametro, boolean possuiItens, int transacao, TipoCalculoImposto tipoCalculoImposto) throws UnicoMensagemUsuarioException {
        Embalagem embalagem;
        if (!NumberUtil.longNullOuZero((Long)item.getIdEmbalagem()) && item.getIdEmbalagem() != -1L) {
            item.setIdUnidadeMedida(((Embalagem)EmbalagemRN.getInstance().buscarPorId(item.getIdEmbalagem())).getIdUnidadeMedida());
        }
        boolean calcularImpostos = this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_COMPRA);
        BigDecimal preco = this.getPrecoCusto(produto.getId(), SessaoUtil.getSessao(), calcularImpostos);
        if (!calcularImpostos && !Util.longNullOuZero((Long)item.getIdEmbalagem()) && (embalagem = (Embalagem)EmbalagemRN.getInstance().buscarPorId(item.getIdEmbalagem())) != null) {
            Unidademedida unidademedida;
            if (!Util.bigDecimalNullOrZero((BigDecimal)embalagem.getPreco())) {
                preco = embalagem.getPreco();
            }
            if ((unidademedida = (Unidademedida)UnidademedidaCommonRN.getInstance().buscarPorId(embalagem.getIdUnidadeMedida())) != null) {
                item.setCasasDecimaisQuantidade(unidademedida.getCasasdecimais().intValue());
            }
        }
        ProdutoPreco produtoPreco = new ProdutoPreco();
        produtoPreco.setPreco(preco);
        item.setPreco(preco);
        item.setPrecoComAcrecimo(preco);
        ProdutoItemWeb produtoItemWeb = new ProdutoItemWeb();
        produtoItemWeb.setProdutoPreco(produtoPreco);
        if (calcularImpostos) {
            ImpostoWrapper imposto = new ImpostoWrapper((ProdutoItem)item, tipoCalculoImposto, idParametro, idFornecedor, possuiItens, transacao, TipoNotaFiscal.ENTRADA);
            imposto.setCalcularImposto(true);
            ImpostoCalculadoWrapper impostoCalculado = this.calculoImpostoService.calcularImpostos(imposto, true);
            produtoItemWeb.setItem((ItemWeb)impostoCalculado.getItem());
            produtoItemWeb.setAcoes(impostoCalculado.getAcoes());
        } else {
            item.setTotal(item.getPreco().multiply(item.getQuantidade()).subtract(item.getDesconto()).setScale(2, 5));
            produtoItemWeb.setItem((ItemWeb)item);
        }
        return produtoItemWeb;
    }

    @RequestMapping(value={"/calcular-preco-itens"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ImpostoPedidoCompraWrapper calcularItensPorCondicaoPagamento(@RequestBody PedidoCompraItemWrapper wrapper) throws UnicoMensagemUsuarioException {
        ImpostoPedidoCompraWrapper imposto;
        Sessao sessao = SessaoUtil.getSessao();
        wrapper.getItens().forEach(item -> {
            ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, item.getIdProduto());
            boolean calcularImpostos = this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_COMPRA);
            TipoValorPreco tipoPreco = TipoValorPreco.CUSTO;
            if (calcularImpostos) {
                tipoPreco = this.calculoImpostoService.getTipoValorPreco(wrapper.getIdParametro(), PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 372));
            }
            if (TipoValorPreco.PRECO.equals((Object)tipoPreco)) {
                tipoPreco = TipoValorPreco.CUSTO;
            }
            new ProdutoItemRN().atualizarPreco(sessao, wrapper.getItens(), produto, (ProdutoItem)item, tipoPreco, wrapper.getIdCondicaoPgmto(), Long.valueOf(0L), true, true, true, calcularImpostos, null, null);
            item.setPrecoMinimoVenda(BigDecimal.ZERO);
            item.setPreco(item.getPrecoUnitario());
            if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)item.getPercentualdesconto())) {
                BigDecimal bruto = item.getPrecoUnitario().multiply(item.getQuantidade()).setScale(2, 6);
                item.setDesconto(NumberUtil.valorDesconto((BigDecimal)bruto, (BigDecimal)item.getPercentualdesconto(), (int)2));
            }
            item.setTotal(item.getPrecoUnitario().multiply(item.getQuantidade()).subtract(item.getDesconto()).setScale(2, 6));
        });
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_COMPRA)) {
            ImpostoWrapper impostoWrapper = new ImpostoWrapper(wrapper.getIdFornecedor(), wrapper.getIdParametro(), wrapper.getItens());
            impostoWrapper.setEstado(wrapper.getEstado());
            impostoWrapper.setTipoNotaFiscal(TipoNotaFiscal.ENTRADA);
            imposto = new ImpostoPedidoCompraWrapper(this.recalcularImpostosItens(impostoWrapper));
        } else {
            imposto = new ImpostoPedidoCompraWrapper(wrapper.getItens());
        }
        return imposto;
    }

    @RequestMapping(value={"/calcular-rateios-frete"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<PedidoCompraItemWeb> calcularRateiosValorFrete(@RequestBody PedidoCompraItemWrapper wrapper) throws UnicoMensagemUsuarioException {
        List items = wrapper.getItens().stream().map(item -> item).collect(Collectors.toList());
        PedidoCompraRN.getInstance().calculaRateioValor(items, "frete", wrapper.getValorFrete());
        List itemsWeb = items.stream().map(item -> {
            item.setTotal(item.getPreco().multiply(item.getQuantidade()).subtract(item.getDesconto()).setScale(2, 5));
            return (PedidoCompraItemWeb)item;
        }).collect(Collectors.toList());
        wrapper.setItens(itemsWeb);
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_COMPRA)) {
            ImpostoWrapper impostoWrapper = new ImpostoWrapper(wrapper.getIdFornecedor(), wrapper.getIdParametro(), wrapper.getItens());
            impostoWrapper.setEstado(wrapper.getEstado());
            impostoWrapper.setTipoNotaFiscal(TipoNotaFiscal.ENTRADA);
            return this.recalcularImpostosItens(impostoWrapper);
        }
        return wrapper.getItens();
    }

    @PostMapping(value={"/preparar-compartilhamento"})
    @DBAutoCommit
    public NotificacaoCompartilhamento prepararEnvioEmail(@RequestBody List<Long> idsPedidos, @RequestParam(required=false) Long idTextoGenerico) throws UnicoMensagemUsuarioException {
        Long idEntidade = null;
        if (Util.listNullOrEmpty(idsPedidos)) {
            throw new UnicoMensagemUsuarioException("WCMP124", "Por favor selecione um ou mais pedidos de compra.");
        }
        List pedidos = PedidoCompraRN.getInstance().buscarListaPorIds(idsPedidos);
        for (PedidoCompra pedidoCompra : pedidos) {
            if (Util.longNullOuZero(idEntidade)) {
                idEntidade = pedidoCompra.getIdFornecedor();
            }
            if (pedidoCompra.getIdFornecedor() == null || pedidoCompra.getIdFornecedor().equals(idEntidade)) continue;
            throw new UnicoMensagemUsuarioException("WCMP125", "Os pedidos de compra selecionados devem pertencer ao mesmo fornecedor.");
        }
        NotificacaoCompartilhamento notificacaoCompartilhamento = this.verificaCompartilhamento(pedidos);
        if (!NumberUtil.longNullOuZero((Long)idTextoGenerico)) {
            notificacaoCompartilhamento.setMensagem(this.reescreveTextoMensagem(pedidos, idTextoGenerico));
        }
        return notificacaoCompartilhamento;
    }

    @PostMapping(value={"/preparar-texto-compartilhamento"})
    @DBAutoCommit
    public String prepararTextoEmail(@RequestBody List<Long> idsPedidos, @RequestParam Long idTextoGenerico) {
        List pedidos = PedidoCompraRN.getInstance().buscarListaPorIds(idsPedidos);
        if (ListMapUtil.listNullOrEmpty((List)pedidos)) {
            return null;
        }
        return this.reescreveTextoMensagem(pedidos, idTextoGenerico);
    }

    @DBAutoCommit
    public List<PedidoCompraItem> getItens(Long id) {
        return PedidoCompraItemRN.getInstance().buscarListaPorIdPedidoCompra(new Long[]{id});
    }

    protected NotificacaoCompartilhamento verificaCompartilhamento(List<PedidoCompra> documentos) {
        Long idEntidade = null;
        String codigosDocumentos = null;
        int cont = 0;
        for (PedidoCompra documento : documentos) {
            ++cont;
            if (Util.longNullOuZero(idEntidade)) {
                idEntidade = documento.getIdFornecedor();
            }
            if (Util.stringNullOrEmpty(codigosDocumentos)) {
                codigosDocumentos = documento.getCodigo().toString();
                continue;
            }
            if (cont != 1 && cont == documentos.size()) {
                codigosDocumentos = codigosDocumentos + " e " + documento.getCodigo().toString();
                continue;
            }
            codigosDocumentos = codigosDocumentos + ", " + documento.getCodigo().toString();
        }
        String complemento = cont > 1 ? "os pedidos de compras : " : "o pedido de compras ";
        NotificacaoCompartilhamento notificacaoCompartilhamento = new NotificacaoCompartilhamento();
        notificacaoCompartilhamento.setAssunto("Segue em anexo " + complemento + codigosDocumentos + ".");
        notificacaoCompartilhamento.setCelular(((Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade)).getNumeroEnvioWhatsapp());
        return notificacaoCompartilhamento;
    }

    protected String reescreveTextoMensagem(List<PedidoCompra> pedidos, Long idTextoGenerico) {
        TextoGenerico textoGenerico = (TextoGenerico)TextoGenericoRN.getInstance().buscarPorId(idTextoGenerico);
        String mensagem = textoGenerico.getTexto();
        if (mensagem == null) {
            return null;
        }
        Filial filial = SessaoUtil.getSessao().getFilial();
        mensagem = mensagem.replace(VariavelTextoGenerico.RAZAO_SOCIAL.getId(), filial.getRazaoSocialCompleta());
        mensagem = mensagem.replace(VariavelTextoGenerico.CNPJ_EMPRESA.getId(), filial.getCnpj());
        mensagem = mensagem.replace(VariavelTextoGenerico.DATA_ATUAL.getId(), Util.formataDataHora((Temporal)DataHoraFactory.getData(), (String)"dd/MM/yyyy"));
        for (PedidoCompra pedidoCompra : pedidos) {
            Long idFornecedor = pedidoCompra.getIdFornecedor();
            Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idFornecedor);
            mensagem = mensagem.replace(VariavelTextoGenerico.VALOR_TOTAL_PEDIDO_COMPRA.getId(), Util.formataNumero((BigDecimal)pedidoCompra.getValorTotal(), (int)2));
            mensagem = mensagem.replace(VariavelTextoGenerico.CODIGO_PEDIDO_COMPRA.getId(), pedidoCompra.getCodigo().toString());
            if (entidade == null) continue;
            mensagem = mensagem.replace(VariavelTextoGenerico.NOME_FORNECEDOR_PEDIDO_COMPRA.getId(), entidade.getTipoPessoa().equals((Object)TipoPessoa.JURIDICA) ? entidade.getRazaoSocial() : entidade.getNome());
        }
        return mensagem;
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idFornecedor", "idFornecedor", 0, false));
        colunas.add(new ColunaSQL("status", "status_default", "Status", 0, false, new String[0]));
        colunas.add(new ColunaSQL("codigo", "Documento", 200, true));
        colunas.add(new ColunaSQL("nome", "nomeFornecedor", "Fornecedor", 0, true, new String[]{"fk_pedidocompra_entidade"}));
        colunas.add(new ColunaSQL("dataEmissao", "Emiss\u00e3o", 200, true));
        colunas.add(new ColunaSQL("dataPrevisaoEntrega", "Prev. Entrega", 200, true));
        ColunaSQL colunaValor = new ColunaSQL("valorTotal", "Valor", 300, true);
        colunaValor.setTotalizar(true);
        colunas.add(colunaValor);
        colunas.add(new ColunaSQL("status", "Status", 200, true));
        GridBuilder grid = new GridBuilder(((PedidoCompraRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial", "idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        return grid;
    }

    public ProdutoItemWeb<PedidoCompraItemWeb> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        Long idCondicaoPgmto = null;
        if (parametros.containsKey((Object)"idCondicaoPgmto")) {
            idCondicaoPgmto = StringUtil.convertFirstValueMapToLong(parametros, (String)"idCondicaoPgmto");
        }
        Long idParametroFiscal = null;
        if (parametros.containsKey((Object)"idParametro")) {
            idParametroFiscal = StringUtil.convertFirstValueMapToLong(parametros, (String)"idParametro");
        }
        Long idFornecedor = StringUtil.convertFirstValueMapToLong(parametros, (String)"idFornecedorPedido");
        int transacao = StringUtil.convertFirstValueMapToInt(parametros, (String)"transacao");
        boolean possuiItens = StringUtil.convertFirstValueMapToBoolean(parametros, (String)"possuiItens");
        List tiposEmbalagem = StringUtil.getAllValuesMap(parametros, (String)"tiposEmbalagem");
        return this.carregarDadosItem(produto, idParametroFiscal, idFornecedor, idCondicaoPgmto, possuiItens, transacao, tiposEmbalagem);
    }

    public ProdutoItemWeb<PedidoCompraItemWeb> carregarDadosItem(ProdutoDTOWeb produto, Long idParametroFiscal, Long idFornecedor, Long idCondicaoPgmto, boolean possuiItens, int transacao, List<String> tiposEmbalagem) throws UnicoMensagemUsuarioException {
        Estado estado;
        ProdutoItemWeb produtoItem = new ProdutoItemWeb();
        PedidoCompraItemWeb item = new PedidoCompraItemWeb();
        item.setQuantidade(BigDecimal.ONE);
        item.setSituacaoTributariaIPI(CstIPI.ENTRADA_TRIBUTADA_COM_ALIQUOTA_ZERO);
        item.setOrigem(produto.getOrigem().getId().intValue());
        produtoItem.setItem((ItemWeb)item);
        produtoItem.setProduto(produto);
        Entidade fornecedor = null;
        ArrayList<TipoEmbalagem> tipos = new ArrayList<TipoEmbalagem>();
        tipos.add(TipoEmbalagem.COMPRAVENDA);
        if (idParametroFiscal == null && this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_COMPRA)) {
            throw new UnicoMensagemUsuarioException("WCMP127", "Par\u00e2metro para identificar natureza de opera\u00e7\u00e3o n\u00e3o encontrado.");
        }
        if (!NumberUtil.longNullOuZero((Long)idFornecedor)) {
            fornecedor = (Entidade)EntidadeRN.getInstance().buscarPorId(idFornecedor);
        }
        if (!ListMapUtil.listNullOrEmpty(tipos) && tiposEmbalagem != null) {
            tiposEmbalagem.forEach(tipo -> {
                TipoEmbalagem tipoEmbalagem = Enum.valueOf(TipoEmbalagem.class, tipo);
                if (!tipos.contains(tipoEmbalagem)) {
                    tipos.add(tipoEmbalagem);
                }
            });
        }
        boolean calcularImpostos = this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_COMPRA);
        boolean utilizaOperacaoFiscal = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 372);
        String codigoEstado = "";
        if (fornecedor != null && (estado = (Estado)EstadoRN.getInstance().buscarPorId(fornecedor.getEndereco().getIdEstado())) != null) {
            codigoEstado = estado.getCodigo();
        }
        CfopItem cfopItem = new CfopItem(idParametroFiscal, null, codigoEstado, fornecedor != null ? fornecedor.getCnpjCpf() : null, 2);
        new ProdutoItemRN().carregaItem(SessaoUtil.getSessao(), produtoItem, fornecedor, idParametroFiscal, idCondicaoPgmto, Long.valueOf(0L), calcularImpostos, true, true, TipoValorPreco.CUSTO, utilizaOperacaoFiscal, false, false, cfopItem, tipos, true, null, 10, false);
        ((PedidoCompraItemWeb)produtoItem.getItem()).setSaldo(BigDecimal.ZERO);
        Unidademedida unidadeMedida = produtoItem.getProduto().getEmbalagem() != null ? (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(produtoItem.getProduto().getEmbalagem().getIdUnidadeMedida()) : (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(produtoItem.getProduto().getIdUnidadeMedida());
        ((PedidoCompraItemWeb)produtoItem.getItem()).setCasasDecimaisQuantidade(unidadeMedida.getCasasdecimais().intValue());
        ((PedidoCompraItemWeb)produtoItem.getItem()).setCasasDecimaisPreco(ProdutoCommonRN.getInstance().getCasasDecimaisCusto(produto.getId()));
        produtoItem.getProduto().setCasasDecimais(((PedidoCompraItemWeb)produtoItem.getItem()).getCasasDecimaisPreco());
        ((PedidoCompraItemWeb)produtoItem.getItem()).setPrecoComAcrecimo(((PedidoCompraItemWeb)produtoItem.getItem()).getPreco());
        if (calcularImpostos) {
            ImpostoWrapper imposto = new ImpostoWrapper((ProdutoItem)produtoItem.getItem(), TipoCalculoImposto.CST_IPI, idParametroFiscal, fornecedor != null ? fornecedor.getId() : null, possuiItens, transacao, TipoNotaFiscal.ENTRADA);
            imposto.setCalcularImposto(true);
            ImpostoCalculadoWrapper impostoCalculado = this.calculoImpostoService.calcularImpostos(imposto, true);
            produtoItem.setItem((ItemWeb)impostoCalculado.getItem());
            produtoItem.setAcoes(impostoCalculado.getAcoes());
        }
        return produtoItem;
    }

    protected void beforeRead(PedidoCompra e, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (7 == modo) {
            e.setCodigo(null);
            e.setDataEmissao(DataHoraFactory.getData());
            ((PedidoCompraRN)this.rn).limparCamposParaDuplicar((AbstractPojo)e);
        }
    }

    protected void beforeCreate(PedidoCompra pedidoCompra, Optional<Long> parentId) {
        pedidoCompra.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        if (pedidoCompra.getData() == null) {
            pedidoCompra.setDataEmissao(DataHoraFactory.getData());
        }
        pedidoCompra.setStatus(StatusPedidoCompra.ABERTO);
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody PedidoCompra pedidoCompra, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.create((AbstractPojo)pedidoCompra, parentId);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody PedidoCompra pedidoCompra, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.update((AbstractPojo)pedidoCompra, parentId);
    }

    protected void beforeSave(PedidoCompra pedidoCompra, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        pedidoCompra.setIdUsuario(SessaoUtil.getSessao().getIdUsuario());
        if (ListMapUtil.listNullOrEmpty((List)pedidoCompra.getItens())) {
            throw new UnicoMensagemUsuarioException("WCMP128", "N\u00e3o existem itens para esse documento");
        }
        this.validarItens(pedidoCompra);
    }

    private NaturezaOperacao getCfopItem(Entidade cliente, Long idProduto, ParametrosNotaFiscalInterface parametrosNotaFiscal, boolean utilizaOperacaoFiscal, String codigoEstado) throws UnicoMensagemUsuarioException {
        if (utilizaOperacaoFiscal) {
            return this.buscarNaturezaOperacaoDaOperacaoFiscal(cliente, idProduto, false, parametrosNotaFiscal != null ? parametrosNotaFiscal.getId() : null);
        }
        return this.buscaNaturezaOperacaoPreferencialItem(parametrosNotaFiscal, cliente, idProduto, codigoEstado);
    }

    private NaturezaOperacao buscarNaturezaOperacaoDaOperacaoFiscal(Entidade cliente, Long idProduto, boolean mostrarProdutoNaMsg, Long idOperacaoCabecalho) throws UnicoMensagemUsuarioException {
        TipoContribuinte tipoContribuinte = null;
        String codigoEstado = "";
        String cnpj = "";
        Long idEntidade = null;
        if (cliente != null) {
            Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(cliente.getEndereco().getIdEstado());
            if (estado != null) {
                codigoEstado = estado.getCodigo();
            }
            if (TipoPessoa.JURIDICA.equals((Object)cliente.getTipoPessoa())) {
                cnpj = cliente.getCnpjCpf();
            }
            tipoContribuinte = cliente.getTipoContribuinte();
            idEntidade = cliente.getId();
        }
        return NaturezaOperacaoRN.getInstance().buscarCfopsPorOperacaoFiscal(idProduto, idOperacaoCabecalho, tipoContribuinte, codigoEstado, true, mostrarProdutoNaMsg, cnpj, SessaoUtil.getSessao().getFilial(), idEntidade, 10);
    }

    private NaturezaOperacao buscaNaturezaOperacaoPreferencialItem(ParametrosNotaFiscalInterface parametros, Entidade cliente, Long idProduto, String codigoEstado) {
        boolean naoConsideraTributacaoEspecialItem = false;
        if (parametros != null) {
            naoConsideraTributacaoEspecialItem = parametros.isNaoConsideraTribEspecProduto();
        }
        return ProdutoRN.getInstance().getCFOPPreferencialTributacaoEspecial(idProduto, codigoEstado, SessaoUtil.getSessao().getFilial().getEstado(), true, naoConsideraTributacaoEspecialItem, 10, parametros, false, cliente.getTipoContribuinte(), SessaoUtil.getSessao().getFilial(), cliente);
    }

    private void validarItens(PedidoCompra pedidoCompra) throws UnicoMensagemUsuarioException {
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_COMPRA)) {
            for (PedidoCompraItem item : pedidoCompra.getItens()) {
                int comparacaoValorFcpST;
                int comparacaoValorFcpInterno;
                int comparacaoBaseIPI;
                int comparacaoBaseCofins;
                boolean isReducaoCemPorCento;
                String cstIcms;
                boolean verificaPercentualICMS;
                boolean bl = verificaPercentualICMS = !StringUtil.stringNullOrEmpty((String)item.getSituacaotributaria()) && StringUtil.stringNullOrEmpty((String)item.getSituacaotributariaSN()) && !item.isNaoConsiderarValorTotalNota();
                if (verificaPercentualICMS && ((cstIcms = item.getSituacaotributaria().substring(1)).equals("00") || cstIcms.equals("10") || cstIcms.equals("20") || cstIcms.equals("70")) && item.getPercentualIcms().compareTo(BigDecimal.ZERO) == 0 && SessaoUtil.getSessao().getFilial().getTipoEnquadramento() != TipoEnquadramentoFilial.SIMPLESNACIONAL) {
                    throw new UnicoMensagemUsuarioException("WCMP129", "Para ST do Icms = " + cstIcms + " a al\u00edquota deve ser maior que 0. Configure no cadastro do \"Produto\" ou da \"Natureza de opera\u00e7\u00e3o\" ");
                }
                int comparacaoAliquotaIcms = item.getPercentualIcms().compareTo(BigDecimal.ZERO);
                int comparacaoBaseIcms = item.getBaseIcms().compareTo(BigDecimal.ZERO);
                boolean bl2 = isReducaoCemPorCento = item.getPercentualReducaoIcms().compareTo(NumberUtil.CEM) == 0;
                if (comparacaoAliquotaIcms != comparacaoBaseIcms && !isReducaoCemPorCento) {
                    String msg = comparacaoBaseIcms > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WCMP130", "A al\u00edquota e base de c\u00e1lculo do ICMS n\u00e3o conferem, a al\u00edquota de ICMS " + msg + "deve ser informada quando o item " + msg + "possuir base de c\u00e1lculo. Verifique! ");
                }
                int comparacaoAliquotaPis = item.getAliquotaPis().compareTo(BigDecimal.ZERO);
                int comparacaoBasePis = item.getBasePis().compareTo(BigDecimal.ZERO);
                CstPisCofins cstPisCofins = (CstPisCofins)EnumUtils.getPorId(CstPisCofins.class, (Object)item.getCstPis());
                if (comparacaoAliquotaPis != comparacaoBasePis && cstPisCofins != null && !cstPisCofins.isAliquotaZero()) {
                    String msg = comparacaoBasePis > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WCMP131", "A al\u00edquota e base de c\u00e1lculo do PIS n\u00e3o conferem, a al\u00edquota do PIS " + msg + "deve ser informada quando o item " + msg + "possuir base de c\u00e1lculo. Verifique! ");
                }
                int comparacaoAliquotaCofins = item.getAliquotaCofins().compareTo(BigDecimal.ZERO);
                if (comparacaoAliquotaCofins != (comparacaoBaseCofins = item.getBaseCofins().compareTo(BigDecimal.ZERO)) && cstPisCofins != null && !cstPisCofins.isAliquotaZero()) {
                    String msg = comparacaoBaseCofins > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WCMP132", "A al\u00edquota e base de c\u00e1lculo do COFINS n\u00e3o conferem, a al\u00edquota do COFINS " + msg + "deve ser informada quando o item " + msg + "possuir base de c\u00e1lculo. Verifique! ");
                }
                int comparacaoValorIcmsST = item.getIcmsSubstituicao().compareTo(BigDecimal.ZERO);
                int comparacaoBaseIcmsST = item.getBaseIcmsSubstituicao().compareTo(BigDecimal.ZERO);
                int comparacaoAliquotaIcmsST = item.getPercentualIcmsSubstituicao().compareTo(BigDecimal.ZERO);
                if (comparacaoValorIcmsST != comparacaoBaseIcmsST) {
                    String msg = comparacaoBaseIcmsST > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WCMP133", "Os valores de ICMS substitui\u00e7\u00e3o n\u00e3o conferem, o valor de ICMS substitui\u00e7\u00e3o " + msg + "deve ser informado quando o item " + msg + "possuir base de c\u00e1lculo de ICMS substitui\u00e7\u00e3o. Verifique! ");
                }
                if (comparacaoValorIcmsST != comparacaoAliquotaIcmsST) {
                    String msg = comparacaoValorIcmsST > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WCMP152", "Os valores de ICMS substitui\u00e7\u00e3o n\u00e3o conferem, a al\u00edquota de ICMS substitui\u00e7\u00e3o " + msg + "deve ser informada quando o item " + msg + "possuir valor de ICMS substitui\u00e7\u00e3o. Verifique! ");
                }
                int comparacaoAliquotaIPI = item.getPercentualIpi().compareTo(BigDecimal.ZERO);
                if (comparacaoAliquotaIPI != (comparacaoBaseIPI = item.getBaseIpi().compareTo(BigDecimal.ZERO))) {
                    String msg = comparacaoBaseIPI > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WCMP134", "A al\u00edquota e base de c\u00e1lculo do IPI n\u00e3o conferem, a al\u00edquota do IPI " + msg + "deve ser informada quando o item " + msg + "possuir base de c\u00e1lculo. Verifique! ");
                }
                int comparacaoAliquotaFcpInterno = item.getPercIcmsFundoPobrezaInterno().compareTo(BigDecimal.ZERO);
                if (comparacaoAliquotaFcpInterno != (comparacaoValorFcpInterno = item.getIcmsFundoPobrezaInterno().compareTo(BigDecimal.ZERO))) {
                    throw new UnicoMensagemUsuarioException("WCMP135", "A al\u00edquota e valor do FCP interno n\u00e3o conferem. Verifique! ");
                }
                int comparacaoAliquotaFcpST = item.getPercentualIcmsFundoPobrezaST().compareTo(BigDecimal.ZERO);
                if (comparacaoAliquotaFcpST != (comparacaoValorFcpST = item.getIcmsFundoPobrezaST().compareTo(BigDecimal.ZERO))) {
                    throw new UnicoMensagemUsuarioException("WCMP136", "A al\u00edquota e valor do FCP ST n\u00e3o conferem. Verifique! ");
                }
                String cst = item.getSituacaotributaria() != null ? item.getSituacaotributaria() : "";
                if (!cst.equals("51") || item.getPercentualIcmsDiferido().compareTo(NumberUtil.CEM) <= 0) continue;
                throw new UnicoMensagemUsuarioException("WCMP137", "O percentual de diferimento est\u00e1 inv\u00e1lido!");
            }
        }
    }

    @RequestMapping(value={"/buscar-produtos-sugestao-compras"})
    @DBAutoCommit
    public List<ProdutoSugestao> buscarListaSugestao(@RequestParam(required=false) Long idFornecedor, @RequestParam(required=false) Long idHierarquia, @RequestParam boolean apenasProdutosComQuantidade, @RequestParam boolean apenasProdutosComVenda, @RequestParam int quantidadeMeses, @RequestParam boolean mostrarInativos, @RequestParam String pesquisaRapida) throws UnicoMensagemUsuarioException {
        List<Object> lista = new ArrayList<ProdutoSugestao>();
        if (!NumberUtil.longNullOuZero((Long)idFornecedor)) {
            lista = BuscarProdutosPedidoCompraRN.getInstance().buscarPorFornecedor(SessaoUtil.getSessao(), idFornecedor, Boolean.valueOf(apenasProdutosComQuantidade), quantidadeMeses, Boolean.valueOf(apenasProdutosComVenda), mostrarInativos);
        } else if (!NumberUtil.longNullOuZero((Long)idHierarquia)) {
            lista = BuscarProdutosPedidoCompraRN.getInstance().buscarPorGrupo(SessaoUtil.getSessao(), idHierarquia, Boolean.valueOf(apenasProdutosComQuantidade), quantidadeMeses, mostrarInativos, null);
        }
        if (!StringUtil.stringNullOrEmpty((String)pesquisaRapida)) {
            lista.removeIf(prod -> !prod.getDescricao().toLowerCase().contains(pesquisaRapida.toLowerCase()) && !prod.getProduto().toLowerCase().contains(pesquisaRapida.toLowerCase()));
        }
        return lista;
    }

    @RequestMapping(value={"/faturar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public PedidoCompraWrapper faturar(@RequestBody PedidoCompraWrapper wrapper) throws UnicoMensagemUsuarioException {
        String msgUsuario = PedidoCompraRN.getInstance().validaPedidosParaFaturar(wrapper.getIds());
        wrapper.setMsgUsuario(msgUsuario);
        NotaFiscal notaFiscal = NotaFiscalRN.getInstance().importarPedidosCompra(SessaoUtil.getSessao(), wrapper.getIds(), new HashMap(), wrapper.getIdOperacaoFiscal());
        notaFiscal.setGeraNovoPedidoSaldo(wrapper.isGeraNovoPedidoSaldo());
        for (int i = 0; i < notaFiscal.getNotaFiscalItens().size(); ++i) {
            ((NotaFiscalItem)notaFiscal.getNotaFiscalItens().get(i)).setId(Long.valueOf(Long.parseLong(String.valueOf(-(i + 1)))));
            ((NotaFiscalItem)notaFiscal.getNotaFiscalItens().get(i)).setItemPermiteDesconto(true);
        }
        Filial filialNotaFiscal = (Filial)FilialRN.getInstance().buscarPorId(notaFiscal.getIdFilial());
        wrapper.setNotaFiscal(notaFiscal);
        wrapper.setCriticas(NotaFiscalItemRN.getInstance().gerarCriticasFaturamentoWeb(filialNotaFiscal, notaFiscal.getNotaFiscalItens(), false));
        return wrapper;
    }

    @RequestMapping(value={"/marcar-faturado"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void marcarFaturado(@RequestBody PedidoCompraWrapper wrapper) throws UnicoMensagemUsuarioException {
        PedidoCompraRN.getInstance().marcarFaturado(SessaoUtil.getSessao(), wrapper.getIds());
    }

    @RequestMapping(value={"/mesclar"}, method={RequestMethod.POST})
    @DBTransaction
    public Long mesclar(@RequestBody PedidoCompraWrapper wrapper) throws UnicoMensagemUsuarioException {
        return PedidoCompraRN.getInstance().mesclarPedidos(SessaoUtil.getSessao(), wrapper.getIds());
    }

    @RequestMapping(value={"/validar-impostos-inclusao-item"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void validarImpostosInclusaoItem(@RequestBody PedidoCompraItemWrapper wrapper) throws UnicoMensagemUsuarioException {
        PedidoCompraItemRN.getInstance().validarInclusaItemComImpostos(SessaoUtil.getSessao(), (PedidoCompraItem)wrapper.getItem());
    }

    @RequestMapping(value={"/buscar-itens-relacionar-notafiscal"})
    @DBAutoCommit
    public ItensRelacionarNotafiscal buscarItensRelacionarNotafiscal(@RequestParam Long idFornecedor, @RequestParam Long idProduto, @RequestParam(required=false) Long idPedidoCompraItem, @RequestParam(required=false) String numeroPedidoCompra, @RequestParam(required=false) String numeroItemPedidoCompra) {
        NotaFiscalItem item = new NotaFiscalItem();
        item.setIdProduto(idProduto);
        item.setIdPedidoCompraItem(idPedidoCompraItem);
        item.setNumeroPedidoCompra(numeroPedidoCompra);
        item.setNumeroItemPedidoCompra(numeroItemPedidoCompra);
        return PedidoCompraItemRN.getInstance().buscarItensRelacionarNotafiscal(SessaoUtil.getSessao(), idFornecedor, item);
    }

    @RequestMapping(value={"/buscar-msg-item-duplicado-pedidos-abertos"})
    @DBAutoCommit
    public List<String> mensagemItemDuplicado(@RequestParam Long idProduto) {
        return Stream.of(PedidoCompraCommonRN.getInstance().getMensagemProdutoEmPedidosAbertos(SessaoUtil.getSessao(), idProduto).split(Util.lineSeparator, -1)).filter(it -> !Util.stringNullOrEmpty((String)it)).collect(Collectors.toList());
    }

    @RequestMapping(value={"/buscar-baixas-itens"})
    @DBAutoCommit
    public List<PedidoCompraItemBaixa> buscarBaixas(@RequestParam Long idPedidoCompraItem) {
        PedidoCompraItem item = (PedidoCompraItem)PedidoCompraItemRN.getInstance().buscarPorId(idPedidoCompraItem);
        if (item != null) {
            return PedidoCompraItemBaixaRN.getInstance().buscaMovimentacoesPorItemPedido(null, idPedidoCompraItem);
        }
        return null;
    }

    @RequestMapping(value={"/cancelar-saldo"}, method={RequestMethod.POST})
    @DBTransaction
    public void cancelarSaldo(@RequestBody PedidoCompraCancelarSaldoWrapper cancelarSaldoWrapper) throws UnicoMensagemUsuarioException {
        PedidoCompraRN.getInstance().cancelarSaldoPedido(SessaoUtil.getSessao(), cancelarSaldoWrapper.getIdPedidoCompra(), cancelarSaldoWrapper.getJustificativa());
    }

    protected String getCacheId() {
        return "pedido-compras".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    @DBAutoCommit
    public EDIProcessado<PedidoCompraItem> importarArquivoEdi(MultipartFile file, Long idEdi, @RequestParam MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        ImportacaoDadosColetor importacaoDadosColetor = new ImportacaoDadosColetor(PedidoCompra.class, idEdi, file);
        importacaoDadosColetor.importar();
        boolean calcularImpostos = this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_COMPRA);
        Sessao sessao = SessaoUtil.getSessao();
        int transacao = StringUtil.convertFirstValueMapToInt(parameters, (String)"transacao");
        Long idCfop = null;
        Entidade entidade = null;
        if (calcularImpostos) {
            idCfop = StringUtil.convertFirstValueMapToLong(parameters, (String)"idParametro");
            Long idEntidade = StringUtil.convertFirstValueMapToLong(parameters, (String)"idFornecedor");
            entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade);
        }
        EDIProcessado ediProcessado = new EDIProcessado();
        ediProcessado.getCriticas().addAll(importacaoDadosColetor.getEDIProcessado().getCriticas());
        for (PedidoCompraItem item : importacaoDadosColetor.getEDIProcessado().getPedidoCompraItens()) {
            item.setPreco(this.getPrecoCusto(item.getIdProduto(), sessao, calcularImpostos).setScale(item.getCasasDecimaisPreco(), RoundingMode.HALF_EVEN));
            item.setPrecoInformado(item.getPreco());
            item.setPrecoComAcrecimo(item.getPreco());
            item.setFatorConversao(item.getFatorConversao().setScale(2, RoundingMode.HALF_EVEN));
            item.setTotal(item.getTotalBruto());
            item.setImpostoCalculado(calcularImpostos);
            item.setNomeProduto(item.getDescricao());
            if (calcularImpostos) {
                NaturezaOperacao cfopProduto = this.calculoImpostoService.utilizaOperacaoFiscal(false, sessao.getIdFilial()) ? this.buscarNaturezaOperacaoDaOperacaoFiscal(entidade, item.getIdProduto(), true, idCfop) : NaturezaOperacaoRN.getInstance().buscarPorId(idCfop);
                item.setCodigoCfop(cfopProduto.getCodigo());
                item.setIdCfop(cfopProduto.getId());
                PedidoCompraItemWeb pedidoItem = new PedidoCompraItemWeb();
                BeanUtil.copiarValores((Object)item, (Object)pedidoItem, (boolean)true, (boolean)true, null);
                ImpostoWrapper imposto = new ImpostoWrapper((ProdutoItem)pedidoItem, TipoCalculoImposto.CST_IPI, cfopProduto.getId(), entidade != null ? entidade.getId() : null, true, transacao, TipoNotaFiscal.ENTRADA);
                imposto.setCalcularImposto(true);
                ImpostoCalculadoWrapper impostoCalculado = this.calculoImpostoService.calcularImpostos(imposto, true);
                ediProcessado.addPedidoCompraItem((PedidoCompraItem)impostoCalculado.getItem());
                continue;
            }
            ediProcessado.addPedidoCompraItem(item);
        }
        return ediProcessado;
    }

    private BigDecimal getPrecoCusto(Long idProduto, Sessao sessao, boolean calcularImpostos) {
        TipoCustoCompra tipoPreco = (TipoCustoCompra)PropriedadeRN.getInstance().getPropriedadeEnum(sessao.getFilial(), 927);
        CustoInterface custo = CustoFactory.getCusto((Long)idProduto, (Filial)sessao.getFilial());
        if (TipoCustoCompra.NENHUM.equals((Object)tipoPreco)) {
            if (!calcularImpostos && !Util.bigDecimalNullOrZero((BigDecimal)custo.getCustoAquisicao())) {
                return custo.getCustoAquisicao();
            }
            if (custo.getPrecoCompra().compareTo(BigDecimal.ZERO) > 0) {
                return custo.getPrecoCompra();
            }
            return custo.getCusto();
        }
        if (TipoCustoCompra.CUSTO_AQUISICAO.equals((Object)tipoPreco)) {
            return custo.getCustoAquisicao();
        }
        if (TipoCustoCompra.PRECO_COMPRA.equals((Object)tipoPreco)) {
            return custo.getPrecoCompra();
        }
        return custo.getCusto();
    }
}

