/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.configuracaoapi;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.configuracaoapi.ConfiguracaoApi;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuracoes-api"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", ICONE="icon-config", NOME="Configura\u00e7\u00e3o da API", ROTA="/ferramentas/configuracoes-api", PROGRAMA=1465)
public class ConfiguracaoApiCrudController
extends SimpleCrudController<ConfiguracaoApi, ControleRN> {
    private final JdbcTemplate jdbcTemplate;

    public ConfiguracaoApiCrudController(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public ConfiguracaoApi get(Long parentId) {
        String select = "select secret from tenant where codigo = ?";
        Map stringObjectMap = this.jdbcTemplate.queryForMap(select, new Object[]{ContextoHolder.getTenant()});
        String secret = (String)stringObjectMap.get("secret");
        ConfiguracaoApi config = new ConfiguracaoApi();
        config.setTenant(ContextoHolder.getTenant());
        config.setSecret(secret);
        return config;
    }

    @RequestMapping(value={"/gerar-uuid"})
    public String gerarUuid() {
        return UUID.randomUUID().toString();
    }

    public Long create(@RequestBody ConfiguracaoApi configuracaoApi) throws UnicoMensagemUsuarioException {
        if (StringUtil.stringNullOrEmpty((String)configuracaoApi.getSecret())) {
            throw new UnicoMensagemUsuarioException("WWW409", "N\u00e3o \u00e9 possivel gravar a configura\u00e7\u00e3o sem chave.");
        }
        this.jdbcTemplate.update("update tenant set secret = ? where codigo = ?", new Object[]{configuracaoApi.getSecret(), ContextoHolder.getTenant()});
        return 0L;
    }
}

