/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.configurador;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.domain.pojo.configurador.ConfiguradorFuncionalidade;
import br.intelidata.commons.domain.pojo.configurador.ConfiguradorModulo;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.regranegocio.ConfiguradorModuloCommonRN;
import br.intelidata.commons.domain.regranegocio.ConfiguradorModuloFuncionalidadeBackupRNSimplificada;
import br.intelidata.commons.domain.regranegocio.SemaforoCommonRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobAtivacaoFuncionalidade;
import br.intelidata.uniplusweb.web.rest.app.crud.configurador.ConfiguradorWrapper;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/configuracoes"})
public class ConfiguradorJobSimpleController
extends SimpleCrudController<ConfiguradorModulo, ConfiguradorModuloCommonRN>
implements ICreateTask {
    private final NotificationService notificationService;
    private final CacheService cacheService;
    private final TaskManager taskManager;
    private final ModuloService moduloService;
    private final FuncionalidadeService funcionalidadeService;

    public ConfiguradorJobSimpleController(NotificationService notificationService, CacheService cacheService, TaskManager taskManager, ModuloService moduloService, FuncionalidadeService funcionalidadeService) {
        this.notificationService = notificationService;
        this.cacheService = cacheService;
        this.taskManager = taskManager;
        this.moduloService = moduloService;
        this.funcionalidadeService = funcionalidadeService;
    }

    public TipoJob getTipoJob() {
        return TipoJob.ATIVACAO_FUNCIONALIDADE;
    }

    public Class<? extends AbstractJob> job() {
        return JobAtivacaoFuncionalidade.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @RequestMapping(value={"/gravar"}, method={RequestMethod.POST})
    @DBTransaction
    public ConfiguradorWrapper gravarModulosFuncionalidades(@RequestBody ConfiguradorWrapper wrapper) throws UnicoMensagemUsuarioException {
        Optional<ConfiguradorFuncionalidade> gradePadrao;
        SemaforoCommonRN.getInstance().travarTabela(SessaoUtil.getSessao(), ConfiguradorModuloCommonRN.getInstance().getTabela());
        Optional<ConfiguradorModulo> moduloProduto = wrapper.getModulos().stream().filter(m -> m.getModulo().equals(Modulo.PRODUTO.getId())).findFirst();
        if (moduloProduto.isPresent() && (gradePadrao = moduloProduto.get().getFuncionalidades().stream().filter(f -> f.getFuncionalidade().equals(Funcionalidade.GRADE_PADRAO.getId())).findFirst()).isPresent() && !gradePadrao.get().isAtivo()) {
            Optional<ConfiguradorFuncionalidade> variacao = moduloProduto.get().getFuncionalidades().stream().filter(f -> f.getFuncionalidade().equals(Funcionalidade.VARIACAO.getId())).findFirst();
            variacao.ifPresent(configuradorFuncionalidade -> configuradorFuncionalidade.setAtivo(false));
        }
        ConfiguradorModuloCommonRN.getInstance().gravarLista(0, wrapper.getModulos(), SessaoUtil.getSessao());
        this.cacheService.clear();
        ModuloManager.getInstance().recarregarPreferencias(SessaoUtil.getSessao());
        PropriedadeRN.getInstance().gravarTodasPropriedades(SessaoUtil.getSessao());
        this.executarOperacoesAtivacaoFuncionalidade(wrapper.getFuncionalidadesAtivadas());
        this.notificationService.simpleNotifyTenantAll(TipoNotificacaoSimples.WARNING, "Configura\u00e7\u00f5es para m\u00f3dulos e funcionalidades salvas com sucesso, por favor realize o login novamente para aplicar as novas configura\u00e7\u00f5es.");
        ConfiguradorModuloFuncionalidadeBackupRNSimplificada.getInstance().gravouConfiguradorSistema(SessaoUtil.getSessao());
        return new ConfiguradorWrapper(this.moduloService.getMapModulosAtivos(), this.funcionalidadeService.getMapFuncionalidadeAtivas());
    }

    private void executarOperacoesAtivacaoFuncionalidade(List<Integer> funcionalidadesAtivadas) throws UnicoMensagemUsuarioException {
        List funcionalidades = funcionalidadesAtivadas.stream().map(id -> (Funcionalidade)EnumUtils.getPorId(Funcionalidade.class, (Object)id)).collect(Collectors.toList());
        if (funcionalidades.stream().anyMatch(Funcionalidade::isVerificacaoAposAtivacao)) {
            this.createTask(funcionalidades);
        }
    }
}

