/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.configurador;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.domain.pojo.configurador.ConfiguradorFuncionalidade;
import br.intelidata.commons.domain.pojo.configurador.ConfiguradorModulo;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ConfiguradorModuloCommonRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.configurador.ConfiguradorFuncionalidadeAgregadaWrapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuracoes"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", NOME="Configurador do sistema", ICONE="icon-config", ROTA="/ferramentas/configuracoes", PROGRAMA=144)
public class ConfiguradorSimpleController
extends SimpleCrudController<ConfiguradorModulo, ConfiguradorModuloCommonRN> {
    private final FuncionalidadeService funcionalidadeService;

    @Autowired
    public ConfiguradorSimpleController(FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)ConfiguradorModuloCommonRN.getInstance());
        this.funcionalidadeService = funcionalidadeService;
    }

    @RequestMapping(value={"/modulos"})
    @DBAutoCommit
    public List<ConfiguradorModulo> buscarDadosConfigurados() throws UnicoMensagemUsuarioException {
        List modulos = ((ConfiguradorModuloCommonRN)this.getRegraNegocio()).montarModulosEdicaoFuncionalidades(SessaoUtil.getSessao());
        modulos.forEach(modulo -> {
            ((ConfiguradorModuloCommonRN)this.getRegraNegocio()).removerFuncionalidadesNaoListadasConfigurador(SessaoUtil.getSessao(), modulo);
            if (!ListMapUtil.listNullOrEmpty((List)modulo.getFuncionalidades())) {
                modulo.getFuncionalidades().forEach(funcionalidade -> {
                    Funcionalidade funEnum = (Funcionalidade)EnumUtils.getPorId(Funcionalidade.class, (Object)funcionalidade.getFuncionalidade());
                    funcionalidade.setEditavel(funEnum.getInterfaceFuncionalidade().isFuncionalidadeEditavel());
                    if (funEnum == Funcionalidade.GRADE_PADRAO && !funcionalidade.isAtivo()) {
                        funcionalidade.setAtivo(this.funcionalidadeService.isAtiva(Funcionalidade.VARIACAO));
                    }
                    if (funEnum == Funcionalidade.VARIACAO) {
                        funcionalidade.setLicenciado(false);
                    }
                });
            }
            modulo.setHabilitar(((ConfiguradorModuloCommonRN)this.getRegraNegocio()).isHabilitarModuloEdicaoConfigurador(SessaoUtil.getSessao(), modulo));
        });
        return modulos;
    }

    @RequestMapping(value={"/validar-agregadas"}, method={RequestMethod.POST})
    public ConfiguradorFuncionalidadeAgregadaWrapper verificarFuncionalidadesAgregadas(@RequestBody ConfiguradorFuncionalidadeAgregadaWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (wrapper.isSelecionado()) {
            Funcionalidade func = (Funcionalidade)EnumUtils.getPorId(Funcionalidade.class, (Object)wrapper.getFuncionalidadeAtual().getFuncionalidade());
            if (func == Funcionalidade.GRADE_PADRAO) {
                return wrapper;
            }
            List funcionalidadesAgregadas = func.getInterfaceFuncionalidade().getFuncionalidadesAgregadas();
            if (!ListMapUtil.listNullOrEmpty((List)funcionalidadesAgregadas)) {
                block0: for (Funcionalidade agregada : funcionalidadesAgregadas) {
                    boolean achou = false;
                    ConfiguradorModulo configuradorModulo = wrapper.getModuloAtual();
                    if (configuradorModulo == null) continue;
                    List funcionalidadesConf = wrapper.getFuncionalidades();
                    for (ConfiguradorFuncionalidade confFunc : funcionalidadesConf) {
                        if (!agregada.getId().equals(confFunc.getFuncionalidade())) continue;
                        if (!confFunc.isAtivo()) {
                            wrapper.getFuncionalidadeAtual().setAtivo(false);
                            Funcionalidade funcionalidade = (Funcionalidade)EnumUtils.getPorId(Funcionalidade.class, (Object)confFunc.getFuncionalidade());
                            throw new UnicoMensagemUsuarioException("COM236583", "Para ativar a funcionalidade " + func.getDescricao() + " a funcionalidade " + funcionalidade.getDescricao() + " deve estar ativa.");
                        }
                        achou = true;
                        break;
                    }
                    if (achou) continue;
                    for (ConfiguradorModulo confModulo : wrapper.getModulos()) {
                        for (ConfiguradorFuncionalidade confFunc : confModulo.getFuncionalidades()) {
                            if (!agregada.getId().equals(confFunc.getFuncionalidade())) continue;
                            if (!confFunc.isAtivo()) {
                                wrapper.getFuncionalidadeAtual().setAtivo(false);
                                Funcionalidade funcionalidade = (Funcionalidade)EnumUtils.getPorId(Funcionalidade.class, (Object)confFunc.getFuncionalidade());
                                throw new UnicoMensagemUsuarioException("COM236584", "Para ativar a funcionalidade " + func.getDescricao() + " a funcionalidade " + funcionalidade.getDescricao() + " deve estar ativa.");
                            }
                            achou = true;
                            break;
                        }
                        if (!achou) continue;
                        continue block0;
                    }
                }
            }
            return wrapper;
        }
        Funcionalidade funcionalidadeAgregada = (Funcionalidade)EnumUtils.getPorId(Funcionalidade.class, (Object)wrapper.getFuncionalidadeAtual().getFuncionalidade());
        for (ConfiguradorModulo confModulo : wrapper.getModulos()) {
            List confFuncionalidades = confModulo.getFuncionalidades();
            if (ListMapUtil.listNullOrEmpty((List)confFuncionalidades)) continue;
            for (ConfiguradorFuncionalidade confFunc : confFuncionalidades) {
                List funcionalidadesAgregadas = ((Funcionalidade)EnumUtils.getPorId(Funcionalidade.class, (Object)confFunc.getFuncionalidade())).getInterfaceFuncionalidade().getFuncionalidadesAgregadas();
                if (ListMapUtil.listNullOrEmpty((List)funcionalidadesAgregadas) || !funcionalidadesAgregadas.contains(funcionalidadeAgregada)) continue;
                confFunc.setAtivo(false);
            }
        }
        return wrapper;
    }
}

