/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.modulo.cte.CteManagerWeb;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import org.springframework.stereotype.Component;

@Component
public class ConhecimentoTransporteSaidaComponent {
    private final NotificationService notificationService;

    public ConhecimentoTransporteSaidaComponent(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void verificarValidadeCertificado(CteManagerWeb cteManagerWeb) throws UnicoMensagemUsuarioException {
        String mensagemCertificado = cteManagerWeb.getValidadeCertificado();
        if (!StringUtil.stringNullOrEmpty((String)mensagemCertificado)) {
            this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.WARNING, mensagemCertificado);
        }
    }

    public CteManagerWeb getCteManagerWeb() throws UnicoMensagemUsuarioException {
        CteManagerWeb cteManagerWeb = new CteManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyCteNow(mensagem));
        this.verificarValidadeCertificado(cteManagerWeb);
        return cteManagerWeb;
    }
}

