/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.CTeDistribuicaoInterface;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.NfeDistribuicao;
import br.intelidata.commons.core.documentosfiscais.xstreamconverter.XStreamUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.CondicaoPagamento;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.conhecimento.ConhecimentoComponente;
import br.intelidata.commons.domain.pojo.conhecimento.ConhecimentoTransporte;
import br.intelidata.commons.domain.pojo.conhecimento.ConhecimentoTransporteDocumentoAnterior;
import br.intelidata.commons.domain.pojo.conhecimento.ConhecimentoTransporteNota;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.conhecimento.StatusConhecimento;
import br.intelidata.commons.domain.pojo.enuns.conhecimento.TipoCte;
import br.intelidata.commons.domain.pojo.enuns.conhecimento.TipoDocumentoTransporteAnterior;
import br.intelidata.commons.domain.pojo.enuns.conhecimento.TipoServico;
import br.intelidata.commons.domain.pojo.enuns.nfe.TipoContribuinte;
import br.intelidata.commons.domain.regranegocio.CondicaoPagamentoCommonRN;
import br.intelidata.commons.domain.regranegocio.ConhecimentoObsContribuinteCommonRN;
import br.intelidata.commons.domain.regranegocio.ConhecimentoOutrosDocumentosCommonRN;
import br.intelidata.commons.domain.regranegocio.ConhecimentoTransporteEmissorDocumentoAnteriorCommonRN;
import br.intelidata.commons.domain.regranegocio.ConhecimentoTransporteVeiculoCommonRN;
import br.intelidata.commons.modulo.cte.regranegocio.CalculoImpostoCte;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoComponenteRN;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoTransporteCargaRN;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoTransporteEntregaSimplificadaRN;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoTransporteNotaRN;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoTransporteRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.vendas.regranegocio.CondicaoPagamentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.ConhecimentoTransporteDTO;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.ConhecimentoTransporteSaidaCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.TransmissaoConhecimentoTransporteController;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.wrapper.ConhecimentoFinanceiroWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.wrapper.ConhecimentoImportacaoNfeWrapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public abstract class ConhecimentoTransporteSaidaCrudController
extends TransmissaoConhecimentoTransporteController {
    private final TipoCte tipoCte;

    public ConhecimentoTransporteSaidaCrudController(TipoCte tipoCte) {
        this.tipoCte = tipoCte;
    }

    public String getDescricaoTabela() {
        return "CT-es";
    }

    protected String getCacheId() {
        return "conhecimentos-transporte-saida".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    protected GridBuilder<ConhecimentoTransporteRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("numeroConhecimento", "N\u00famero", 90, true));
        colunas.add(new ColunaSQL("modelo", "Modelo", 90, true));
        colunas.add(new ColunaSQL("serie", "S\u00e9rie", 90, true));
        colunas.add(new ColunaSQL("codigoNaturezaOperacao", "CFOP", 90, true));
        colunas.add(new ColunaSQL("dataHoraEmissao", "Emiss\u00e3o", 130, true));
        colunas.add(new ColunaSQL("tipoCte", "Tipo CT-e", 0, false));
        colunas.add(new ColunaSQL("idRemetente", "Remetente", 0, false));
        colunas.add(new ColunaSQL("idDestinatario", "Destinatario", 0, false));
        colunas.add(new ColunaSQL("nome", "remetente", "Remetente", 250, true, new String[]{"fk_conhecimento_remetente"}));
        colunas.add(new ColunaSQL("nome", "destinatario", "Destinat\u00e1rio", 250, true, new String[]{"fk_conhecimento_destinatario"}));
        ColunaSQL colunaTotal = new ColunaSQL("valorTotalPrestacaoServicos", "Total", 120, true);
        colunaTotal.setTotalizar(true);
        colunas.add(colunaTotal);
        colunas.add(new ColunaSQL("status", "Status", 120, true));
        colunas.add(new ColunaSQL("mensagemProtocoloCte", "Mensagem de retorno", 300, true));
        colunas.add(new ColunaSQL("chaveAcesso", "Chave CT-e", 0, true));
        GridBuilder grid = new GridBuilder(ConhecimentoTransporteRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial", "idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        grid.addReferenciaDefault(new Referencia("dataHoraEmissao"));
        grid.addOrdemDefault(new Ordem("dataHoraEmissao", true));
        return grid;
    }

    @RequestMapping(value={"/gerar-observacao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<String> gerarObservacaoConhecimentoTransporte(@RequestBody ConhecimentoTransporte conhecimentoTransporte) throws UnicoMensagemUsuarioException {
        ConhecimentoTransporteRN.getInstance().buscarDadosImpostoAproximado(SessaoUtil.getSessao(), conhecimentoTransporte);
        String descricaoCondicaoPagamento = CondicaoPagamentoCommonRN.getInstance().buscarValoresPorID(conhecimentoTransporte.getIdCondicaoPagamento(), new String[]{"descricao"}).getOrDefault("descricao", "").toString();
        descricaoCondicaoPagamento = !descricaoCondicaoPagamento.isEmpty() ? descricaoCondicaoPagamento + " (" : " ";
        String obs = ConhecimentoTransporteRN.getInstance().gerarObservacaoConhecimentoTransporte(SessaoUtil.getSessao(), conhecimentoTransporte, descricaoCondicaoPagamento, conhecimentoTransporte.getTipoCte(), conhecimentoTransporte.getDuplicatas(), SessaoUtil.getSessao().getFilial().getEstado());
        return this.responseEntityService.createJSONResponse(obs);
    }

    @RequestMapping(value={"/calcular-impostos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ConhecimentoTransporte calcularImpostos(@RequestBody ConhecimentoTransporte conhecimento) throws UnicoMensagemUsuarioException {
        Entidade tomador;
        conhecimento.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        this.atualizarTipoContribuinte(conhecimento);
        ConhecimentoTransporteRN.getInstance().buscarDadosImpostoAproximado(SessaoUtil.getSessao(), conhecimento);
        new CalculoImpostoCte(conhecimento, conhecimento.getTipoCalculoImposto());
        Long idEstado = null;
        BigDecimal icmsDestino = conhecimento.getIcmsDestino();
        BigDecimal icmsRemetente = conhecimento.getIcmsOrigem();
        BigDecimal icmsFundoPobreza = conhecimento.getIcmsFundoPobreza();
        if (!(Util.bigDecimalNullOrZero((BigDecimal)icmsDestino) && Util.bigDecimalNullOrZero((BigDecimal)icmsRemetente) && Util.bigDecimalNullOrZero((BigDecimal)icmsFundoPobreza) || (tomador = ConhecimentoTransporteRN.getInstance().getTomadorServico(conhecimento)) == null)) {
            idEstado = tomador.getEndereco().getIdEstado();
        }
        conhecimento.setIdEstadoTomador(idEstado);
        return conhecimento;
    }

    @RequestMapping(value={"/gerar-financeiro"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ConhecimentoFinanceiroWrapper geraFinanceiro(@RequestBody ConhecimentoTransporte conhecimento) {
        List parcelas = null;
        BigDecimal total = conhecimento.getValorReceber().subtract(conhecimento.getValorAVista());
        if (total.compareTo(BigDecimal.ZERO) > 0) {
            CondicaoPagamento condicaoPagamento = (CondicaoPagamento)CondicaoPagamentoRN.getInstance().buscarPorId(conhecimento.getIdCondicaoPagamento());
            LocalDate dataEmissao = conhecimento.getDataHoraEmissao() != null ? conhecimento.getDataHoraEmissao().toLocalDate() : null;
            Long idTipoDocumentoFinanceiro = conhecimento.getIdTipoDocumentoFinanceiro();
            Long idTomador = ConhecimentoTransporteRN.getInstance().getIdTomadorServico(conhecimento);
            if (condicaoPagamento != null && dataEmissao != null && !Util.longNullOuZero((Long)idTipoDocumentoFinanceiro)) {
                parcelas = ConhecimentoTransporteRN.getInstance().geraParcelasFinanceiro(total, true, condicaoPagamento, idTomador, dataEmissao, idTipoDocumentoFinanceiro);
            }
        }
        return new ConhecimentoFinanceiroWrapper(parcelas);
    }

    protected void beforeCreate(ConhecimentoTransporte conhecimentoTransporte, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeCreate((AbstractPojo)conhecimentoTransporte, parentId);
        if (conhecimentoTransporte.getTipoCte() == null) {
            conhecimentoTransporte.setTipoCte(this.tipoCte);
        }
    }

    protected void beforeSave(ConhecimentoTransporte conhecimentoTransporte, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeSave((AbstractPojo)conhecimentoTransporte, parentId);
        conhecimentoTransporte.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        this.atualizarTipoContribuinte(conhecimentoTransporte);
        ConhecimentoTransporteRN.getInstance().buscarDadosImpostoAproximado(SessaoUtil.getSessao(), conhecimentoTransporte);
        if (!TipoCte.COMPLEMENTO_VALORES.equals((Object)conhecimentoTransporte.getTipoCte())) {
            boolean possuiDocumentos = !Util.listNullOrEmpty((List)conhecimentoTransporte.getNotasFiscais()) || !Util.listNullOrEmpty((List)conhecimentoTransporte.getOutrosDocumentos());
            boolean redespachoIntermediario = TipoServico.REDESPACHO_INTERMEDIARIO.equals((Object)conhecimentoTransporte.getTipoServico());
            if (!(possuiDocumentos || redespachoIntermediario || conhecimentoTransporte.getTipoCte().isSimplificado())) {
                throw new UnicoMensagemUsuarioException("CTE174", "Nenhum documento/nota fiscal foi informado! Verifique!");
            }
            if (Util.listNullOrEmpty((List)conhecimentoTransporte.getCargas())) {
                throw new UnicoMensagemUsuarioException("CTE175", "Nenhuma carga foi informada! Verifique! ");
            }
            if (!ConhecimentoTransporteRN.getInstance().financeiroValido(conhecimentoTransporte.getDuplicatas(), conhecimentoTransporte.getValorAVista(), conhecimentoTransporte.getValorReceber())) {
                throw new UnicoMensagemUsuarioException("CTE176", "Os valores do financeiro n\u00e3o conferem! Verifique! ");
            }
            if (conhecimentoTransporte.getTipoCte().isSimplificado() && Util.listNullOrEmpty((List)conhecimentoTransporte.getEntregas())) {
                throw new UnicoMensagemUsuarioException("WCTE223", "Nenhum detalhamento da entrega foi informado!");
            }
        }
    }

    protected void beforeRead(ConhecimentoTransporte conhecimentoTransporte, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeRead((AbstractPojo)conhecimentoTransporte, modo, parentId);
        this.atualizarTipoContribuinte(conhecimentoTransporte);
        ConhecimentoTransporteRN.getInstance().buscarDadosImpostoAproximado(SessaoUtil.getSessao(), conhecimentoTransporte);
        if (modo != 0) {
            ConhecimentoTransporte conhecimentoOriginal;
            Long idCte = conhecimentoTransporte.getId();
            if (modo == 7) {
                conhecimentoTransporte.setDataHoraContingencia(null);
                conhecimentoTransporte.setMotivoContigencia(null);
                conhecimentoTransporte.setArquivoXmlAutorizada(null);
                conhecimentoTransporte.setArquivoXmlCancelada(null);
                conhecimentoTransporte.setArquivoXmlContingencia(null);
                conhecimentoTransporte.setArquivoXmlContingenciaEPEC(null);
                conhecimentoTransporte.setContingenciaEPEC(false);
                conhecimentoTransporte.setContingenciaFSDA(false);
                conhecimentoTransporte.setStatus(StatusConhecimento.NORMAL);
                conhecimentoTransporte.setReciboTransmissaoCte(null);
                conhecimentoTransporte.setCodigoStatusTransmissaoCte(null);
                conhecimentoTransporte.setMensagemTransmissaoCte(null);
                conhecimentoTransporte.setRecebimentoCte(null);
                conhecimentoTransporte.setCodigoStatusProtocoloCte(null);
                conhecimentoTransporte.setMensagemProtocoloCte(null);
                conhecimentoTransporte.setProtocoloCte(null);
                conhecimentoTransporte.setDataHoraEmissao(DataHoraFactory.getDataHora());
                conhecimentoTransporte.setIdConhecimentoOrigem(null);
                if (!TipoCte.NORMAL.equals((Object)this.tipoCte)) {
                    conhecimentoTransporte.setNumeroCteOriginal(conhecimentoTransporte.getNumeroConhecimento());
                    conhecimentoTransporte.setSerieCteOriginal(conhecimentoTransporte.getSerie());
                    conhecimentoTransporte.setChaveCteOriginal(conhecimentoTransporte.getChaveAcesso());
                    conhecimentoTransporte.setIdConhecimentoOrigem(conhecimentoTransporte.getId());
                    conhecimentoTransporte.setChaveAcesso(null);
                    if (this.tipoCte.isSubstituto()) {
                        ConhecimentoTransporte cteAnulacaoProcedenteOrigem = ConhecimentoTransporteRN.getInstance().getCteAnuladoPeloCteOrigem(conhecimentoTransporte.getId());
                        if (cteAnulacaoProcedenteOrigem != null) {
                            conhecimentoTransporte.setTomadorContribuinteICMS(false);
                            conhecimentoTransporte.setChaveCTeAnulacao(cteAnulacaoProcedenteOrigem.getChaveAcesso());
                        }
                    } else if (TipoCte.ANULACAO_VALORES.equals((Object)this.tipoCte)) {
                        ConhecimentoTransporteRN.getInstance().validaCteAnulacao(SessaoUtil.getSessao().getFilial(), conhecimentoTransporte);
                        conhecimentoTransporte.setDataDeclaracao(DataHoraFactory.getData());
                        conhecimentoTransporte.setChaveCTeAnulacao(null);
                        conhecimentoTransporte.setChaveCTeTomador(null);
                        conhecimentoTransporte.setChaveNFeTomador(null);
                    } else if (TipoCte.COMPLEMENTO_VALORES.equals((Object)this.tipoCte)) {
                        ConhecimentoTransporte conhecimentoCopia = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().clonar((AbstractPojo)conhecimentoTransporte);
                        conhecimentoTransporte = (ConhecimentoTransporte)BeanUtils.instantiateClass(ConhecimentoTransporte.class);
                        conhecimentoTransporte.setNumeroCteOriginal(conhecimentoCopia.getNumeroConhecimento());
                        conhecimentoTransporte.setSerieCteOriginal(conhecimentoCopia.getSerie());
                        conhecimentoTransporte.setChaveCteOriginal(conhecimentoCopia.getChaveAcesso());
                        conhecimentoTransporte.setIdEstadoOrigem(conhecimentoCopia.getIdEstadoOrigem());
                        conhecimentoTransporte.setIdCidadeOrigem(conhecimentoCopia.getIdCidadeOrigem());
                        conhecimentoTransporte.setIdEstadoDestino(conhecimentoCopia.getIdEstadoDestino());
                        conhecimentoTransporte.setIdCidadeDestino(conhecimentoCopia.getIdCidadeDestino());
                        conhecimentoTransporte.setTomadorServico(conhecimentoCopia.getTomadorServico());
                        conhecimentoTransporte.setIdTomadorOutros(conhecimentoCopia.getIdTomadorOutros());
                        conhecimentoTransporte.setIdNaturezaOperacao(conhecimentoCopia.getIdNaturezaOperacao());
                        conhecimentoTransporte.setIdSerieConhecimentoTransporte(conhecimentoCopia.getIdSerieConhecimentoTransporte());
                        conhecimentoTransporte.setTipoContribuinte(conhecimentoCopia.getTipoContribuinte());
                        conhecimentoTransporte.setIdConhecimentoOrigem(conhecimentoCopia.getId());
                        conhecimentoTransporte.setPossuiValorFinanceiro(null);
                    }
                }
            } else if (!Util.longNullOuZero((Long)conhecimentoTransporte.getIdConhecimentoOrigem()) && (conhecimentoOriginal = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId(conhecimentoTransporte.getIdConhecimentoOrigem())) != null) {
                conhecimentoTransporte.setNumeroCteOriginal(conhecimentoOriginal.getNumeroConhecimento());
                conhecimentoTransporte.setSerieCteOriginal(conhecimentoOriginal.getSerie());
                conhecimentoTransporte.setChaveCteOriginal(conhecimentoOriginal.getChaveAcesso());
            }
            if (!TipoCte.COMPLEMENTO_VALORES.equals((Object)this.tipoCte) || modo != 7) {
                conhecimentoTransporte.setDuplicatas(ConhecimentoTransporteRN.getInstance().buscaFinanceiro(idCte));
                conhecimentoTransporte.setNotasFiscais(ConhecimentoTransporteNotaRN.getInstance().buscaListaPorConhecimento(idCte));
                conhecimentoTransporte.setComponentes(ConhecimentoComponenteRN.getInstance().buscarComponentesPorConhecimento(idCte));
                conhecimentoTransporte.setOutrosDocumentos(ConhecimentoOutrosDocumentosCommonRN.getInstance().buscaListaPorConhecimento(idCte));
                conhecimentoTransporte.setCargas(ConhecimentoTransporteCargaRN.getInstance().buscaListaPorConhecimento(idCte));
                conhecimentoTransporte.setEmissoresAnteriores(ConhecimentoTransporteEmissorDocumentoAnteriorCommonRN.getInstance().buscarListaComDocumentosPorIdConhecimento(idCte));
                conhecimentoTransporte.setObservacoesContribuinte(ConhecimentoObsContribuinteCommonRN.getInstance().buscaListaPorConhecimento(idCte));
                conhecimentoTransporte.setVeiculos(ConhecimentoTransporteVeiculoCommonRN.getInstance().buscaListaPorConhecimento(idCte));
                conhecimentoTransporte.setEntregas(ConhecimentoTransporteEntregaSimplificadaRN.getInstance().buscarEntregasPorConhecimento(idCte, modo == 7));
            }
        }
    }

    private void atualizarTipoContribuinte(ConhecimentoTransporte conhecimento) throws UnicoMensagemUsuarioException {
        TipoContribuinte tipoContribuinte = null;
        Entidade tomador = ConhecimentoTransporteRN.getInstance().getTomadorServico(conhecimento);
        if (tomador != null) {
            tipoContribuinte = tomador.getTipoContribuinte();
        }
        conhecimento.setTipoContribuinte(tipoContribuinte);
    }

    @RequestMapping(value={"/combo-componente"})
    @DBAutoCommit
    public List<ConhecimentoComponente> comboComponentes(@RequestParam Long idCte) {
        return ConhecimentoComponenteRN.getInstance().buscarComponentesPorConhecimento(idCte);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/validar-permissao-incluir-por-tipo"})
    @DBAutoCommit
    public void validarPermissaoIncluir(@RequestParam Long idCte, @RequestParam TipoCte tipo) throws UnicoMensagemUsuarioException {
        ConhecimentoTransporte conhecimento = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId(idCte);
        if (conhecimento == null) throw new UnicoMensagemUsuarioException("CTE184", "N\u00e3o foi poss\u00edvel encontrar um CT-e de origem para inclus\u00e3o de um CT-e de " + tipo);
        if (!StatusConhecimento.CTE_AUTORIZADA.equals((Object)conhecimento.getStatus())) throw new UnicoMensagemUsuarioException("CTE183", "Para incluir um CT-e de " + tipo + " \u00e9 necess\u00e1rio que o CT-e de origem esteja autorizado");
        if (tipo.isSubstituto()) {
            ConhecimentoTransporteRN.getInstance().validaCteSubstituicao(SessaoUtil.getSessao().getFilial(), conhecimento);
            return;
        } else {
            if (!TipoCte.NORMAL.equals((Object)conhecimento.getTipoCte())) throw new UnicoMensagemUsuarioException("CTE182", "Para incluir um CT-e de " + tipo + " \u00e9 necess\u00e1rio que o CT-e de origem seja do tipo Normal");
            if (TipoCte.ANULACAO_VALORES.equals((Object)tipo)) {
                ConhecimentoTransporteRN.getInstance().validaCteAnulacao(SessaoUtil.getSessao().getFilial(), conhecimento);
                return;
            } else {
                if (!TipoCte.COMPLEMENTO_VALORES.equals((Object)tipo)) return;
                ConhecimentoTransporteRN.getInstance().validaCteComplementar(conhecimento);
                int qtdCtesComplementares = ConhecimentoTransporteRN.getInstance().countConhecimentosComplementares(conhecimento.getId());
                if (qtdCtesComplementares < 10) return;
                throw new UnicoMensagemUsuarioException("CTE181", "S\u00f3 \u00e9 permitido incluir 10 CT-e's complementares para cada CT-e");
            }
        }
    }

    @RequestMapping(value={"/importar-xml-nfe"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public ConhecimentoImportacaoNfeWrapper importarXmlNfe(@RequestPart MultipartFile[] files, @RequestPart(value="conhecimento") ConhecimentoTransporte conhecimento) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.arrayNullOrEmpty((Object[])files)) {
            throw new UnicoMensagemUsuarioException("CTE185", "Arquivos n\u00e3o informados.");
        }
        ArrayList<NfeDistribuicao> listaArquivos = new ArrayList<NfeDistribuicao>();
        for (MultipartFile file : files) {
            try {
                NfeDistribuicao nfeDistribuicao = (NfeDistribuicao)XStreamUtil.toObject((String)Util.byteArrayToString((byte[])file.getBytes()), (Class[])new Class[]{NfeDistribuicao.class});
                listaArquivos.add(nfeDistribuicao);
            }
            catch (Throwable ex) {
                throw new UnicoMensagemUsuarioException("CTE187", "Arquivo XML inv\u00e1lido.", ex);
            }
        }
        ConhecimentoImportacaoNfeWrapper retorno = new ConhecimentoImportacaoNfeWrapper();
        if (conhecimento.getTipoCte().in(new AbstractEnum[]{TipoCte.SIMPLIFICADO, TipoCte.SUBSTITUTO_SIMPLIFICADO})) {
            retorno.setEntregas(ConhecimentoTransporteRN.getInstance().gerarEntregas(listaArquivos, conhecimento.getEntregas()));
            retorno.setProdutoPredominante(ConhecimentoTransporteRN.getInstance().buscarProdutoPredominante(retorno.getEntregas().stream().flatMap(e -> ConhecimentoTransporteRN.getInstance().buscaListaArquivosItensJaGravados(e.getNotasFiscais()).stream()).collect(Collectors.toList())));
        } else {
            if (conhecimento.getNotasFiscais() != null) {
                for (ConhecimentoTransporteNota notaGravada : conhecimento.getNotasFiscais()) {
                    if (ModeloNotaFiscal.NOTA_FISCAL_ELETRONICA.equals((Object)notaGravada.getModelo())) continue;
                    throw new UnicoMensagemUsuarioException("CTE186", "Modelo inv\u00e1lido para notas j\u00e1 informadas!");
                }
            }
            String cnpjCpfDestinatarioAgrupador = null;
            String cnpjCpfRemetenteAgrupador = null;
            Entidade remetente = null;
            if (!Util.longNullOuZero((Long)conhecimento.getIdRemetente()) && (remetente = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdRemetente())) != null) {
                cnpjCpfRemetenteAgrupador = remetente.getCnpjCpf();
            }
            Entidade destinatario = null;
            if (!Util.longNullOuZero((Long)conhecimento.getIdDestinatario()) && (destinatario = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdDestinatario())) != null) {
                cnpjCpfDestinatarioAgrupador = destinatario.getCnpjCpf();
            }
            boolean cteGlobalizado = conhecimento.isGlobalizado();
            ConhecimentoTransporteRN.getInstance().validaDadosXml(listaArquivos, cnpjCpfDestinatarioAgrupador, cnpjCpfRemetenteAgrupador, conhecimento.getNotasFiscais(), cteGlobalizado);
            if (!cteGlobalizado && remetente == null && (remetente = ConhecimentoTransporteRN.getInstance().verificaSeExisteRemetente(SessaoUtil.getSessao(), listaArquivos)) == null) {
                Long idRemetente = EntidadeRN.getInstance().cadastraEntidadeNaoEncontradaXml(SessaoUtil.getSessao(), ((NfeDistribuicao)listaArquivos.get(0)).getNfeXML().getInformacao().getEmitente(), 0, 1);
                remetente = (Entidade)EntidadeRN.getInstance().buscarPorId(idRemetente);
            }
            if (!cteGlobalizado && destinatario == null && (destinatario = ConhecimentoTransporteRN.getInstance().verificaSeExisteDestinatario(SessaoUtil.getSessao(), listaArquivos)) == null) {
                Long idDestinatario = EntidadeRN.getInstance().cadastraDestinatarioNaoEncontradoXml(SessaoUtil.getSessao(), ((NfeDistribuicao)listaArquivos.get(0)).getNfeXML().getInformacao().getDestinatario(), 1);
                destinatario = (Entidade)EntidadeRN.getInstance().buscarPorId(idDestinatario);
            }
            List listaBuscaProdPre = ConhecimentoTransporteRN.getInstance().buscaListaArquivosItensJaGravados(conhecimento.getNotasFiscais());
            listaBuscaProdPre.addAll(listaArquivos);
            String produtoPredominante = ConhecimentoTransporteRN.getInstance().buscarProdutoPredominante(listaBuscaProdPre);
            if (remetente != null) {
                retorno.setIdRemetente(remetente.getId());
                retorno.setIdExpedidor(remetente.getId());
                retorno.setIdEstadoOrigem(remetente.getEndereco().getIdEstado());
                retorno.setIdCidadeOrigem(remetente.getEndereco().getIdCidade());
            }
            if (destinatario != null) {
                retorno.setIdDestinatario(destinatario.getId());
                retorno.setIdRecebedor(destinatario.getId());
                retorno.setIdEstadoDestino(destinatario.getEndereco().getIdEstado());
                retorno.setIdCidadeDestino(destinatario.getEndereco().getIdCidade());
            }
            retorno.setProdutoPredominante(produtoPredominante);
            retorno.setNotasFiscais(ConhecimentoTransporteRN.getInstance().buscaConhecimentosNota(listaArquivos));
        }
        return retorno;
    }

    @RequestMapping(value={"/importar-xml-cte"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBAutoCommit
    public ConhecimentoTransporteDocumentoAnterior importarXmlCte(MultipartFile file) throws UnicoMensagemUsuarioException {
        CTeDistribuicaoInterface cte;
        try {
            cte = (CTeDistribuicaoInterface)XStreamUtil.toObjectCte((String)Util.byteArrayToString((byte[])file.getBytes()));
        }
        catch (Throwable e1) {
            throw new UnicoMensagemUsuarioException("CTE188", "N\u00e3o foi poss\u00edvel importar o XML de CT-e informado");
        }
        if (cte != null) {
            ConhecimentoTransporteDocumentoAnterior documentoAnterior = new ConhecimentoTransporteDocumentoAnterior();
            documentoAnterior.setTipoDocumento(TipoDocumentoTransporteAnterior.CONHECIMENTO_TRANSPORTE_ELETRONICO);
            documentoAnterior.setDescTipoDocumento(TipoDocumentoTransporteAnterior.CONHECIMENTO_TRANSPORTE_ELETRONICO.toString());
            documentoAnterior.setChaveAcesso(cte.getCteXML().getChaveAcesso());
            return documentoAnterior;
        }
        return null;
    }

    @RequestMapping(value={"/ctes-mdfe"})
    @DBAutoCommit
    public List<ConhecimentoTransporteDTO> buscarConhecimentosAutoCompleteMDFEWeb(@RequestParam(value="limit", required=false, defaultValue="0") int limit, @RequestParam(value="query", required=false) String query) {
        return this.buscarConhecimentosAutoCompleteMDFEWeb(limit, query, null);
    }

    @RequestMapping(value={"/ctes-mdfe-por-id/{id}"})
    @DBAutoCommit
    public List<ConhecimentoTransporteDTO> buscarConhecimentosAutoCompleteMDFEWebPorID(@PathVariable Long id) {
        return this.buscarConhecimentosAutoCompleteMDFEWeb(0, null, id);
    }

    public List<ConhecimentoTransporteDTO> buscarConhecimentosAutoCompleteMDFEWeb(int limit, String query, Long id) {
        return ConhecimentoTransporteRN.getInstance().buscarConhecimentosAutoCompleteMDFEWeb(SessaoUtil.getSessao().getIdFilial(), limit, query, id).stream().map(con -> {
            ConhecimentoTransporteDTO dto = new ConhecimentoTransporteDTO();
            dto.setId((Object)con.getId());
            dto.setNumeroConhecimento(con.getNumeroConhecimento());
            dto.setSerie(con.getSerie());
            dto.setDataHoraEmissao(con.getDataHoraEmissao());
            dto.setValorTotalPrestacaoServicos(con.getValorTotalPrestacaoServicos());
            dto.setChaveAcesso(con.getChaveAcesso());
            dto.setIdCidadeDestino(con.getIdCidadeDestino());
            return dto;
        }).collect(Collectors.toList());
    }

    @RequestMapping(value={"/buscar-dados-email"})
    @DBAutoCommit
    public String buscarDadosEmail(@RequestParam Long id) {
        ConhecimentoTransporte conhecimento = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId(id);
        String emailCC = "";
        String emailCCPadrao = (String)PropriedadeRN.getInstance().getPropriedade(SessaoUtil.getSessao().getFilial(), 854);
        Entidade remetente = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdRemetente());
        Entidade destinatario = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdDestinatario());
        switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$conhecimento$TomadorServico[conhecimento.getTomadorServico().ordinal()]) {
            case 1: {
                remetente = null;
                break;
            }
            case 2: {
                destinatario = null;
            }
        }
        if (remetente != null) {
            emailCC = remetente.getEmail();
        }
        if (destinatario != null) {
            emailCC = emailCC + (!Util.stringNullOrEmpty((String)emailCC) ? ";" : "") + destinatario.getEmail();
        }
        if (!Util.stringNullOrEmpty((String)emailCCPadrao)) {
            emailCC = emailCC + (!Util.stringNullOrEmpty((String)emailCC) ? ";" : "") + emailCCPadrao;
        }
        return emailCC;
    }
}

